/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eso.util.dal.ConnectionServiceException;
import org.eso.util.dal.DAOException;
import org.eso.util.dal.PackageFile;
import org.eso.util.dal.PackageFilesDAO;
import org.eso.util.dal.SybaseConnectionService;

public class PackageFilesDAOSyb
implements PackageFilesDAO {
    static final Logger logger = Logger.getLogger(PackageFilesDAOSyb.class);
    private static final String classLogName = "PackageFilesDAOSyb";
    public static final String PACKAGEID_KW = "pkg_id";
    public static final String INGESTIONDATE_KW = "ingestion_date";
    public static final String ACQUISITIONDATE_KW = "acquisition_date";
    public static final String FILENAME_KW = "file_name";
    public static final String FILEID_KW = "file_id";
    public static final String FILEPATH_KW = "file_path";
    public static final String FILETYPE_KW = "file_type";
    public static final String LASTMODDATE_KW = "last_mod_date";
    public static final String QUALITYFLAG_KW = "quality_flag";
    public static final String DPID_KW = "dp_id";
    private Connection d_connection = null;
    private String d_dbTable = null;
    private Connection d_dbcmConnection = null;
    private String d_dbcmDbTable = null;

    public PackageFilesDAOSyb(Connection conn, String dbTable) throws DAOException {
        this.d_connection = conn;
        this.d_dbTable = dbTable;
    }

    public PackageFilesDAOSyb(Connection conn, String dbTable, Connection dbcmConn, String dbcmDbTable) throws DAOException {
        this(conn, dbTable);
        this.d_dbcmConnection = dbcmConn;
        this.d_dbcmDbTable = dbcmDbTable;
    }

    @Override
    public void delete(List<PackageFile> files) throws DAOException {
        ArrayList<String> statements = new ArrayList<String>();
        for (PackageFile file : files) {
            String query = "DELETE FROM " + this.d_dbTable + " WHERE " + PACKAGEID_KW + "=" + file.getPackageId() + " AND " + FILEPATH_KW + "='" + file.getFilePath() + "' AND " + FILENAME_KW + "='" + file.getFileName() + "'";
            statements.add(query);
        }
        try {
            SybaseConnectionService.executeBatchedStatement(this.d_connection, statements);
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
    }

    @Override
    public List<PackageFile> find(Integer pkg_id, Timestamp start, Timestamp stop) throws DAOException {
        String query = "SELECT * FROM " + this.d_dbTable + " WHERE " + PACKAGEID_KW + " = " + pkg_id;
        query = query + " AND acquisition_date BETWEEN dateadd(ss, " + (long)((double)start.getTime() * 0.001) + ", '01 Jan 1970') ";
        query = query + " AND dateadd(ss, " + (long)((double)stop.getTime() * 0.001) + ", '01 Jan 1970') ";
        try {
            ResultSet rs = SybaseConnectionService.executeStatement(this.d_connection, query);
            ArrayList<PackageFile> files = new ArrayList<PackageFile>();
            while (rs.next()) {
                PackageFile file = new PackageFile();
                file.setPackageId(rs.getInt(PACKAGEID_KW));
                file.setIngestionDate(rs.getTimestamp(INGESTIONDATE_KW));
                file.setAcquisitionDate(rs.getTimestamp(ACQUISITIONDATE_KW));
                file.setFileName(rs.getString(FILENAME_KW));
                file.setFileId(rs.getString(FILEID_KW));
                file.setFilePath(rs.getString(FILEPATH_KW));
                file.setFileType(PackageFile.Type.get(rs.getString(FILETYPE_KW)));
                files.add(file);
            }
            return files;
        }
        catch (SQLException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (ConnectionServiceException e3) {
            throw new DAOException(e3.getMessage());
        }
    }

    @Override
    public List<PackageFile> find(List<PackageFile> files) throws DAOException {
        ArrayList<PackageFile> res = new ArrayList<PackageFile>();
        for (int i = 0; i <= files.size() / 100; ++i) {
            int start = i * 100;
            int stop = Math.min((i + 1) * 100, files.size());
            if (start == stop) continue;
            res.addAll(this.find(files, start, stop));
        }
        return res;
    }

    private List<PackageFile> find(List<PackageFile> files, int startIdx, int stopIdx) throws DAOException {
        String query = "SELECT * FROM " + this.d_dbTable + " WHERE ";
        for (int i = startIdx; i < stopIdx; ++i) {
            PackageFile file = files.get(i);
            query = query + " ( pkg_id =  " + file.getPackageId();
            query = query + " AND file_path + file_name = '" + file.getFilePath() + "' + '" + file.getFileName() + "') OR ";
        }
        query = query.substring(0, query.length() - 4);
        try {
            ResultSet rs = SybaseConnectionService.executeStatement(this.d_connection, query);
            ArrayList<PackageFile> res = new ArrayList<PackageFile>();
            while (rs.next()) {
                PackageFile file = new PackageFile();
                file.setPackageId(rs.getInt(PACKAGEID_KW));
                file.setIngestionDate(rs.getTimestamp(INGESTIONDATE_KW));
                file.setAcquisitionDate(rs.getTimestamp(ACQUISITIONDATE_KW));
                file.setFileName(rs.getString(FILENAME_KW));
                file.setFileId(rs.getString(FILEID_KW));
                file.setFilePath(rs.getString(FILEPATH_KW));
                file.setFileType(PackageFile.Type.get(rs.getString(FILETYPE_KW)));
                res.add(file);
            }
            return res;
        }
        catch (SQLException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (ConnectionServiceException e3) {
            throw new DAOException(e3.getMessage());
        }
    }

    @Override
    public void insert(List<PackageFile> files) throws DAOException {
        ArrayList<String> statements = new ArrayList<String>();
        for (PackageFile file : files) {
            String columns = "(pkg_id,ingestion_date,acquisition_date,file_name,file_id,file_type,file_path)";
            String values = "(" + file.getPackageId() + ",'" + file.getIngestionDate() + "','" + file.getAcquisitionDate() + "','" + file.getFileName() + "','" + file.getFileId() + "','" + file.getFileType().toString() + "','" + file.getFilePath() + "')";
            String query = "INSERT INTO " + this.d_dbTable + " " + columns + " VALUES " + values;
            statements.add(query);
        }
        try {
            SybaseConnectionService.executeBatchedStatement(this.d_connection, statements);
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
    }

    @Override
    public void insertIfNotFound(List<PackageFile> files) throws DAOException {
        List<PackageFile> notToInsert = this.find(files);
        ArrayList<PackageFile> toInsert = new ArrayList<PackageFile>();
        for (PackageFile f : files) {
            if (notToInsert.contains(f)) continue;
            logger.info("Inserting [" + f.getFilePath() + System.getProperty("file.separator") + f.getFileName() + "]");
            toInsert.add(f);
        }
        this.insert(toInsert);
    }

    @Override
    public boolean findByQCFilename(Integer pkgId, String filePath, String qcFilename) throws DAOException {
        String query = "SELECT * FROM " + this.d_dbTable + " WHERE ";
        query = query + "pkg_id =  " + pkgId + " AND " + FILEPATH_KW + " = " + " '" + filePath + "'";
        query = query + " AND file_name =  '" + qcFilename + "'";
        try {
            ResultSet rs = SybaseConnectionService.executeStatement(this.d_connection, query);
            return rs.next();
        }
        catch (SQLException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (ConnectionServiceException e3) {
            throw new DAOException(e3.getMessage());
        }
    }

    @Override
    public int addHotflyData(PackageFile file) throws DAOException {
        int retStatus = -1;
        String query = "select dp_id,ingestion_date,last_mod_date,quality_flag from dbcm.dp_tracking where dp_id='" + file.getFileId() + "'";
        try {
            ResultSet rs = SybaseConnectionService.executeStatement(this.d_dbcmConnection, query);
            while (rs.next()) {
                file.setKeyRepIngestionDate(rs.getDate(INGESTIONDATE_KW));
                file.setKeyRepLastModificationDate(rs.getDate(LASTMODDATE_KW));
                file.setKeyRepQualityFlag(rs.getInt(QUALITYFLAG_KW));
                retStatus = 0;
            }
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (SQLException e3) {
            throw new DAOException(e3.getMessage());
        }
        return retStatus;
    }
}

