/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.configuration;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.eso.util.configuration.Configuration;
import org.eso.util.configuration.ConfigurationOption;
import org.eso.util.configuration.MetaConfigurationError;

final class MetaConfigurator {
    static final Logger logger = Logger.getLogger(MetaConfigurator.class);
    private static final String classLogName = "MetaConfigurator";
    static final List<String> mandatoryMetaConfigurationProperties = Collections.unmodifiableList(Arrays.asList("application.name", "application.command", "application.version", "application.help.header.text", "application.help.footer.text"));
    private static final List<String> optionMetaConfigurationProperties = Collections.unmodifiableList(Arrays.asList("type", "sources", "command.line.name", "command.line.char", "property.name", "default.value", "help.text"));

    private MetaConfigurator() {
        String methodLogName = "MetaConfigurator::MetaConfigurator()";
        logger.trace("MetaConfigurator::MetaConfigurator()");
    }

    static void metaConfigure(Configuration configuration, String metaConfigurationFilePath) throws NullPointerException, MetaConfigurationError {
        String methodLogName = "MetaConfigurator::metaConfigure()";
        logger.trace("MetaConfigurator::metaConfigure()");
        if (configuration == null || metaConfigurationFilePath == null) {
            String message = "MetaConfigurator::metaConfigure() - configuration [" + configuration + "] and metaConfigurationFilePath [" + metaConfigurationFilePath + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        if (configuration.constructionComplete()) {
            String message = "MetaConfigurator::metaConfigure() - this configuration has already been meta-configured.";
            logger.fatal("MetaConfigurator::metaConfigure() - this configuration has already been meta-configured.");
            throw new MetaConfigurationError("MetaConfigurator::metaConfigure() - this configuration has already been meta-configured.");
        }
        logger.debug("MetaConfigurator::metaConfigure() - commencing meta-configuration.");
        InputStream metaConfigurationStream = ClassLoader.getSystemResourceAsStream(metaConfigurationFilePath);
        if (metaConfigurationStream == null) {
            String message = "MetaConfigurator::metaConfigure() - meta-configuration file [" + metaConfigurationFilePath + "] could not be found on the JVM's classpath.";
            logger.fatal(message);
            throw new MetaConfigurationError(message);
        }
        logger.debug("MetaConfigurator::metaConfigure() - opened meta-configuration file [" + metaConfigurationFilePath + "].");
        Properties metaConfigurationProperties = new Properties();
        try {
            metaConfigurationProperties.load(metaConfigurationStream);
        }
        catch (Exception e2) {
            String message = "MetaConfigurator::metaConfigure() - meta-configuration properties could not be loaded from file [" + metaConfigurationFilePath + "].";
            logger.fatal(message);
            throw new MetaConfigurationError(message, e2);
        }
        logger.debug("MetaConfigurator::metaConfigure() - loaded meta-configuration properties from file [" + metaConfigurationFilePath + "].");
        Iterator<String> mandatoryMetaConfigurationPropertyIterator = mandatoryMetaConfigurationProperties.iterator();
        String currentMandatoryMetaConfigurationProperty = null;
        String propertyValue = null;
        while (mandatoryMetaConfigurationPropertyIterator.hasNext()) {
            currentMandatoryMetaConfigurationProperty = mandatoryMetaConfigurationPropertyIterator.next();
            propertyValue = metaConfigurationProperties.getProperty(currentMandatoryMetaConfigurationProperty);
            if (propertyValue == null) {
                String message = "MetaConfigurator::metaConfigure() - mandatory property [" + currentMandatoryMetaConfigurationProperty + " is missing from meta-configuration file [" + metaConfigurationFilePath + "].";
                logger.fatal(message);
                throw new MetaConfigurationError(message);
            }
            configuration.addOption(new ConfigurationOption(currentMandatoryMetaConfigurationProperty, 1, 1, 1, "", '\u0000', "", null, propertyValue, propertyValue, ""));
            logger.debug("MetaConfigurator::metaConfigure() - mandatory property [" + currentMandatoryMetaConfigurationProperty + "][" + propertyValue + "] stored in configuration.");
        }
        logger.debug("MetaConfigurator::metaConfigure() - " + mandatoryMetaConfigurationProperties.size() + " mandatory meta-configuration propert" + (mandatoryMetaConfigurationProperties.size() == 1 ? "y" : "ies") + " loaded.");
        String[] applicationOptions = MetaConfigurator.findOptionPropertyNames(metaConfigurationProperties);
        ConfigurationOption currentOption = null;
        for (int i = 0; i < applicationOptions.length; ++i) {
            currentOption = MetaConfigurator.metaConfigureOption(metaConfigurationProperties, applicationOptions[i]);
            configuration.addOption(currentOption);
            logger.debug("MetaConfigurator::metaConfigure() - application option [" + applicationOptions[i] + "] stored in configuration as [" + currentOption.optionName + "].");
        }
        logger.debug("MetaConfigurator::metaConfigure() - meta-configured " + applicationOptions.length + " application option" + (applicationOptions.length == 1 ? "." : "s."));
        logger.debug("MetaConfigurator::metaConfigure() - meta-configuration complete.");
    }

    private static String[] findOptionPropertyNames(Properties metaConfigurationProperties) throws NullPointerException {
        String methodLogName = "MetaConfigurator::findOptionPropertyNames()";
        logger.trace("MetaConfigurator::findOptionPropertyNames()");
        if (metaConfigurationProperties == null) {
            String message = "MetaConfigurator::findOptionPropertyNames() - metaConfigurationProperties must not be null.";
            logger.fatal("MetaConfigurator::findOptionPropertyNames() - metaConfigurationProperties must not be null.");
            throw new NullPointerException("MetaConfigurator::findOptionPropertyNames() - metaConfigurationProperties must not be null.");
        }
        Enumeration<?> allPropertyNames = metaConfigurationProperties.propertyNames();
        String sampleSuffix = "." + optionMetaConfigurationProperties.get(0);
        TreeSet<String> optionPropertyNames = new TreeSet<String>();
        String currentPropertyName = null;
        while (allPropertyNames.hasMoreElements()) {
            currentPropertyName = (String)allPropertyNames.nextElement();
            if (!currentPropertyName.endsWith(sampleSuffix)) continue;
            currentPropertyName = currentPropertyName.substring(0, currentPropertyName.length() - sampleSuffix.length());
            optionPropertyNames.add(currentPropertyName);
            logger.debug("MetaConfigurator::findOptionPropertyNames() - discovered option property name [" + currentPropertyName + "].");
        }
        logger.debug("MetaConfigurator::findOptionPropertyNames() - " + optionPropertyNames.size() + " option property name" + (optionPropertyNames.size() == 1 ? "" : "s") + " discovered.");
        String[] optionPropertyNameArray = new String[optionPropertyNames.size()];
        return optionPropertyNames.toArray(optionPropertyNameArray);
    }

    private static ConfigurationOption metaConfigureOption(Properties metaConfigurationProperties, String optionName) throws NullPointerException, MetaConfigurationError {
        String methodLogName = "MetaConfigurator::metaConfigureOption()";
        logger.trace("MetaConfigurator::metaConfigureOption()");
        if (metaConfigurationProperties == null || optionName == null) {
            String message = "MetaConfigurator::metaConfigureOption() - metaConfigurationProperties [" + metaConfigurationProperties + "] and optionName [" + optionName + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        if (optionName.equals("")) {
            String message = "MetaConfigurator::metaConfigureOption() - the application option name must not be blank.";
            logger.fatal("MetaConfigurator::metaConfigureOption() - the application option name must not be blank.");
            throw new MetaConfigurationError("MetaConfigurator::metaConfigureOption() - the application option name must not be blank.");
        }
        if (optionName.matches("\\s")) {
            String message = "MetaConfigurator::metaConfigureOption() - the application option name [" + optionName + "] must not contain whitespace.";
            logger.fatal(message);
            throw new MetaConfigurationError(message);
        }
        HashMap<String, String> propertyNameMap = new HashMap<String, String>();
        Iterator<String> optionMetaConfigurationPropertyIterator = optionMetaConfigurationProperties.iterator();
        String currentOptionMetaConfigurationProperty = null;
        while (optionMetaConfigurationPropertyIterator.hasNext()) {
            currentOptionMetaConfigurationProperty = optionMetaConfigurationPropertyIterator.next();
            propertyNameMap.put(currentOptionMetaConfigurationProperty, optionName + "." + currentOptionMetaConfigurationProperty);
        }
        String optionTypeString = metaConfigurationProperties.getProperty((String)propertyNameMap.get("type"), "").trim();
        String validValueSourcesString = metaConfigurationProperties.getProperty((String)propertyNameMap.get("sources"), "").trim();
        String commandLineName = metaConfigurationProperties.getProperty((String)propertyNameMap.get("command.line.name"), "").trim();
        String commandLineCharString = metaConfigurationProperties.getProperty((String)propertyNameMap.get("command.line.char"), "").trim();
        String propertyName = metaConfigurationProperties.getProperty((String)propertyNameMap.get("property.name"), "").trim();
        String defaultValueString = metaConfigurationProperties.getProperty((String)propertyNameMap.get("default.value"), "").trim();
        String helpText = metaConfigurationProperties.getProperty((String)propertyNameMap.get("help.text"), "").trim();
        int optionType = 0;
        int validValueSources = 0;
        int actualValueSource = 0;
        char commandLineChar = '\u0000';
        Object defaultValue = null;
        if (optionTypeString.equals("")) {
            String message = "MetaConfigurator::metaConfigureOption() - meta-configuration property [" + (String)propertyNameMap.get("type") + "] must specify a valid data type.";
            logger.fatal(message);
            throw new MetaConfigurationError(message);
        }
        if (optionTypeString.equalsIgnoreCase("STRING")) {
            optionType = 1;
        } else if (optionTypeString.equalsIgnoreCase("BOOLEAN")) {
            optionType = 2;
        } else if (optionTypeString.equalsIgnoreCase("INTEGER")) {
            optionType = 3;
        } else {
            String message = "MetaConfigurator::metaConfigureOption() - meta-configuration property [" + (String)propertyNameMap.get("type") + "] specified an unknown data type [" + optionTypeString + "].";
            logger.fatal(message);
            throw new MetaConfigurationError(message);
        }
        logger.debug("MetaConfigurator::metaConfigureOption() - application option [" + optionName + "] has data type [" + optionTypeString.toUpperCase() + "].");
        String[] validValueSourceArray = validValueSourcesString.split(",");
        for (int i = 0; i < validValueSourceArray.length; ++i) {
            validValueSourceArray[i] = validValueSourceArray[i].trim();
            if (validValueSourceArray[i].equalsIgnoreCase("DefaultValue")) {
                validValueSources |= 1;
                continue;
            }
            if (validValueSourceArray[i].equalsIgnoreCase("ApplicationProperty")) {
                validValueSources |= 2;
                continue;
            }
            if (validValueSourceArray[i].equalsIgnoreCase("SystemProperty")) {
                validValueSources |= 4;
                continue;
            }
            if (validValueSourceArray[i].equalsIgnoreCase("CommandLine")) {
                validValueSources |= 8;
                continue;
            }
            if (validValueSourceArray[i].equalsIgnoreCase("InternalConfiguration")) {
                validValueSources |= 0x10;
                continue;
            }
            if (validValueSourceArray[i].equalsIgnoreCase("AllSources")) {
                validValueSources |= 0x1F;
                continue;
            }
            String message = "MetaConfigurator::metaConfigureOption() - meta-configuration property [" + (String)propertyNameMap.get("sources") + "] specified an unknown source [" + validValueSourceArray[i] + "] for the option's value.";
            logger.fatal(message);
            throw new MetaConfigurationError(message);
        }
        if (validValueSources == 0) {
            String message = "MetaConfigurator::metaConfigureOption() - meta-configuration property [" + (String)propertyNameMap.get("sources") + "] must specify at least one permissible source" + " for the option's value.";
            logger.fatal(message);
            throw new MetaConfigurationError(message);
        }
        logger.debug("MetaConfigurator::metaConfigureOption() - application option [" + optionName + "] can be set by [" + ConfigurationOption.getValueSourceString(validValueSources) + "].");
        if (ConfigurationOption.isValidValueSource(8, validValueSources)) {
            if (commandLineName.equals("") && commandLineCharString.equals("")) {
                String message = "MetaConfigurator::metaConfigureOption() - application option [" + optionName + "] is a command line option." + " At least one of the meta-configuration properties [" + (String)propertyNameMap.get("command.line.name") + "] and [" + (String)propertyNameMap.get("command.line.char") + "] must be specified.";
                logger.fatal(message);
                throw new MetaConfigurationError(message);
            }
            if (commandLineCharString.length() > 1) {
                String message = "MetaConfigurator::metaConfigureOption() - meta-configuration property [" + (String)propertyNameMap.get("command.line.char") + "] may only specify a single character.";
                logger.fatal(message);
                throw new MetaConfigurationError(message);
            }
            if (commandLineCharString.length() == 1) {
                commandLineChar = commandLineCharString.charAt(0);
            }
            logger.debug("MetaConfigurator::metaConfigureOption() - application option [" + optionName + "] is a command line option with long name [" + commandLineName + "] and short name [" + commandLineChar + "].");
        } else if (!commandLineName.equals("") || !commandLineCharString.equals("")) {
            logger.warn("MetaConfigurator::metaConfigureOption() - application option [" + optionName + "] is not a command line option." + " The meta-configuration properties [" + (String)propertyNameMap.get("command.line.name") + "] and [" + (String)propertyNameMap.get("command.line.char") + "] are redundant.");
        }
        if (ConfigurationOption.isValidValueSource(2, validValueSources) || ConfigurationOption.isValidValueSource(4, validValueSources)) {
            if (propertyName.equals("")) {
                propertyName = optionName;
            }
            logger.debug("MetaConfigurator::metaConfigureOption() - application option [" + optionName + "] is a system or application property with name [" + propertyName + "].");
        } else if (!propertyName.equals("")) {
            logger.warn("MetaConfigurator::metaConfigureOption() - application option [" + optionName + "] is not a system or application property." + " The meta-configuration property [" + (String)propertyNameMap.get("property.name") + "] is redundant.");
        }
        if (ConfigurationOption.isValidValueSource(1, validValueSources)) {
            if (defaultValueString.equals("") && (optionType != 1 || metaConfigurationProperties.getProperty((String)propertyNameMap.get("default.value")) == null)) {
                String message = "MetaConfigurator::metaConfigureOption() - application option [" + optionName + "] should have a default value." + "The meta-configuration property [" + (String)propertyNameMap.get("default.value") + "] must be used to specify one.";
                logger.fatal(message);
                throw new MetaConfigurationError(message);
            }
            switch (optionType) {
                case 1: {
                    defaultValue = defaultValueString;
                    break;
                }
                case 2: {
                    defaultValue = Boolean.valueOf(defaultValueString);
                    break;
                }
                case 3: {
                    try {
                        defaultValue = Integer.valueOf(defaultValueString);
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        String message = "MetaConfigurator::metaConfigureOption() - the default value [" + defaultValueString + "] specified by meta-configuration property [" + (String)propertyNameMap.get("default.value") + "] could not be parsed as an INTEGER value [" + nfe.getMessage() + "].";
                        logger.fatal(message);
                        throw new MetaConfigurationError(message);
                    }
                }
                default: {
                    String message = "MetaConfigurator::metaConfigureOption() - invalid optionType [" + ConfigurationOption.getTypeString(optionType) + "] encountered whilst processing meta-configuration" + " property [" + (String)propertyNameMap.get("default.value") + "].";
                    logger.fatal(message);
                    throw new AssertionError((Object)message);
                }
            }
            actualValueSource = 1;
            logger.debug("MetaConfigurator::metaConfigureOption() - application option [" + optionName + "] has default value [" + defaultValueString + "], parsed as [" + defaultValue + "].");
        } else if (!defaultValueString.equals("")) {
            logger.warn("MetaConfigurator::metaConfigureOption() - application option [" + optionName + "] does not have a default value." + " The meta-configuration property [" + (String)propertyNameMap.get("default.value") + "] is redundant.");
        }
        return new ConfigurationOption(optionName, optionType, validValueSources, actualValueSource, commandLineName, commandLineChar, propertyName, null, defaultValue, defaultValue, helpText);
    }
}

