/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.archive;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.log4j.Logger;
import org.eso.util.archive.NgasRedirectResponseException;

public class NgasStreamResponseHandler
implements ResponseHandler<InputStream> {
    static final Logger logger = Logger.getLogger(NgasStreamResponseHandler.class);

    @Override
    public InputStream handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        if (statusCode == 303) {
            String newLocation = response.getFirstHeader("location").getValue().replace("\"", "");
            throw new NgasRedirectResponseException(newLocation, statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        if (statusCode != 200) {
            throw new ClientProtocolException(response.getStatusLine().toString());
        }
        return response.getEntity().getContent();
    }
}

