/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.archive;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.log4j.Logger;
import org.eso.util.archive.NgasRedirectResponseException;

public class NgasFileResponseHandler
implements ResponseHandler<File> {
    static final Logger logger = Logger.getLogger(NgasFileResponseHandler.class);
    private final String downloadDir;
    private final boolean overwrite;

    public NgasFileResponseHandler(String downloadDir, boolean overwrite) {
        this.downloadDir = downloadDir;
        this.overwrite = overwrite;
    }

    public NgasFileResponseHandler(String downloadDir) {
        this.downloadDir = downloadDir;
        this.overwrite = true;
    }

    @Override
    public File handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        if (statusCode == 303) {
            String newLocation = response.getFirstHeader("location").getValue().replace("\"", "");
            throw new NgasRedirectResponseException(newLocation, statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        if (statusCode != 200) {
            throw new ClientProtocolException(response.getStatusLine().toString());
        }
        String filename = response.getFirstHeader("content-disposition").getElements()[0].getParameterByName("filename").getValue();
        File fileDestination = new File(this.downloadDir + System.getProperty("file.separator") + filename);
        if (!this.overwrite && fileDestination.exists() && fileDestination.length() == Long.valueOf(response.getFirstHeader("content-length").getValue()).longValue()) {
            logger.info(filename + " already downloaded: skipping it");
            return fileDestination;
        }
        HttpEntity resEntity = response.getEntity();
        InputStream body = resEntity.getContent();
        FileOutputStream out = new FileOutputStream(fileDestination);
        IOUtils.copy(body, (OutputStream)out);
        body.close();
        ((OutputStream)out).close();
        return fileDestination;
    }
}

