/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.parser;

import org.apache.log4j.Logger;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.oca.fits.UndefinedFITSValue;
import org.eso.oca.parser.InterpretationException;
import org.eso.oca.parser.OCAState;
import org.eso.oca.parser.OcaParser;
import org.eso.oca.parser.OcaParserVisitor;
import org.eso.oca.parser.OcaVisitorException;
import org.eso.oca.parser.SimpleNode;

public class ASTRegexp
extends SimpleNode {
    static Logger logger = Logger.getLogger(ASTRegexp.class);

    public ASTRegexp(int id) {
        super(id);
    }

    public ASTRegexp(OcaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OcaParserVisitor visitor, Object data) throws OcaVisitorException {
        return visitor.visit(this, data);
    }

    @Override
    public int precedence() {
        return 30;
    }

    Object regexp(Object leftOperand, Object rightOperand) throws InterpretationException {
        String message = this.getNodeLocationString() + "Operator 'regexp' may not be used for \"" + TypedHeaderCard.findFITSTypeString(leftOperand) + " regexp " + TypedHeaderCard.findFITSTypeString(rightOperand) + "\".";
        logger.error(message);
        throw new InterpretationException(message);
    }

    Boolean regexp(Object leftOperand, UndefinedFITSValue rightOperand) {
        String message = this.getNodeLocationString() + "Operator 'regexp' used with undefined operand: \"" + TypedHeaderCard.findFITSTypeString(leftOperand) + " regexp " + TypedHeaderCard.findFITSTypeString(rightOperand) + "\".";
        logger.debug(message);
        return new Boolean(false);
    }

    Boolean regexp(UndefinedFITSValue leftOperand, Object rightOperand) {
        String message = this.getNodeLocationString() + "Operator 'regexp' used with undefined operand: \"" + TypedHeaderCard.findFITSTypeString(leftOperand) + " regexp " + TypedHeaderCard.findFITSTypeString(rightOperand) + "\".";
        logger.debug(message);
        return new Boolean(false);
    }

    Boolean regexp(String leftOperand, String rightOperand) {
        return new Boolean(leftOperand.matches(rightOperand));
    }

    @Override
    public void interpret(OCAState state) throws InterpretationException {
        logger.trace("interpret() called.");
        this.jjtGetChild(0).interpret(state);
        this.jjtGetChild(1).interpret(state);
        state.stack[--state.top] = this.dispatch(this.getClass(), "regexp", new Object[]{state.stack[state.top], state.stack[state.top + 1]});
    }
}

