/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.oca.dal.MetaColumn;
import org.eso.oca.dal.MetaTable;

public class MetaTableDAO {
    static Logger logger = Logger.getLogger(MetaTableDAO.class);
    private static final String ALL_FIELDS = "meta_tables.instrume,meta_tables.name,meta_columns.name,meta_columns.type,meta_columns.length,meta_columns.keyword";

    public MetaTable[] loadAll(Connection conn) throws SQLException {
        String thisMethod = "MetaTableDAO::loadAll()";
        logger.trace("MetaTableDAO::loadAll()");
        if (conn == null) {
            throw new IllegalArgumentException("MetaTableDAO::loadAll() - connection must not be null");
        }
        logger.debug("MetaTableDAO::loadAll() - loading meta-data from database " + conn.getCatalog());
        StringBuffer query = new StringBuffer();
        query.append(" select meta_tables.instrume,meta_tables.name,meta_columns.name,meta_columns.type,meta_columns.length,meta_columns.keyword");
        query.append(" from meta_tables, meta_columns");
        query.append(" where meta_tables.name = meta_columns.tname");
        logger.debug(query);
        PreparedStatement stmt = conn.prepareStatement(query.toString());
        ResultSet rs = stmt.executeQuery();
        Vector<MetaTable> metaTables = new Vector<MetaTable>();
        Vector<MetaColumn> metaColumns = new Vector<MetaColumn>();
        MetaTable metaTable = new MetaTable();
        MetaColumn metaColumn = new MetaColumn();
        String oldUniqueKey = null;
        String uniqueKey = null;
        while (rs.next()) {
            String instrume = rs.getString(1);
            String tableName = rs.getString(2);
            String columnName = rs.getString(3);
            String columnType = rs.getString(4);
            int columnLength = rs.getInt(5);
            String keyword = rs.getString(6);
            uniqueKey = instrume + tableName;
            if (oldUniqueKey == null) {
                oldUniqueKey = uniqueKey;
            }
            if (!uniqueKey.equals(oldUniqueKey)) {
                metaTable.setMetaColumns(metaColumns.toArray(new MetaColumn[metaColumns.size()]));
                metaTables.add(metaTable);
                metaTable = new MetaTable();
                metaColumns = new Vector();
                oldUniqueKey = uniqueKey;
            }
            metaTable.setName(tableName);
            metaTable.setInstrume(instrume);
            metaColumn = new MetaColumn();
            metaColumn.setName(columnName);
            metaColumn.setType(columnType);
            metaColumn.setLength(columnLength);
            metaColumn.setKeyword(keyword);
            metaColumns.add(metaColumn);
        }
        return metaTables.toArray(new MetaTable[metaTables.size()]);
    }
}

