/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.keyword;

import java.io.Serializable;
import org.eso.gasgano.keyword.ExpressionEvaluationException;
import org.eso.gasgano.keyword.Keyword;
import org.eso.gasgano.keyword.KeywordExpression;
import org.eso.gasgano.keyword.KeywordSet;

public class ClassificationRule
implements Serializable {
    static final long serialVersionUID = 5342691773597797000L;
    private String classification = null;
    private String instrument = null;
    private KeywordExpression rule = null;

    public void setClassification(String s) {
        this.classification = s;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setInstrument(String s) {
        this.instrument = s;
    }

    public String getInstrument() {
        return this.instrument;
    }

    public void setRule(KeywordExpression n) {
        this.rule = n;
    }

    public KeywordExpression getRule() {
        return this.rule;
    }

    public boolean match(KeywordSet f) {
        boolean rc = true;
        if (f != null) {
            String inst;
            Keyword instKw;
            if (this.instrument != null && (instKw = f.getKeyword("INSTRUME")) != null && !(inst = instKw.getValue()).equalsIgnoreCase(this.instrument)) {
                rc = false;
            }
        } else {
            rc = false;
        }
        if (rc && this.rule != null) {
            try {
                rc = this.rule.evaluate(f);
            }
            catch (ExpressionEvaluationException e2) {
                System.out.println(e2.toString());
                rc = false;
            }
        }
        return rc;
    }

    public boolean equals(ClassificationRule cr) {
        return this.getRule().toString().equals(cr.getRule().toString()) && this.getInstrument().equals(cr.getInstrument()) && this.getClassification().equals(cr.getClassification());
    }
}

