/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class FontChooser
extends JComponent
implements ActionListener {
    private static final String[] sizes = new String[]{"3", "4", "6", "8", "10", "12", "14", "16", "18"};
    private JComboBox fontName = null;
    private JCheckBox fontBold;
    private JCheckBox fontItalic;
    private JComboBox fontSize = null;
    private JLabel previewLabel = null;
    private SimpleAttributeSet attributes = null;
    private Font newFont = null;

    public FontChooser(Font f) {
        this.setLayout(new BorderLayout());
        this.attributes = new SimpleAttributeSet();
        String[] fonts = null;
        JPanel fontPanel = new JPanel();
        this.newFont = f;
        StyleConstants.setFontSize(this.attributes, f.getSize());
        StyleConstants.setFontFamily(this.attributes, f.getFamily());
        StyleConstants.setBold(this.attributes, f.isBold());
        StyleConstants.setItalic(this.attributes, f.isItalic());
        try {
            fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        catch (Exception e2) {
            // empty catch block
        }
        this.fontName = new JComboBox<String>(fonts);
        this.fontName.setSelectedItem(f.getFamily());
        this.fontName.addActionListener(this);
        this.fontSize = new JComboBox<String>(sizes);
        this.fontSize.setSelectedItem(String.valueOf(f.getSize()));
        this.fontSize.addActionListener(this);
        this.fontBold = new JCheckBox("Bold");
        this.fontBold.addActionListener(this);
        if (f.isBold()) {
            this.fontBold.setSelected(true);
        }
        this.fontItalic = new JCheckBox("Italic");
        this.fontItalic.addActionListener(this);
        if (f.isItalic()) {
            this.fontItalic.setSelected(true);
        }
        fontPanel.add(this.fontName);
        fontPanel.add(new JLabel("  Size:  "));
        fontPanel.add(this.fontSize);
        fontPanel.add(this.fontBold);
        fontPanel.add(this.fontItalic);
        this.add((Component)fontPanel, "North");
        JPanel previewPanel = new JPanel(new BorderLayout());
        this.previewLabel = new JLabel("  Here's a sample of this font.");
        this.previewLabel.setFont(f);
        previewPanel.add((Component)this.previewLabel, "Center");
        previewPanel.setMinimumSize(new Dimension(100, 100));
        previewPanel.setPreferredSize(new Dimension(100, 100));
        this.add((Component)previewPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (!StyleConstants.getFontFamily(this.attributes).equals(this.fontName.getSelectedItem())) {
            StyleConstants.setFontFamily(this.attributes, (String)this.fontName.getSelectedItem());
        }
        if (StyleConstants.getFontSize(this.attributes) != Integer.parseInt((String)this.fontSize.getSelectedItem())) {
            StyleConstants.setFontSize(this.attributes, Integer.parseInt((String)this.fontSize.getSelectedItem()));
        }
        if (StyleConstants.isBold(this.attributes) != this.fontBold.isSelected()) {
            StyleConstants.setBold(this.attributes, this.fontBold.isSelected());
        }
        if (StyleConstants.isItalic(this.attributes) != this.fontItalic.isSelected()) {
            StyleConstants.setItalic(this.attributes, this.fontItalic.isSelected());
        }
        this.updatePreviewFont();
    }

    protected void updatePreviewFont() {
        String name = StyleConstants.getFontFamily(this.attributes);
        boolean bold = StyleConstants.isBold(this.attributes);
        boolean ital = StyleConstants.isItalic(this.attributes);
        int size = StyleConstants.getFontSize(this.attributes);
        Font f = new Font(name, (bold ? 1 : 0) + (ital ? 2 : 0), size);
        this.previewLabel.setFont(f);
        this.previewLabel.repaint();
        this.newFont = f;
    }

    public Font getNewFont() {
        return this.newFont;
    }

    public AttributeSet getAttributes() {
        return this.attributes;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("test mike font chooser");
        frame.setSize(100, 100);
        frame.pack();
        frame.setVisible(true);
        FontChooser fc = new FontChooser(new Font("SansSerif", 2, 18));
        if (JOptionPane.showConfirmDialog(frame, fc, "Edit fonts", 2, -1) == 0) {
            System.out.println("selected Font is:" + fc.getNewFont().toString());
        }
        System.exit(0);
    }
}

