/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eso.gasgano.datamodel.ExprFilter;
import org.eso.gasgano.datamodel.OBComponentFilter;
import org.eso.gasgano.gui.ExpressionBuilder;
import org.eso.gasgano.keyword.EqKeywordExpr;
import org.eso.gasgano.keyword.ExpressionTable;
import org.eso.gasgano.keyword.Keyword;
import org.eso.gasgano.keyword.KeywordExpression;

public class FilterBuilder
extends JDialog
implements ActionListener,
ListSelectionListener {
    private ExpressionBuilder exprBuilder = null;
    private JScrollPane tableView = null;
    private JTable table = null;
    private JSplitPane mainPane = null;
    private JPanel lowerPanel = null;
    private JPanel exprPanel = null;
    private KeywordExpression selectedExpression;
    private int selectedIdx = -1;
    private KeywordExpression emptyExpr;
    private JButton selectExpr = null;
    private JButton deleteExpr = null;
    private JButton copyExpr = null;
    private JButton cancelExpr = null;
    private ExpressionTable exprTable = null;

    public static void main(String[] args) {
        String tablePath = null;
        if (args.length < 1) {
            System.out.println("usage: <path to rule table>");
            System.exit(0);
        } else {
            tablePath = args[0];
        }
        ExpressionTable rt = ExpressionTable.readFile(tablePath);
        if (rt == null) {
            System.out.println("Failed to read/locate: " + tablePath + " starting with an empty table.");
            rt = new ExpressionTable(tablePath);
        }
        FilterBuilder s = new FilterBuilder(null, "Filter Builder :" + tablePath, true, rt);
        s.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        s.pack();
        s.setLocation(100, 300);
        s.show();
        System.out.println("Selection: " + s.getSelectedExpression());
        System.exit(0);
    }

    public KeywordExpression getSelectedExpression() {
        return this.selectedExpression;
    }

    public OBComponentFilter getSelectedFilter() {
        ExprFilter rc = null;
        if (this.selectedExpression != null) {
            rc = new ExprFilter(this.getSelectedExpression());
        }
        return rc;
    }

    public FilterBuilder(Frame parent, String title, boolean modal, ExpressionTable et) {
        super(parent, title, modal);
        this.exprTable = et;
        this.init(parent);
    }

    private KeywordExpression getEmptyExpression() {
        return new KeywordExpression(new EqKeywordExpr((Object)new Keyword("KEYWORD", null), new String("value")));
    }

    private void init(Frame parent) {
        this.emptyExpr = this.getEmptyExpression();
        this.exprPanel = new JPanel(new BorderLayout());
        this.exprPanel.setBorder(new BevelBorder(0));
        this.table = new JTable(this.exprTable);
        this.table.getColumnModel().getColumn(0).setMinWidth(350);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(350);
        ListSelectionModel lsm = this.table.getSelectionModel();
        if (lsm != null) {
            lsm.setSelectionMode(0);
            lsm.addListSelectionListener(this);
        }
        this.tableView = new JScrollPane(this.table);
        this.tableView.setPreferredSize(new Dimension(600, 150));
        this.exprBuilder = new ExpressionBuilder(parent);
        this.exprBuilder.setPreferredSize(new Dimension(800, 150));
        this.exprBuilder.setBorder(new BevelBorder(0));
        this.selectExpr = new JButton("OK");
        this.selectExpr.addActionListener(this);
        this.copyExpr = new JButton("Duplicate");
        this.copyExpr.addActionListener(this);
        this.deleteExpr = new JButton("Delete");
        this.deleteExpr.addActionListener(this);
        this.cancelExpr = new JButton("Cancel");
        this.cancelExpr.addActionListener(this);
        this.lowerPanel = new JPanel();
        this.lowerPanel.add(this.selectExpr);
        this.lowerPanel.add(this.copyExpr);
        this.lowerPanel.add(this.deleteExpr);
        this.lowerPanel.add(this.cancelExpr);
        this.getContentPane().add((Component)this.tableView, "North");
        this.getContentPane().add((Component)this.exprBuilder, "Center");
        this.getContentPane().add((Component)this.lowerPanel, "South");
        this.updateButtons(false);
    }

    @Override
    public void valueChanged(ListSelectionEvent e2) {
        int i = -1;
        if (e2 != null && !e2.getValueIsAdjusting()) {
            ListSelectionModel lsm = (ListSelectionModel)e2.getSource();
            int newSelectedIdx = lsm.isSelectionEmpty() ? -1 : lsm.getMinSelectionIndex();
            this.commitEdits();
            if (newSelectedIdx < 0) {
                this.selectedExpression = null;
                this.selectedIdx = -1;
            } else {
                this.selectedExpression = this.exprTable.elementAt(newSelectedIdx);
                this.selectedIdx = newSelectedIdx;
            }
            this.updateButtons(this.selectedExpression != null);
            this.displayExpression(this.selectedExpression);
        }
    }

    private void updateButtons(boolean enabled) {
        this.selectExpr.setEnabled(enabled);
        this.copyExpr.setEnabled(enabled);
        this.deleteExpr.setEnabled(enabled);
        this.selectExpr.setEnabled(enabled || this.exprTable.getRowCount() == 0);
    }

    private void commitEdits() {
        KeywordExpression expr = this.exprBuilder.getKeywordExpression();
        if (this.selectedExpression != null && expr != null) {
            String exprStr = expr.toString();
            boolean write = false;
            String selectedExprStr = this.selectedExpression.toString();
            boolean bl = write = !exprStr.equals(selectedExprStr);
            if (write) {
                int selIdx = this.selectedIdx;
                this.exprTable.replaceElement(this.selectedExpression, expr);
                this.selectedIdx = selIdx;
                this.selectedExpression = this.exprTable.elementAt(this.selectedIdx);
            }
        }
    }

    private void writeFile() {
        try {
            this.exprTable.writeFile();
        }
        catch (IOException e2) {
            this.userMessage("Error saving file: " + this.exprTable.getTablePath());
        }
    }

    @Override
    public void actionPerformed(ActionEvent a2) {
        if (a2.getSource() == this.selectExpr) {
            if (this.exprTable.getRowCount() != 0) {
                this.commitEdits();
            } else {
                this.selectedExpression = this.exprBuilder.getKeywordExpression();
                this.exprTable.addElement(this.selectedExpression);
                this.selectedIdx = 0;
            }
            this.writeFile();
            KeywordExpression expr = this.exprBuilder.getKeywordExpression();
            if (expr != null) {
                this.selectedExpression = this.exprTable.elementAt(this.selectedIdx);
                this.setSelectedRow(this.selectedIdx);
                this.displayExpression(this.selectedExpression);
                this.setVisible(false);
                this.dispose();
            } else {
                this.userMessage("Error, no expression found in builder.");
            }
        } else if (a2.getSource() == this.deleteExpr) {
            if (this.selectedExpression != null) {
                int idx = this.selectedIdx;
                this.exprTable.removeElement(this.selectedExpression);
                this.writeFile();
                this.selectedIdx = idx;
                if (this.selectedIdx >= this.exprTable.getRowCount()) {
                    this.selectedIdx = this.exprTable.getRowCount() - 1;
                }
                if (this.selectedIdx >= 0) {
                    this.selectedExpression = this.exprTable.elementAt(this.selectedIdx);
                } else {
                    this.selectedExpression = null;
                    this.selectedIdx = -1;
                }
                this.setSelectedRow(this.selectedIdx);
                this.displayExpression(this.selectedExpression);
            } else {
                this.userMessage("No expression selected to delete");
            }
        } else if (a2.getSource() == this.copyExpr) {
            if (this.selectedExpression != null) {
                this.selectedExpression = this.selectedExpression.copy();
                this.exprTable.addElement(this.selectedExpression);
                this.writeFile();
                this.selectedIdx = this.exprTable.getRowCount() - 1;
                this.setSelectedRow(this.selectedIdx);
                this.displayExpression(this.selectedExpression);
            } else {
                this.userMessage("No expression selected to copy");
            }
        } else if (a2.getSource() == this.cancelExpr) {
            this.selectedExpression = null;
            this.selectedIdx = -1;
            this.table.clearSelection();
            this.setVisible(false);
            this.dispose();
        }
    }

    private void setSelectedRow(final int row) {
        if (row >= 0 && row < this.table.getRowCount()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FilterBuilder.this.table.getSelectionModel().setSelectionInterval(row, row);
                    FilterBuilder.this.table.scrollRectToVisible(FilterBuilder.this.table.getCellRect(row, 0, false));
                }
            });
        }
    }

    private void displayExpression(KeywordExpression c2) {
        if (c2 == null || c2.getExpressionTree() == null) {
            this.exprBuilder.setKeywordExpression(this.emptyExpr);
        } else {
            this.exprBuilder.setKeywordExpression(c2);
        }
    }

    public void userMessage(String msg) {
        JOptionPane.showMessageDialog(this, msg);
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis && this.selectedIdx < 0 && this.exprTable.getRowCount() > 0) {
            this.selectedIdx = 0;
            this.setSelectedRow(this.selectedIdx);
            this.displayExpression(this.selectedExpression);
        }
        super.setVisible(vis);
    }

    public void selectFirstFilter() {
        String onlyFoundExpression;
        String expressionTemplate = "(KEYWORD = \"value\")";
        if (this.exprTable.getRowCount() == 0) {
            return;
        }
        if (this.exprTable.getRowCount() == 1 && (onlyFoundExpression = (String)this.exprTable.getValueAt(0, 1)).equals(expressionTemplate)) {
            return;
        }
        this.commitEdits();
        this.selectedIdx = 0;
        this.selectedExpression = this.exprTable.elementAt(this.selectedIdx);
        this.updateButtons(this.selectedExpression != null);
        this.displayExpression(this.selectedExpression);
    }
}

