/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.eso.gasgano.gui.FileListChooser;
import org.eso.gasgano.gui.PropertyEditorSubPanel;
import org.eso.gasgano.properties.GasProp;

public class DataPanel
extends PropertyEditorSubPanel {
    private GasProp gpi;
    private String selectedFile;
    private boolean classificationRequired = false;
    private JTextField keyList;
    private JTextField scriptDir;
    private JTextField filterRule;
    private JTextField classificationRule;
    private JComboBox updateTimer;
    private JTextField verboseLevel;
    private JRadioButton shortenPaths;
    private JComboBox verboseLevelBox;
    private Vector verboseVector = new Vector();
    private Vector updateTimerVector = new Vector();
    private Vector updateTimerValues = new Vector(5);
    private JTextField textExt;
    private FileListChooser fileListChooser;
    private JPanel jpl = new JPanel();
    private JPanel jpr = new JPanel();
    private JPanel jpll = new JPanel();
    private JPanel jprl = new JPanel();
    private JPanel miniPanel = new JPanel();

    public DataPanel(GasProp gp) {
        this.verboseVector.addElement("No Verbose");
        this.verboseVector.addElement("DataModel Change");
        this.verboseVector.addElement("DataModel Events");
        this.verboseVector.addElement("External Commands");
        this.verboseVector.addElement("Basenames");
        this.verboseVector.addElement("Timing");
        this.verboseVector.addElement("Events");
        this.verboseVector.addElement("Expression Rules");
        this.verboseVector.addElement("Database");
        this.verboseVector.addElement("All verbose levels");
        this.updateTimerVector.addElement("No update");
        this.updateTimerVector.addElement("1 minute");
        this.updateTimerVector.addElement("2 minutes");
        this.updateTimerVector.addElement("5 minutes");
        this.updateTimerVector.addElement("30 minutes");
        this.updateTimerValues.addElement(new Integer(0));
        this.updateTimerValues.addElement(new Integer(1));
        this.updateTimerValues.addElement(new Integer(2));
        this.updateTimerValues.addElement(new Integer(5));
        this.updateTimerValues.addElement(new Integer(30));
        this.keyList = new JTextField(20);
        this.keyList.setToolTipText("Default directory for keyword list files.");
        this.scriptDir = new JTextField(20);
        this.scriptDir.setToolTipText("Default directory for script files.");
        this.filterRule = new JTextField(20);
        this.filterRule.setToolTipText("Location of filter rule file.");
        this.classificationRule = new JTextField(20);
        this.classificationRule.setToolTipText("Location of classification rule file.");
        this.textExt = new JTextField(20);
        this.textExt.setToolTipText("Semi-colon (;) separated list of text file extensions.");
        this.verboseLevelBox = new JComboBox(this.verboseVector);
        this.updateTimer = new JComboBox(this.updateTimerVector);
        this.shortenPaths = new JRadioButton("shorten data files paths for commands", true);
        this.loadProperties(gp);
        TitledBorder tb = new TitledBorder("Filesystem specifications");
        JPanel filesPanel = new JPanel(new BorderLayout());
        JPanel otherPanel = new JPanel(new BorderLayout());
        JPanel tmpPanel = new JPanel(new BorderLayout());
        this.setLayout(new BorderLayout(5, 5));
        filesPanel.setBorder(tb);
        this.jpl.setLayout(new GridLayout(8, 1));
        this.jpl.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.jpl.add(new JLabel("Keyword List directory:", 4));
        this.jpl.add(new JLabel("Scripts directory:", 4));
        this.jpl.add(new JLabel("Filter Rule file:", 4));
        this.jpl.add(new JLabel("Classification Rule file:", 4));
        this.jpl.add(new JLabel());
        this.jpl.add(new JLabel("Textfile Extensions:", 4));
        this.jpr.setLayout(new GridLayout(8, 1));
        this.jpr.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.jpr.add(DataPanel.setupFileChooserPanel(this.keyList, 1));
        this.jpr.add(DataPanel.setupFileChooserPanel(this.scriptDir, 1));
        this.jpr.add(DataPanel.setupFileChooserPanel(this.filterRule, 0));
        this.jpr.add(DataPanel.setupFileChooserPanel(this.classificationRule, 0));
        this.jpr.add(new JLabel());
        this.jpr.add(this.textExt);
        this.jprl = new JPanel(new GridLayout(2, 1));
        this.jprl.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.jpll = new JPanel(new GridLayout(2, 2));
        this.jpll.setBorder(new EmptyBorder(3, 3, 3, 3));
        otherPanel.setBorder(new EtchedBorder());
        this.jpll.add(new JLabel("Automatic Filesystem Refresh:", 4));
        this.jprl.add(this.updateTimer);
        this.jpll.add(new JLabel("Verbose Level:", 4));
        this.jprl.add(this.verboseLevelBox);
        tmpPanel.add("Center", this.jpll);
        tmpPanel.add("East", this.jprl);
        otherPanel.add("North", this.shortenPaths);
        otherPanel.add("West", tmpPanel);
        filesPanel.add("West", this.jpl);
        filesPanel.add("Center", this.jpr);
        this.add("North", this.fileListChooser);
        this.add("Center", filesPanel);
        this.add("South", otherPanel);
    }

    @Override
    public void loadProperties(GasProp gp) {
        this.gpi = gp;
        if (this.fileListChooser == null) {
            this.fileListChooser = new FileListChooser();
        }
        Vector vec = null;
        vec = GasProp.stringScanner(gp.getProperty("DATA_FILES"), ';');
        if (vec != null) {
            this.fileListChooser.setFileList(vec);
        }
        this.keyList.setText(gp.getProperty("KEYWORDLIST_DIR"));
        this.scriptDir.setText(gp.getProperty("SCRIPTS_DIR"));
        this.filterRule.setText(gp.getProperty("FILTER_FILE"));
        this.classificationRule.setText(gp.getProperty("CLASSRULE_FILE"));
        this.textExt.setText(gp.getProperty("TEXTFILE_EXTENSIONS"));
        if (gp.getProperty("SHORTEN_FILES_PATH").equals("true")) {
            this.shortenPaths.setSelected(true);
        } else {
            this.shortenPaths.setSelected(false);
        }
        try {
            int pippo = Integer.parseInt(gp.getProperty("VERBOSE_LEVEL"));
            this.verboseLevelBox.setSelectedIndex(pippo);
            pippo = this.updateTimerValues.indexOf(Integer.valueOf(gp.getProperty("UPDATE_TIMER")));
            if (pippo == -1) {
                this.updateTimer.setSelectedIndex(0);
            } else {
                this.updateTimer.setSelectedIndex(pippo);
            }
        }
        catch (NumberFormatException nfe) {
            this.verboseLevelBox.setSelectedIndex(0);
            this.updateTimer.setSelectedIndex(0);
        }
    }

    @Override
    public String saveProperties() {
        String rc = null;
        this.gpi.put("DATA_FILES", GasProp.stringBuilder(this.fileListChooser.getFileList(), ';'));
        if (!this.keyList.getText().trim().equals("")) {
            this.gpi.put("KEYWORDLIST_DIR", this.keyList.getText());
        } else {
            rc = "Data Panel: Keyword List Directory field  empty";
        }
        if (!this.scriptDir.getText().trim().equals("")) {
            this.gpi.put("SCRIPTS_DIR", this.scriptDir.getText());
        } else {
            rc = "Data Panel: Scripts Directory field empty";
        }
        if (!this.filterRule.getText().trim().equals("")) {
            this.gpi.put("FILTER_FILE", this.filterRule.getText());
        } else {
            rc = "Data Panel: Filter File field  empty";
        }
        if (!this.classificationRule.getText().trim().equals("")) {
            String prevClassRuleFile = this.gpi.get("CLASSRULE_FILE").toString().trim();
            String newClassRuleFile = this.classificationRule.getText().trim();
            this.classificationRequired = !newClassRuleFile.equals(prevClassRuleFile);
            this.gpi.put("CLASSRULE_FILE", newClassRuleFile);
        } else {
            rc = "Data Panel: Classification Rules File field  empty";
        }
        this.gpi.put("TEXTFILE_EXTENSIONS", this.textExt.getText());
        this.gpi.put("VERBOSE_LEVEL", String.valueOf(this.verboseLevelBox.getSelectedIndex()));
        this.gpi.put("UPDATE_TIMER", String.valueOf(this.updateTimerValues.elementAt(this.updateTimer.getSelectedIndex())));
        if (this.shortenPaths.isSelected()) {
            this.gpi.put("SHORTEN_FILES_PATH", "true");
        } else {
            this.gpi.put("SHORTEN_FILES_PATH", "false");
        }
        return rc;
    }

    @Override
    public int restartRequired() {
        int action = 0;
        return action;
    }

    public boolean isClassificationRequired() {
        return this.classificationRequired;
    }
}

