/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Element;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.gui.GUIUtils;
import org.eso.oca.parser.ParseException;

public class ClassificationRuleFileEditor
extends JDialog
implements ActionListener {
    private static final String ACTION_SAVE = "save";
    private static final String ACTION_CLOSE = "close";
    private final JTextArea textArea;
    private final JScrollPane scrollableTextArea;
    private final JButton saveButton;
    private final JButton closeButton;
    private final JLabel caretCoords;
    private final String ruleFile;
    private final String title;
    private boolean edited = false;
    private boolean ruleFileChanged = false;

    public ClassificationRuleFileEditor(String ruleFile) throws Exception {
        String fileContent;
        this.title = "Rule File Editor - " + ruleFile;
        this.ruleFile = ruleFile;
        this.setTitle(this.title);
        try {
            fileContent = ClassificationRuleFileEditor.loadFile(ruleFile);
        }
        catch (Exception e2) {
            throw new Exception("Unable to load rule file [" + ruleFile + "]: " + e2.getMessage());
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent w) {
                if (ClassificationRuleFileEditor.this.saveAndExit()) {
                    ClassificationRuleFileEditor.this.dispose();
                }
            }
        });
        this.textArea = new JTextArea(fileContent);
        this.scrollableTextArea = new JScrollPane(this.textArea);
        this.saveButton = new JButton("Save");
        this.closeButton = new JButton("Close");
        boolean writable = new File(ruleFile).canWrite();
        if (!writable) {
            GUIUtils.userMessage(this, "Rule file [" + ruleFile + "] is not writable.\n" + "Opening in read only mode.\n" + "Editing and saving will not be allowed.");
        }
        this.textArea.setEditable(writable);
        if (writable) {
            this.textArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e2) {
                    ClassificationRuleFileEditor.this.setEdited(true);
                }

                @Override
                public void insertUpdate(DocumentEvent e2) {
                    ClassificationRuleFileEditor.this.setEdited(true);
                }

                @Override
                public void removeUpdate(DocumentEvent e2) {
                    ClassificationRuleFileEditor.this.setEdited(true);
                }
            });
        }
        this.saveButton.setEnabled(writable);
        this.caretCoords = new JLabel("Row 1, Column 1");
        this.textArea.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e2) {
                int caretPosition = ClassificationRuleFileEditor.this.textArea.getCaretPosition();
                Element root = ClassificationRuleFileEditor.this.textArea.getDocument().getDefaultRootElement();
                int row = root.getElementIndex(caretPosition);
                int column = caretPosition - root.getElement(row).getStartOffset();
                ClassificationRuleFileEditor.this.caretCoords.setText("Row " + (row + 1) + ", Column " + (column + 1));
            }
        });
        this.add("Center", this.scrollableTextArea);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 2));
        this.add((Component)bottomPanel, "South");
        bottomPanel.add(this.caretCoords);
        bottomPanel.add(Box.createHorizontalGlue());
        this.saveButton.addActionListener(this);
        this.saveButton.setActionCommand(ACTION_SAVE);
        this.closeButton.addActionListener(this);
        this.closeButton.setActionCommand(ACTION_CLOSE);
        bottomPanel.add(this.saveButton);
        bottomPanel.add(this.closeButton);
        this.setEdited(false);
        this.setPreferredSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(320, 240));
        this.pack();
        this.isRuleFileCorrect();
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String action = e2.getActionCommand();
        if (action.equals(ACTION_SAVE)) {
            if (this.isRuleFileCorrect()) {
                this.saveFile();
            }
        } else if (action.equals(ACTION_CLOSE) && this.saveAndExit()) {
            this.dispose();
        }
    }

    private boolean saveAndExit() {
        boolean exit = false;
        if (this.edited) {
            int result = JOptionPane.showConfirmDialog(this, "The rule file has been changed.\n\nWould you like to save the changes?");
            if (result == 0) {
                boolean successfullySaved;
                if (this.isRuleFileCorrect() && (successfullySaved = this.saveFile())) {
                    exit = true;
                }
            } else if (result == 1) {
                exit = true;
            }
        } else {
            exit = true;
        }
        return exit;
    }

    private static String loadFile(String filename) throws FileNotFoundException, IOException {
        String line;
        File file = new File(filename);
        FileReader fileReader = new FileReader(filename);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        StringBuilder fileContent = new StringBuilder((int)file.length());
        while ((line = bufferedReader.readLine()) != null) {
            fileContent.append(line + "\n");
        }
        bufferedReader.close();
        return fileContent.toString();
    }

    private boolean saveFile() {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.ruleFile));
            writer.write(this.textArea.getText());
            ((Writer)writer).close();
            this.setEdited(false);
            this.ruleFileChanged = true;
            return true;
        }
        catch (IOException ex) {
            GUIUtils.userMessage(this, "Unable to save file [" + this.ruleFile + "].\n\n" + ex.getMessage());
            return false;
        }
    }

    private void setEdited(boolean edited) {
        this.edited = edited;
        this.setTitle(this.title + (edited ? "*" : ""));
        this.saveButton.setEnabled(edited);
    }

    private boolean isRuleFileCorrect() {
        boolean isCorrect = false;
        try {
            DFSDataModel.createClassifier(new ByteArrayInputStream(this.textArea.getText().getBytes()));
            isCorrect = true;
        }
        catch (ParseException e2) {
            GUIUtils.userError(this, "The rule file contains errors: \n\n" + e2.getMessage());
        }
        catch (Exception e3) {
            GUIUtils.userMessage(this, "Unexpected exception while accessing rules file [" + this.ruleFile + "].\n" + e3.getMessage());
        }
        catch (Error e4) {
            GUIUtils.userMessage(this, "Unexpected error while accessing rules file [" + this.ruleFile + "].\n" + e4.getMessage());
        }
        return isCorrect;
    }

    public boolean isRuleFileChanged() {
        return this.ruleFileChanged;
    }
}

