/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.gui;

import java.awt.Color;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.eso.gasgano.datamodel.gui.ResultsComponent;
import org.eso.gasgano.gui.GUIUtils;
import org.eso.gasgano.tools.SortedHashtable;

public class ResultsContainer {
    private ResultsContainer father = null;
    private int filesCount = 0;
    private String desc = null;
    private SortedHashtable frames = null;
    private SortedHashtable labels = null;
    private char containerType = (char)97;

    public ResultsContainer() {
        this.frames = new SortedHashtable();
        this.labels = new SortedHashtable();
    }

    public ResultsContainer(char type, String label) {
        this.frames = new SortedHashtable();
        this.labels = new SortedHashtable();
        this.setDescription(label);
        this.containerType = type;
    }

    public void setFather(ResultsContainer f) {
        this.father = f;
    }

    public ResultsContainer getFather() {
        return this.father;
    }

    public int getLabelsCount() {
        return this.labels.size();
    }

    public ResultsContainer getLabelAt(int i) {
        return (ResultsContainer)this.labels.elementAt(i);
    }

    public int getIndexOfLabel(ResultsContainer ref) {
        return this.labels.indexOf(ref);
    }

    public SortedHashtable getLabelsSet() {
        return this.labels;
    }

    public ResultsContainer findLabel(String id) {
        return this.findLabel(this.labels, id);
    }

    public ResultsContainer findLabel(SortedHashtable progSet, String id) {
        return (ResultsContainer)progSet.get(id);
    }

    public ResultsContainer addLabel(String id) {
        return this.addLabel(this.labels, id);
    }

    private ResultsContainer addLabel(SortedHashtable progSet, String id) {
        ResultsContainer rc = this.findLabel(progSet, id);
        id = id.replace('\t', ' ').trim();
        if (rc == null) {
            rc = new ResultsContainer('l', id);
            progSet.put(id, rc);
            rc.setFather(this);
        }
        return rc;
    }

    public void removeLabel(ResultsContainer label) {
        label.setFather(null);
        this.labels.remove(label.getId());
    }

    public int getFramesCount() {
        return this.frames.size();
    }

    public ResultsComponent getFrameAt(int i) {
        return (ResultsComponent)this.frames.elementAt(i);
    }

    public int getIndexOfFrame(ResultsComponent ref) {
        return this.frames.indexOf(ref);
    }

    public SortedHashtable getFramesSet() {
        return this.frames;
    }

    public ResultsComponent findFrame(String id) {
        return this.findFrame(this.frames, id);
    }

    public ResultsComponent findFrame(SortedHashtable progSet, String id) {
        return (ResultsComponent)progSet.get(id);
    }

    public void addFrame(String id) {
        this.addFrame(this.frames, id);
    }

    private void addFrame(SortedHashtable progSet, String id) {
        ResultsComponent rc = this.findFrame(progSet, id = id.replace('\t', ' ').trim());
        if (rc == null) {
            ResultsComponent resComp = new ResultsComponent(id);
            progSet.put(id, resComp);
            resComp.setFather(this);
        }
    }

    public void removeFrame(String id) {
        this.frames.remove(id);
    }

    public boolean isReference() {
        return this.containerType == 'r';
    }

    public boolean isLabel() {
        return this.containerType == 'l';
    }

    public void setDescription(String s) {
        this.desc = s;
    }

    public String toString() {
        return this.desc;
    }

    public String getId() {
        return super.toString();
    }

    public SortedHashtable getDescendants() {
        Object tmpObject;
        SortedHashtable tmpHash = null;
        tmpHash = new SortedHashtable();
        Enumeration e2 = this.frames.keys();
        while (e2.hasMoreElements()) {
            tmpObject = e2.nextElement();
            tmpHash.put(tmpObject, this.frames.get(tmpObject));
        }
        e2 = this.labels.keys();
        while (e2.hasMoreElements()) {
            tmpObject = e2.nextElement();
            tmpHash.put(tmpObject, this.labels.get(tmpObject));
        }
        return tmpHash;
    }

    public JComponent getTreeCellComponent() {
        JLabel cell = new JLabel();
        Object foreGround = null;
        cell.setIcon(GUIUtils.defaultLabel.getIcon());
        cell.setText(new String(this.toString()));
        if (this.isReference()) {
            cell.setForeground(Color.red);
        } else {
            cell.setForeground(Color.black);
        }
        return cell;
    }
}

