/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.eso.dfs.gui.RecallingComboBox;
import org.eso.dfs.gui.SwingFileChooser;
import org.eso.dfs.services.gui.FileImageDisplayService;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.datamodel.filesystem.FitsFile;
import org.eso.gasgano.datamodel.gui.FitsKeywordDisplayRenderer;
import org.eso.gasgano.datamodel.gui.FitsTableModel;
import org.eso.gasgano.gui.KeywordTable;
import org.eso.gasgano.properties.PropertyDB;

public class FitsFileDisplay
extends JPanel
implements ActionListener,
KeyListener {
    private static final String findLabel = "Find in header:";
    private static final String findButtonLabel = "find";
    private static final String filterLabel = "Filter";
    private static final String autoDisplayLabel = "Auto Display";
    private static final String loadFilterLabel = "Load Filter";
    private static JScrollPane tableView = new JScrollPane();
    private static RecallingComboBox findEntry = new RecallingComboBox(true, 20);
    private static JRadioButton filterView = new JRadioButton();
    private static JRadioButton autoDisplay = new JRadioButton();
    private static JPanel upperPanel = new JPanel(new BorderLayout());
    private static JPanel controlPanel = new JPanel();
    private static JScrollPane controlPanelScroller = new JScrollPane(controlPanel, 21, 32);
    private static JPanel findPanel = new JPanel();
    private static JPanel filterPanel = new JPanel();
    private static JPanel autoDisplayPanel = new JPanel();
    private static JPanel extensionPanel = new JPanel();
    private static JButton searchButton = new JButton("find");
    private static JButton loadFilterButton = new JButton("Load Filter");
    private static JLabel titleLabel = new JLabel();
    private JTable table = null;
    private String fileName = null;
    private FitsTableModel model = null;
    private boolean cltrDown = false;
    private static String findKeyEntry = null;
    private static boolean filtered = false;
    private static JComboBox extensionSelector = new JComboBox();
    private static FitsFileDisplay formerThis = null;

    public FitsFileDisplay(String title, FitsTableModel mdl) {
        super(new BorderLayout());
        upperPanel.removeAll();
        controlPanel.removeAll();
        extensionPanel.removeAll();
        filterPanel.removeAll();
        autoDisplayPanel.removeAll();
        findPanel.removeAll();
        titleLabel.setText(title);
        titleLabel.setHorizontalAlignment(0);
        titleLabel.setBorder(new EmptyBorder(5, 0, 5, 0));
        titleLabel.setForeground(Color.black);
        this.model = mdl;
        this.table = new JTable(this.model);
        this.setupCellRenderer();
        this.table.setCellSelectionEnabled(true);
        tableView.setViewportView(this.table);
        this.table.addKeyListener(this);
        this.table.getColumnModel().removeColumn(this.table.getColumnModel().getColumn(2));
        if (formerThis != null) {
            searchButton.removeActionListener(formerThis);
            loadFilterButton.removeActionListener(formerThis);
            findEntry.removeActionListener(formerThis);
            filterView.removeActionListener(formerThis);
            extensionSelector.removeActionListener(formerThis);
            autoDisplay.removeActionListener(formerThis);
        }
        searchButton.addActionListener(this);
        loadFilterButton.addActionListener(this);
        findEntry.addActionListener(this);
        filterView.addActionListener(this);
        extensionSelector.addActionListener(this);
        autoDisplay.addActionListener(this);
        formerThis = this;
        this.model.setFiltered(filtered);
        filterView.setText(filterLabel);
        filterView.setSelected(this.model.isFiltered());
        upperPanel.add((Component)titleLabel, "North");
        extensionPanel.add(new JLabel("Extension: "));
        extensionPanel.add(extensionSelector);
        extensionPanel.setBorder(new LineBorder(Color.black));
        this.setupExtensionSelector();
        controlPanel.add(extensionPanel);
        findPanel.add(new JLabel(findLabel));
        findPanel.add(findEntry);
        findPanel.add(searchButton);
        findPanel.setBorder(new LineBorder(Color.black));
        controlPanel.add(findPanel);
        filterPanel.add(loadFilterButton);
        filterPanel.add(filterView);
        filterPanel.setBorder(new LineBorder(Color.black));
        controlPanel.add(filterPanel);
        autoDisplayPanel.add(autoDisplay);
        autoDisplay.setText(autoDisplayLabel);
        autoDisplayPanel.setBorder(new LineBorder(Color.black));
        controlPanel.add(autoDisplayPanel);
        upperPanel.add((Component)controlPanelScroller, "Center");
        this.add((Component)tableView, "Center");
        this.add((Component)upperPanel, "North");
        this.fileName = this.model.getFileName();
        if (autoDisplay.isSelected()) {
            this.sendFileToDisplay();
        }
    }

    public JTable getTableComponent() {
        return this.table;
    }

    private void setupExtensionSelector() {
        extensionSelector.removeAllItems();
        extensionSelector.addItem("HEADER");
        extensionSelector.setSelectedIndex(0);
        if (this.model.getExtensionCount() != -1) {
            extensionSelector.setEnabled(true);
            int xCnt = this.model.getExtensionCount();
            for (int i = 0; i < xCnt; ++i) {
                String xName = this.model.getExtensionName(i);
                if (xName == null || xName.length() == 0) {
                    xName = "EXT " + (i + 1);
                }
                extensionSelector.addItem(xName);
            }
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent arg0) {
                    int row = FitsFileDisplay.this.table.getSelectedRow();
                    if (row > 0) {
                        int extension = (Integer)FitsFileDisplay.this.model.getValueAt(row, 2);
                        FitsFileDisplay.this.updateExtensionSelectorSelection(extension);
                    }
                }
            });
        } else {
            extensionSelector.setEnabled(false);
        }
    }

    private void updateExtensionSelectorSelection(int i) {
        extensionSelector.removeActionListener(this);
        extensionSelector.setSelectedIndex(i);
        extensionSelector.addActionListener(this);
    }

    private void sendFileToDisplay() {
        Cursor c2 = this.getCursor();
        this.setCursor(new Cursor(3));
        FileImageDisplayService.getInstance().displayFile(this, new String[]{this.model.getFileName()}, true);
        this.setCursor(c2);
    }

    @Override
    public void actionPerformed(ActionEvent a2) {
        String findKey;
        if (a2.getSource() == filterView) {
            this.model.setFiltered(filterView.isSelected());
            filtered = this.model.isFiltered();
            filterView.setSelected(filtered);
        } else if (a2.getSource() == loadFilterButton) {
            this.loadFilter();
        } else if (a2.getSource() == extensionSelector) {
            this.displayExtension();
        } else if (a2.getSource() == autoDisplay) {
            PropertyDB.getInstance().setProperty("AUTO_DISPLAY", autoDisplay.isSelected() ? "true" : "false");
            if (autoDisplay.isSelected()) {
                this.sendFileToDisplay();
            }
        } else if (a2.getSource() == searchButton && findEntry.getSelectedIndex() > -1 && (findKey = (findKeyEntry = findEntry.getText()).toUpperCase()).length() > 0) {
            int row = this.table.getSelectedRow();
            if (row < 0 || row > this.table.getRowCount()) {
                row = 0;
            }
            int firstSearch = row;
            int cell = 0;
            boolean found = false;
            while (!found) {
                String cellValue;
                if (++row == this.table.getRowCount()) {
                    row = 0;
                }
                if ((cellValue = ((String)this.table.getValueAt(row, cell = 0)).toUpperCase()).indexOf(findKey) != -1) {
                    found = true;
                    break;
                }
                cell = 1;
                cellValue = ((String)this.table.getValueAt(row, cell)).toUpperCase();
                if (cellValue.indexOf(findKey) != -1) {
                    found = true;
                    break;
                }
                if (firstSearch != row) continue;
                break;
            }
            if (found) {
                this.showCell(row, cell);
            } else {
                JOptionPane.showMessageDialog(this, "'" + findEntry.getText() + "' not found.");
            }
        }
    }

    public void showCell(int row, int col) {
        this.table.setRowSelectionInterval(row, row);
        this.table.setColumnSelectionInterval(col, col);
        Rectangle r = this.table.getCellRect(row, col, true);
        this.table.scrollRectToVisible(r);
    }

    private void loadFilter() {
        SwingFileChooser kwChooser = new SwingFileChooser();
        DFSDataModel dm = DFSDataModel.getDataModel();
        ((JFileChooser)kwChooser).setCurrentDirectory(new File(PropertyDB.getInstance().getProperty("KEYWORDLIST_DIR")));
        kwChooser.setFileSelectionMode(0);
        kwChooser.setDialogType(0);
        kwChooser.setDialogTitle("Select Keyword List");
        kwChooser.setApproveButtonText("Load");
        kwChooser.setMultiSelectionEnabled(false);
        if (kwChooser.showOpenDialog(this) == 0 && kwChooser.getSelectedFile() != null) {
            KeywordTable defaultKWList = new KeywordTable();
            String selectedFile = kwChooser.getSelectedFile().getPath();
            if (!defaultKWList.readFile(selectedFile)) {
                JOptionPane.showMessageDialog(this, "Warning: error reading: " + selectedFile);
            }
            FitsFile.setKeywordFilter(defaultKWList.getKeywordList());
        }
    }

    public void displayExtension(int i) {
        int row = this.model.getExtensionStartRow(i);
        if (row >= 0) {
            this.showCell(row, 0);
        }
    }

    private void displayExtension() {
        int selectIdx = extensionSelector.getSelectedIndex();
        if (selectIdx < 0) {
            selectIdx = 0;
        }
        this.displayExtension(selectIdx - 1);
    }

    @Override
    public void keyPressed(KeyEvent k) {
        if (k.getKeyCode() == 17) {
            this.cltrDown = true;
        } else if (k.getKeyCode() == 67 && this.cltrDown) {
            int row = -1;
            int col = -1;
            int[] rows = this.table.getSelectedRows();
            int[] cols = this.table.getSelectedColumns();
            if (rows.length > 0 && cols.length > 0) {
                row = rows[0];
                col = cols[0];
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                cb.setContents(new StringSelection((String)this.table.getValueAt(row, col)), null);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent k) {
        if (k.getKeyCode() == 17) {
            this.cltrDown = false;
        }
    }

    @Override
    public void keyTyped(KeyEvent k) {
    }

    public static boolean isShowExtensions() {
        return PropertyDB.getInstance().getProperty("SHOW_EXTENSIONS").equalsIgnoreCase("true");
    }

    private void setupCellRenderer() {
        TableCellRenderer tcr = this.table.getDefaultRenderer(Object.class);
        this.table.setDefaultRenderer(Object.class, new FitsKeywordDisplayRenderer(tcr));
    }
}

