/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Vector;
import org.eso.gasgano.datamodel.filesystem.FileSelectionModel;

public class DirectoryFileSelectionModel
extends FileSelectionModel {
    private final String[] dirs;

    public DirectoryFileSelectionModel() throws IOException {
        this(new String[0]);
    }

    public DirectoryFileSelectionModel(String[] dirsAndFiles) throws IOException {
        StringBuilder errorMessage = new StringBuilder("");
        LinkedHashSet<String> dirsAndFilesSet = new LinkedHashSet<String>(dirsAndFiles.length);
        for (String dirOrFile : dirsAndFiles) {
            if (dirOrFile == null) continue;
            try {
                File file = new File(dirOrFile);
                if (!file.exists()) continue;
                dirsAndFilesSet.add(file.getCanonicalPath());
            }
            catch (IOException e2) {
                errorMessage.append("\nCannot resolve path of " + dirOrFile + ". Reason: " + e2.getMessage());
            }
        }
        this.dirs = new String[dirsAndFilesSet.size()];
        dirsAndFilesSet.toArray(this.dirs);
        if (errorMessage.length() > 0) {
            throw new IOException();
        }
    }

    public String[] getDirs() {
        return this.dirs;
    }

    @Override
    public Vector getFileList() {
        LinkedHashSet<String> dirsAndFilesSet = new LinkedHashSet<String>();
        for (String path : this.dirs) {
            File f = new File(path);
            if (!f.exists()) continue;
            if (f.isFile()) {
                try {
                    dirsAndFilesSet.add(f.getCanonicalPath());
                }
                catch (IOException e2) {
                    System.err.println("\nCannot resolve path of " + f + ". Reason: " + e2.getMessage());
                }
                continue;
            }
            for (String dirOrFile : f.list()) {
                File file = new File(path + File.separator + dirOrFile);
                try {
                    dirsAndFilesSet.add(file.getCanonicalPath());
                }
                catch (IOException e3) {
                    System.err.println("\nCannot resolve path of " + file + ". Reason: " + e3.getMessage());
                }
            }
        }
        return new Vector(dirsAndFilesSet);
    }
}

