/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel;

import java.util.Enumeration;
import java.util.Vector;
import org.eso.gasgano.datamodel.DataModelChangeListener;
import org.eso.gasgano.datamodel.DataModelEvent;
import org.eso.gasgano.properties.PropertyDB;

public class DataModelChangeNotifier {
    private Vector dataModelListeners = null;

    public void addDataModelChangeListener(DataModelChangeListener l) {
        if (this.dataModelListeners == null) {
            this.dataModelListeners = new Vector();
        }
        this.dataModelListeners.addElement(l);
    }

    public void removeDataModelChangeListener(DataModelChangeListener l) {
        if (this.dataModelListeners != null) {
            this.dataModelListeners.removeElement(l);
        }
    }

    public void fireDataModelChangeEvent(DataModelEvent evt) {
        if (PropertyDB.getInstance().isDebug(6)) {
            System.out.print("fireDataModelChangeEvent:");
            if (this.dataModelListeners == null) {
                System.out.println(" for 0 listeners.");
            } else {
                System.out.println(" for " + this.dataModelListeners.size() + " listeners.");
            }
        }
        if (this.dataModelListeners != null) {
            Vector listenerCopy = (Vector)this.dataModelListeners.clone();
            Enumeration en = listenerCopy.elements();
            while (en.hasMoreElements()) {
                DataModelChangeListener l = (DataModelChangeListener)en.nextElement();
                if (l == null) continue;
                l.dataModelChanged(evt);
            }
        }
    }
}

