/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.gui;

import java.util.ArrayList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.eso.cpl.Parameter;
import org.eso.cpl.ParameterConstraint;
import org.eso.cpl.ParameterValueException;
import org.eso.cpl.RangeConstraint;
import org.eso.cpl.gui.DataColumn;
import org.eso.cpl.gui.DataColumnTableModel;
import org.eso.cpl.gui.Renderers;

public class ParameterTableModel
extends DataColumnTableModel {
    private final Parameter[] params_;

    public ParameterTableModel(Parameter[] params) {
        this.params_ = params;
        int nrow = params.length;
        final TableCellRenderer[] valueRenderers = new TableCellRenderer[nrow];
        final TableCellEditor[] valueEditors = new TableCellEditor[nrow];
        for (int irow = 0; irow < nrow; ++irow) {
            Parameter param = this.getParameter(irow);
            valueRenderers[irow] = Renderers.getParameterValueRenderer(param);
            valueEditors[irow] = Renderers.getParameterValueEditor(param);
        }
        abstract class ParameterDataColumn
        extends DataColumn {
            public ParameterDataColumn(String name, boolean isEditable, int prefWidth) {
                super(name, isEditable, prefWidth);
            }

            public ParameterDataColumn(String name, boolean isEditable) {
                super(name, isEditable);
            }

            @Override
            public String getRendererTip(int irow) {
                return ParameterTableModel.this.getParameter(irow).getHelp();
            }
        }
        ParameterDataColumn contextColumn = new ParameterDataColumn("Context", false){
            {
                super(x0, x1);
            }

            @Override
            public Object getValue(int irow) {
                return ParameterTableModel.this.getParameter(irow).getContext();
            }
        };
        ParameterDataColumn defaultColumn = new ParameterDataColumn("Default", false){
            {
                super(x0, x1);
            }

            @Override
            public Object getValue(int irow) {
                return ParameterTableModel.this.getParameter(irow).getDefault();
            }

            @Override
            public TableCellRenderer getCellRenderer(int irow) {
                return valueRenderers[irow];
            }
        };
        ParameterDataColumn helpColumn = new ParameterDataColumn("Description", false){
            {
                super(x0, x1);
            }

            @Override
            public Object getValue(int irow) {
                return ParameterTableModel.this.getParameter(irow).getHelp();
            }
        };
        ParameterDataColumn nameColumn = new ParameterDataColumn("Name", false, 200){
            {
                super(x0, x1, x2);
            }

            @Override
            public Object getValue(int irow) {
                return ParameterTableModel.this.getParameter(irow).getName();
            }
        };
        ParameterDataColumn rangeColumn = new ParameterDataColumn("Range", false){
            {
                super(x0, x1);
            }

            @Override
            public Object getValue(int irow) {
                ParameterConstraint cons = ParameterTableModel.this.getParameter(irow).getConstraint();
                if (cons instanceof RangeConstraint) {
                    RangeConstraint range = (RangeConstraint)cons;
                    return range.getMinimum() + ".." + range.getMaximum();
                }
                return null;
            }
        };
        ParameterDataColumn tagColumn = new ParameterDataColumn("Tag", false){
            {
                super(x0, x1);
            }

            @Override
            public Object getValue(int irow) {
                return ParameterTableModel.this.getParameter(irow).getTag();
            }
        };
        ParameterDataColumn typeColumn = new ParameterDataColumn("Type", false){
            {
                super(x0, x1);
            }

            @Override
            public Object getValue(int irow) {
                return ParameterTableModel.this.getParameter(irow).getType();
            }
        };
        ParameterDataColumn valueColumn = new ParameterDataColumn("Value", true){
            {
                super(x0, x1);
            }

            @Override
            public Object getValue(int irow) {
                return ParameterTableModel.this.getParameter(irow).getValue();
            }

            @Override
            public void setValue(int irow, Object value) {
                Parameter param = ParameterTableModel.this.getParameter(irow);
                try {
                    if (value instanceof String) {
                        param.setValueFromString((String)value);
                    } else {
                        param.setValue(value);
                    }
                }
                catch (ParameterValueException e2) {
                    // empty catch block
                }
            }

            @Override
            public TableCellRenderer getCellRenderer(int irow) {
                return valueRenderers[irow];
            }

            @Override
            public TableCellEditor getCellEditor(int irow) {
                return valueEditors[irow];
            }
        };
        ArrayList<ParameterDataColumn> columns = new ArrayList<ParameterDataColumn>();
        columns.add(nameColumn);
        columns.add(valueColumn);
        columns.add(defaultColumn);
        columns.add(rangeColumn);
        this.setDataColumns(columns);
    }

    @Override
    public int getRowCount() {
        return this.params_.length;
    }

    public Parameter getParameter(int irow) {
        return this.params_[irow];
    }
}

