/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.eso.cpl.gui.DataColumn;
import org.eso.cpl.gui.DataColumnTableModel;
import org.eso.dfs.gui.DnDJTable;

public class DataColumnTable
extends DnDJTable {
    private Color editableColor_;
    private Color fixedColor_;

    public DataColumnTable() {
        this.fixedColor_ = this.getBackground();
        this.editableColor_ = DataColumnTable.mixColors(Color.yellow, this.fixedColor_);
    }

    public DataColumnTable(DataColumnTableModel model) {
        super(model);
    }

    @Override
    public TableCellRenderer getCellRenderer(int irow, int icol) {
        DataColumn dcol = this.getDataColumn(icol);
        return dcol == null ? super.getCellRenderer(irow, icol) : dcol.getCellRenderer(irow);
    }

    @Override
    public TableCellEditor getCellEditor(int irow, int icol) {
        DataColumn dcol = this.getDataColumn(icol);
        return dcol == null ? super.getCellEditor(irow, icol) : dcol.getCellEditor(irow);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int irow, int icol) {
        Component cell = super.prepareRenderer(renderer, irow, icol);
        Object val = this.getValueAt(irow, icol);
        if (val instanceof Double && cell instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)cell).setText(val.toString());
        } else {
            cell = super.prepareRenderer(renderer, irow, icol);
        }
        if (cell instanceof JComponent) {
            DataColumn dcol = this.getDataColumn(icol);
            String tip = dcol == null ? null : dcol.getRendererTip(irow);
            ((JComponent)cell).setToolTipText(tip);
        }
        if (cell instanceof JLabel || cell instanceof JCheckBox) {
            cell.setBackground(this.isCellEditable(irow, icol) ? this.editableColor_ : this.fixedColor_);
        }
        return cell;
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int irow, int icol) {
        Component cell = super.prepareEditor(editor, irow, icol);
        if (!(cell instanceof JButton)) {
            cell.setBackground(this.isCellEditable(irow, icol) ? this.editableColor_ : this.fixedColor_);
        }
        return cell;
    }

    private DataColumn getDataColumn(int icol) {
        TableModel model = this.getModel();
        if (model instanceof DataColumnTableModel) {
            int jcol = this.getColumnModel().getColumn(icol).getModelIndex();
            return ((DataColumnTableModel)model).getDataColumn(jcol);
        }
        return null;
    }

    private static Color mixColors(Color c1, Color c2) {
        return new Color((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2);
    }

    @Override
    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        TableColumnModel cm = this.getColumnModel();
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            TableColumn tc = cm.getColumn(i);
            DataColumn dc = this.getDataColumn(i);
            if (dc == null) continue;
            tc.setPreferredWidth(dc.getPreferredWidth());
        }
    }
}

