/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eso.cpl.Frame;
import org.eso.cpl.FrameList;

public class MarkedFrameList
extends FrameList {
    private final Set isActive_ = new HashSet();
    private final Set isRetained_ = new HashSet();
    public final boolean activeDefault_ = true;
    public final boolean retainedDefault_ = false;

    public MarkedFrameList() {
    }

    public MarkedFrameList(Collection frames) {
        this();
        this.addAll(frames);
    }

    public boolean isActive(Frame frm) {
        return this.isActive_.contains(this.getID(frm));
    }

    public boolean isRetained(Frame frm) {
        return this.isRetained_.contains(this.getID(frm));
    }

    public void setActive(Frame frm, boolean isActive) {
        Object id = this.getID(frm);
        if (isActive) {
            this.isActive_.add(id);
        } else {
            this.isActive_.remove(id);
        }
    }

    public void setRetained(Frame frm, boolean isRetained) {
        Object id = this.getID(frm);
        if (isRetained) {
            this.isRetained_.add(id);
        } else {
            this.isRetained_.remove(id);
        }
    }

    public FrameList selectActive() {
        FrameList flist = new FrameList();
        for (Frame frm : this) {
            if (!this.isActive(frm)) continue;
            flist.add(frm);
        }
        return flist;
    }

    public FrameList selectRetained() {
        FrameList flist = new FrameList();
        for (Frame frm : this) {
            if (!this.isRetained(frm)) continue;
            flist.add(frm);
        }
        return flist;
    }

    @Override
    public Object set(int i, Object element) {
        Object old = super.set(i, element);
        this.forget(old);
        this.introduce(element);
        return old;
    }

    @Override
    public void add(int i, Object element) {
        super.add(i, element);
        this.introduce(element);
    }

    @Override
    public Object remove(int i) {
        Object element = super.remove(i);
        this.forget(element);
        return element;
    }

    private void introduce(Object item) {
        Object id = this.getID(item);
        this.isActive_.add(id);
    }

    private void forget(Object item) {
        Object id = this.getID(item);
        this.isActive_.remove(id);
        this.isRetained_.remove(id);
    }

    private Object getID(Object item) {
        return new Integer(System.identityHashCode(item));
    }
}

