/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.CursorableLinkedList;
import org.apache.commons.pool.BaseObjectPool;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class GenericObjectPool
extends BaseObjectPool
implements ObjectPool {
    public static final byte WHEN_EXHAUSTED_FAIL = 0;
    public static final byte WHEN_EXHAUSTED_BLOCK = 1;
    public static final byte WHEN_EXHAUSTED_GROW = 2;
    public static final int DEFAULT_MAX_IDLE = 8;
    public static final int DEFAULT_MIN_IDLE = 0;
    public static final int DEFAULT_MAX_ACTIVE = 8;
    public static final byte DEFAULT_WHEN_EXHAUSTED_ACTION = 1;
    public static final long DEFAULT_MAX_WAIT = -1L;
    public static final boolean DEFAULT_TEST_ON_BORROW = false;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_TEST_WHILE_IDLE = false;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = -1L;
    public static final int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 3;
    public static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000L;
    private int _maxIdle = 8;
    private int _minIdle = 0;
    private int _maxActive = 8;
    private long _maxWait = -1L;
    private byte _whenExhaustedAction = 1;
    private boolean _testOnBorrow = false;
    private boolean _testOnReturn = false;
    private boolean _testWhileIdle = false;
    private long _timeBetweenEvictionRunsMillis = -1L;
    private int _numTestsPerEvictionRun = 3;
    private long _minEvictableIdleTimeMillis = 1800000L;
    private CursorableLinkedList _pool = null;
    private PoolableObjectFactory _factory = null;
    private int _numActive = 0;
    private Evictor _evictor = null;
    private CursorableLinkedList.Cursor _evictionCursor = null;

    public GenericObjectPool() {
        this(null, 8, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory) {
        this(factory, 8, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, Config config) {
        this(factory, config.maxActive, config.whenExhaustedAction, config.maxWait, config.maxIdle, config.minIdle, config.testOnBorrow, config.testOnReturn, config.timeBetweenEvictionRunsMillis, config.numTestsPerEvictionRun, config.minEvictableIdleTimeMillis, config.testWhileIdle);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive) {
        this(factory, maxActive, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait) {
        this(factory, maxActive, whenExhaustedAction, maxWait, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, boolean testOnBorrow, boolean testOnReturn) {
        this(factory, maxActive, whenExhaustedAction, maxWait, 8, 0, testOnBorrow, testOnReturn, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, boolean testOnBorrow, boolean testOnReturn) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, 0, testOnBorrow, testOnReturn, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, 0, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, int minIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        this._factory = factory;
        this._maxActive = maxActive;
        switch (whenExhaustedAction) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = whenExhaustedAction;
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + whenExhaustedAction + " not recognized.");
            }
        }
        this._maxWait = maxWait;
        this._maxIdle = maxIdle;
        this._minIdle = minIdle;
        this._testOnBorrow = testOnBorrow;
        this._testOnReturn = testOnReturn;
        this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this._numTestsPerEvictionRun = numTestsPerEvictionRun;
        this._minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        this._testWhileIdle = testWhileIdle;
        this._pool = new CursorableLinkedList();
        this.startEvictor(this._timeBetweenEvictionRunsMillis);
    }

    public synchronized int getMaxActive() {
        return this._maxActive;
    }

    public synchronized void setMaxActive(int maxActive) {
        this._maxActive = maxActive;
        this.notifyAll();
    }

    public synchronized byte getWhenExhaustedAction() {
        return this._whenExhaustedAction;
    }

    public synchronized void setWhenExhaustedAction(byte whenExhaustedAction) {
        switch (whenExhaustedAction) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = whenExhaustedAction;
                this.notifyAll();
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + whenExhaustedAction + " not recognized.");
            }
        }
    }

    public synchronized long getMaxWait() {
        return this._maxWait;
    }

    public synchronized void setMaxWait(long maxWait) {
        this._maxWait = maxWait;
        this.notifyAll();
    }

    public synchronized int getMaxIdle() {
        return this._maxIdle;
    }

    public synchronized void setMaxIdle(int maxIdle) {
        this._maxIdle = maxIdle;
        this.notifyAll();
    }

    public synchronized void setMinIdle(int minIdle) {
        this._minIdle = minIdle;
        this.notifyAll();
    }

    public synchronized int getMinIdle() {
        return this._minIdle;
    }

    public synchronized boolean getTestOnBorrow() {
        return this._testOnBorrow;
    }

    public synchronized void setTestOnBorrow(boolean testOnBorrow) {
        this._testOnBorrow = testOnBorrow;
    }

    public synchronized boolean getTestOnReturn() {
        return this._testOnReturn;
    }

    public synchronized void setTestOnReturn(boolean testOnReturn) {
        this._testOnReturn = testOnReturn;
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this._timeBetweenEvictionRunsMillis;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this.startEvictor(this._timeBetweenEvictionRunsMillis);
    }

    public synchronized int getNumTestsPerEvictionRun() {
        return this._numTestsPerEvictionRun;
    }

    public synchronized void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this._numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this._minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public synchronized boolean getTestWhileIdle() {
        return this._testWhileIdle;
    }

    public synchronized void setTestWhileIdle(boolean testWhileIdle) {
        this._testWhileIdle = testWhileIdle;
    }

    public synchronized void setConfig(Config conf) {
        this.setMaxIdle(conf.maxIdle);
        this.setMinIdle(conf.minIdle);
        this.setMaxActive(conf.maxActive);
        this.setMaxWait(conf.maxWait);
        this.setWhenExhaustedAction(conf.whenExhaustedAction);
        this.setTestOnBorrow(conf.testOnBorrow);
        this.setTestOnReturn(conf.testOnReturn);
        this.setTestWhileIdle(conf.testWhileIdle);
        this.setNumTestsPerEvictionRun(conf.numTestsPerEvictionRun);
        this.setMinEvictableIdleTimeMillis(conf.minEvictableIdleTimeMillis);
        this.setTimeBetweenEvictionRunsMillis(conf.timeBetweenEvictionRunsMillis);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object borrowObject() throws Exception {
        long starttime = System.currentTimeMillis();
        boolean newlyCreated = false;
        block24: while (true) {
            GenericObjectPool genericObjectPool;
            ObjectTimestampPair pair = null;
            GenericObjectPool genericObjectPool2 = this;
            synchronized (genericObjectPool2) {
                this.assertOpen();
                try {
                    pair = (ObjectTimestampPair)this._pool.removeFirst();
                }
                catch (NoSuchElementException e2) {
                    // empty catch block
                }
                if (null == pair && this._maxActive > 0 && this._numActive >= this._maxActive) {
                    switch (this._whenExhaustedAction) {
                        case 2: {
                            break;
                        }
                        case 0: {
                            throw new NoSuchElementException();
                        }
                        case 1: {
                            try {
                                if (this._maxWait <= 0L) {
                                    this.wait();
                                } else {
                                    this.wait(this._maxWait);
                                }
                            }
                            catch (InterruptedException e3) {
                                // empty catch block
                            }
                            if (this._maxWait > 0L && System.currentTimeMillis() - starttime >= this._maxWait) {
                                throw new NoSuchElementException("Timeout waiting for idle object");
                            }
                            continue block24;
                        }
                        default: {
                            throw new IllegalArgumentException("whenExhaustedAction " + this._whenExhaustedAction + " not recognized.");
                        }
                    }
                }
                ++this._numActive;
            }
            if (null == pair) {
                try {
                    Object obj = this._factory.makeObject();
                    pair = new ObjectTimestampPair(obj);
                    newlyCreated = true;
                }
                catch (Exception e4) {
                    genericObjectPool = this;
                    synchronized (genericObjectPool) {
                        --this._numActive;
                        this.notifyAll();
                        throw e4;
                    }
                }
            }
            try {
                this._factory.activateObject(pair.value);
                if (!this._testOnBorrow || this._factory.validateObject(pair.value)) return pair.value;
                throw new Exception("validateObject failed");
            }
            catch (Exception e5) {
                genericObjectPool = this;
                synchronized (genericObjectPool) {
                    --this._numActive;
                    this.notifyAll();
                }
                try {
                    this._factory.destroyObject(pair.value);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (newlyCreated) throw new NoSuchElementException("Could not create a validated object, cause: " + e5.getMessage());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateObject(Object obj) throws Exception {
        GenericObjectPool genericObjectPool;
        this.assertOpen();
        try {
            this._factory.destroyObject(obj);
            Object var3_2 = null;
            genericObjectPool = this;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            GenericObjectPool genericObjectPool2 = this;
            synchronized (genericObjectPool2) {
                --this._numActive;
                this.notifyAll();
            }
            throw throwable;
        }
        synchronized (genericObjectPool) {
            --this._numActive;
            this.notifyAll();
        }
    }

    public synchronized void clear() {
        this.assertOpen();
        Iterator it = this._pool.iterator();
        while (it.hasNext()) {
            try {
                this._factory.destroyObject(((ObjectTimestampPair)it.next()).value);
            }
            catch (Exception e2) {
                // empty catch block
            }
            it.remove();
        }
        this._pool.clear();
        this.notifyAll();
    }

    public synchronized int getNumActive() {
        this.assertOpen();
        return this._numActive;
    }

    public synchronized int getNumIdle() {
        this.assertOpen();
        return this._pool.size();
    }

    public void returnObject(Object obj) throws Exception {
        this.assertOpen();
        this.addObjectToPool(obj, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObjectToPool(Object obj, boolean decrementNumActive) throws Exception {
        block13: {
            boolean success = true;
            if (this._testOnReturn && !this._factory.validateObject(obj)) {
                success = false;
            } else {
                try {
                    this._factory.passivateObject(obj);
                }
                catch (Exception e2) {
                    success = false;
                }
            }
            boolean shouldDestroy = !success;
            GenericObjectPool genericObjectPool = this;
            synchronized (genericObjectPool) {
                if (decrementNumActive) {
                    --this._numActive;
                }
                if (this._maxIdle >= 0 && this._pool.size() >= this._maxIdle) {
                    shouldDestroy = true;
                } else if (success) {
                    this._pool.addFirst(new ObjectTimestampPair(obj));
                }
                this.notifyAll();
            }
            if (!shouldDestroy) break block13;
            try {
                this._factory.destroyObject(obj);
            }
            catch (Exception e3) {}
        }
    }

    public synchronized void close() throws Exception {
        this.clear();
        this._pool = null;
        this._factory = null;
        if (null != this._evictionCursor) {
            this._evictionCursor.close();
            this._evictionCursor = null;
        }
        this.startEvictor(-1L);
        super.close();
    }

    public synchronized void setFactory(PoolableObjectFactory factory) throws IllegalStateException {
        this.assertOpen();
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = factory;
    }

    public synchronized void evict() throws Exception {
        this.assertOpen();
        if (!this._pool.isEmpty()) {
            if (null == this._evictionCursor) {
                this._evictionCursor = this._pool.cursor(this._pool.size());
            } else if (!this._evictionCursor.hasPrevious()) {
                this._evictionCursor.close();
                this._evictionCursor = this._pool.cursor(this._pool.size());
            }
            int i = 0;
            int m = this.getNumTests();
            while (i < m) {
                if (!this._evictionCursor.hasPrevious()) {
                    this._evictionCursor.close();
                    this._evictionCursor = this._pool.cursor(this._pool.size());
                } else {
                    boolean removeObject = false;
                    ObjectTimestampPair pair = (ObjectTimestampPair)this._evictionCursor.previous();
                    if (this._minEvictableIdleTimeMillis > 0L && System.currentTimeMillis() - pair.tstamp > this._minEvictableIdleTimeMillis) {
                        removeObject = true;
                    } else if (this._testWhileIdle) {
                        boolean active = false;
                        try {
                            this._factory.activateObject(pair.value);
                            active = true;
                        }
                        catch (Exception e2) {
                            removeObject = true;
                        }
                        if (active) {
                            if (!this._factory.validateObject(pair.value)) {
                                removeObject = true;
                            } else {
                                try {
                                    this._factory.passivateObject(pair.value);
                                }
                                catch (Exception e3) {
                                    removeObject = true;
                                }
                            }
                        }
                    }
                    if (removeObject) {
                        try {
                            this._evictionCursor.remove();
                            this._factory.destroyObject(pair.value);
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void ensureMinIdle() throws Exception {
        int objectDeficit = this.calculateDeficit();
        int j = 0;
        while (j < objectDeficit && this.calculateDeficit() > 0) {
            this.addObject();
            ++j;
        }
    }

    private synchronized int calculateDeficit() {
        int objectDeficit = this.getMinIdle() - this.getNumIdle();
        if (this._maxActive > 0) {
            int growLimit = Math.max(0, this.getMaxActive() - this.getNumActive() - this.getNumIdle());
            objectDeficit = Math.min(objectDeficit, growLimit);
        }
        return objectDeficit;
    }

    public void addObject() throws Exception {
        Object obj = this._factory.makeObject();
        this.addObjectToPool(obj, false);
    }

    protected synchronized void startEvictor(long delay) {
        if (null != this._evictor) {
            this._evictor.cancel();
            this._evictor = null;
        }
        if (delay > 0L) {
            this._evictor = new Evictor(delay);
            Thread t = new Thread(this._evictor);
            t.setDaemon(true);
            t.start();
        }
    }

    synchronized String debugInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append("Active: ").append(this.getNumActive()).append("\n");
        buf.append("Idle: ").append(this.getNumIdle()).append("\n");
        buf.append("Idle Objects:\n");
        Iterator it = this._pool.iterator();
        long time = System.currentTimeMillis();
        while (it.hasNext()) {
            ObjectTimestampPair pair = (ObjectTimestampPair)it.next();
            buf.append("\t").append(pair.value).append("\t").append(time - pair.tstamp).append("\n");
        }
        return buf.toString();
    }

    private int getNumTests() {
        if (this._numTestsPerEvictionRun >= 0) {
            return this._numTestsPerEvictionRun;
        }
        return (int)Math.ceil((double)this._pool.size() / Math.abs((double)this._numTestsPerEvictionRun));
    }

    public static class Config {
        public int maxIdle = 8;
        public int minIdle = 0;
        public int maxActive = 8;
        public long maxWait = -1L;
        public byte whenExhaustedAction = 1;
        public boolean testOnBorrow = false;
        public boolean testOnReturn = false;
        public boolean testWhileIdle = false;
        public long timeBetweenEvictionRunsMillis = -1L;
        public int numTestsPerEvictionRun = 3;
        public long minEvictableIdleTimeMillis = 1800000L;
    }

    class Evictor
    implements Runnable {
        private boolean _cancelled = false;
        private long _delay = 0L;

        public Evictor(long delay) {
            this._delay = delay;
        }

        void cancel() {
            this._cancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this._cancelled) {
                try {
                    Thread.sleep(this._delay);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    GenericObjectPool.this.evict();
                }
                catch (Exception e3) {
                    // empty catch block
                }
                try {
                    GenericObjectPool.this.ensureMinIdle();
                }
                catch (Exception e4) {
                    // empty catch block
                }
            }
            GenericObjectPool genericObjectPool = GenericObjectPool.this;
            synchronized (genericObjectPool) {
                if (null != GenericObjectPool.this._evictionCursor) {
                    GenericObjectPool.this._evictionCursor.close();
                    GenericObjectPool.this._evictionCursor = null;
                }
            }
        }
    }

    class ObjectTimestampPair {
        Object value;
        long tstamp;

        ObjectTimestampPair(Object val) {
            this(val, System.currentTimeMillis());
        }

        ObjectTimestampPair(Object val, long time) {
            this.value = val;
            this.tstamp = time;
        }
    }
}

