/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import nom.tam.util.ArrayDataOutput;

public class BufferedDataOutputStream
extends BufferedOutputStream
implements ArrayDataOutput {
    public BufferedDataOutputStream(OutputStream o) {
        super(o, 32768);
    }

    public BufferedDataOutputStream(OutputStream o, int bufLength) {
        super(o, bufLength);
    }

    @Override
    public void writeBoolean(boolean b2) throws IOException {
        this.checkBuf(1);
        this.buf[this.count++] = b2 ? (byte)1 : 0;
    }

    @Override
    public void writeByte(int b2) throws IOException {
        this.checkBuf(1);
        this.buf[this.count++] = (byte)b2;
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.checkBuf(4);
        this.buf[this.count++] = (byte)(i >>> 24);
        this.buf[this.count++] = (byte)(i >>> 16);
        this.buf[this.count++] = (byte)(i >>> 8);
        this.buf[this.count++] = (byte)i;
    }

    @Override
    public void writeShort(int s) throws IOException {
        this.checkBuf(2);
        this.buf[this.count++] = (byte)(s >>> 8);
        this.buf[this.count++] = (byte)s;
    }

    @Override
    public void writeChar(int c2) throws IOException {
        this.checkBuf(2);
        this.buf[this.count++] = (byte)(c2 >>> 8);
        this.buf[this.count++] = (byte)c2;
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.checkBuf(8);
        this.buf[this.count++] = (byte)(l >>> 56);
        this.buf[this.count++] = (byte)(l >>> 48);
        this.buf[this.count++] = (byte)(l >>> 40);
        this.buf[this.count++] = (byte)(l >>> 32);
        this.buf[this.count++] = (byte)(l >>> 24);
        this.buf[this.count++] = (byte)(l >>> 16);
        this.buf[this.count++] = (byte)(l >>> 8);
        this.buf[this.count++] = (byte)l;
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.checkBuf(4);
        int i = Float.floatToIntBits(f);
        this.buf[this.count++] = (byte)(i >>> 24);
        this.buf[this.count++] = (byte)(i >>> 16);
        this.buf[this.count++] = (byte)(i >>> 8);
        this.buf[this.count++] = (byte)i;
    }

    @Override
    public void writeDouble(double d2) throws IOException {
        this.checkBuf(8);
        long l = Double.doubleToLongBits(d2);
        this.buf[this.count++] = (byte)(l >>> 56);
        this.buf[this.count++] = (byte)(l >>> 48);
        this.buf[this.count++] = (byte)(l >>> 40);
        this.buf[this.count++] = (byte)(l >>> 32);
        this.buf[this.count++] = (byte)(l >>> 24);
        this.buf[this.count++] = (byte)(l >>> 16);
        this.buf[this.count++] = (byte)(l >>> 8);
        this.buf[this.count++] = (byte)l;
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.write(s.getBytes(), 0, s.length());
    }

    @Override
    public void writeChars(String s) throws IOException {
        int i = 0;
        while (i < s.length()) {
            this.writeChar(s.charAt(i));
            ++i;
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        DataOutputStream d2 = new DataOutputStream(this);
        d2.writeUTF(s);
        d2.flush();
        d2.close();
    }

    public void writePrimitiveArray(Object o) throws IOException {
        this.writeArray(o);
    }

    @Override
    public void writeArray(Object o) throws IOException {
        String className = o.getClass().getName();
        if (className.charAt(0) != '[') {
            throw new IOException("Invalid object passed to BufferedDataOutputStream.write" + className);
        }
        if (className.charAt(1) == '[') {
            int i = 0;
            while (i < ((Object[])o).length) {
                this.writeArray(((Object[])o)[i]);
                ++i;
            }
        } else {
            switch (className.charAt(1)) {
                case 'Z': {
                    this.write((boolean[])o, 0, ((boolean[])o).length);
                    break;
                }
                case 'B': {
                    this.write((byte[])o, 0, ((byte[])o).length);
                    break;
                }
                case 'C': {
                    this.write((char[])o, 0, ((char[])o).length);
                    break;
                }
                case 'S': {
                    this.write((short[])o, 0, ((short[])o).length);
                    break;
                }
                case 'I': {
                    this.write((int[])o, 0, ((int[])o).length);
                    break;
                }
                case 'J': {
                    this.write((long[])o, 0, ((long[])o).length);
                    break;
                }
                case 'F': {
                    this.write((float[])o, 0, ((float[])o).length);
                    break;
                }
                case 'D': {
                    this.write((double[])o, 0, ((double[])o).length);
                    break;
                }
                case 'L': {
                    if (className.equals("[Ljava.lang.String;")) {
                        this.write((String[])o, 0, ((String[])o).length);
                        break;
                    }
                    if (className.equals("[Ljava.lang.Object;")) {
                        int i = 0;
                        while (i < ((Object[])o).length) {
                            this.writeArray(((Object[])o)[i]);
                            ++i;
                        }
                        break;
                    }
                    throw new IOException("Invalid object passed to BufferedDataOutputStream.writeArray: " + className);
                }
                default: {
                    throw new IOException("Invalid object passed to BufferedDataOutputStream.writeArray: " + className);
                }
            }
        }
    }

    @Override
    public void write(boolean[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(boolean[] b2, int start, int len) throws IOException {
        int i = start;
        while (i < start + len) {
            if (this.count + 1 > this.buf.length) {
                this.checkBuf(1);
            }
            this.buf[this.count++] = b2[i] ? (byte)1 : 0;
            ++i;
        }
    }

    @Override
    public void write(short[] s) throws IOException {
        this.write(s, 0, s.length);
    }

    @Override
    public void write(short[] s, int start, int len) throws IOException {
        int i = start;
        while (i < start + len) {
            if (this.count + 2 > this.buf.length) {
                this.checkBuf(2);
            }
            this.buf[this.count++] = (byte)(s[i] >> 8);
            this.buf[this.count++] = (byte)s[i];
            ++i;
        }
    }

    @Override
    public void write(char[] c2) throws IOException {
        this.write(c2, 0, c2.length);
    }

    @Override
    public void write(char[] c2, int start, int len) throws IOException {
        int i = start;
        while (i < start + len) {
            if (this.count + 2 > this.buf.length) {
                this.checkBuf(2);
            }
            this.buf[this.count++] = (byte)(c2[i] >> 8);
            this.buf[this.count++] = (byte)c2[i];
            ++i;
        }
    }

    @Override
    public void write(int[] i) throws IOException {
        this.write(i, 0, i.length);
    }

    @Override
    public void write(int[] i, int start, int len) throws IOException {
        int ii = start;
        while (ii < start + len) {
            if (this.count + 4 > this.buf.length) {
                this.checkBuf(4);
            }
            this.buf[this.count++] = (byte)(i[ii] >>> 24);
            this.buf[this.count++] = (byte)(i[ii] >>> 16);
            this.buf[this.count++] = (byte)(i[ii] >>> 8);
            this.buf[this.count++] = (byte)i[ii];
            ++ii;
        }
    }

    @Override
    public void write(long[] l) throws IOException {
        this.write(l, 0, l.length);
    }

    @Override
    public void write(long[] l, int start, int len) throws IOException {
        int i = start;
        while (i < start + len) {
            if (this.count + 8 > this.buf.length) {
                this.checkBuf(8);
            }
            int t = (int)(l[i] >>> 32);
            this.buf[this.count++] = (byte)(t >>> 24);
            this.buf[this.count++] = (byte)(t >>> 16);
            this.buf[this.count++] = (byte)(t >>> 8);
            this.buf[this.count++] = (byte)t;
            t = (int)l[i];
            this.buf[this.count++] = (byte)(t >>> 24);
            this.buf[this.count++] = (byte)(t >>> 16);
            this.buf[this.count++] = (byte)(t >>> 8);
            this.buf[this.count++] = (byte)t;
            ++i;
        }
    }

    @Override
    public void write(float[] f) throws IOException {
        this.write(f, 0, f.length);
    }

    @Override
    public void write(float[] f, int start, int len) throws IOException {
        int i = start;
        while (i < start + len) {
            if (this.count + 4 > this.buf.length) {
                this.checkBuf(4);
            }
            int t = Float.floatToIntBits(f[i]);
            this.buf[this.count++] = (byte)(t >>> 24);
            this.buf[this.count++] = (byte)(t >>> 16);
            this.buf[this.count++] = (byte)(t >>> 8);
            this.buf[this.count++] = (byte)t;
            ++i;
        }
    }

    @Override
    public void write(double[] d2) throws IOException {
        this.write(d2, 0, d2.length);
    }

    @Override
    public void write(double[] d2, int start, int len) throws IOException {
        int i = start;
        while (i < start + len) {
            if (this.count + 8 > this.buf.length) {
                this.checkBuf(8);
            }
            long t = Double.doubleToLongBits(d2[i]);
            int ix = (int)(t >>> 32);
            this.buf[this.count++] = (byte)(ix >>> 24);
            this.buf[this.count++] = (byte)(ix >>> 16);
            this.buf[this.count++] = (byte)(ix >>> 8);
            this.buf[this.count++] = (byte)ix;
            ix = (int)t;
            this.buf[this.count++] = (byte)(ix >>> 24);
            this.buf[this.count++] = (byte)(ix >>> 16);
            this.buf[this.count++] = (byte)(ix >>> 8);
            this.buf[this.count++] = (byte)ix;
            ++i;
        }
    }

    @Override
    public void write(String[] s) throws IOException {
        this.write(s, 0, s.length);
    }

    @Override
    public void write(String[] s, int start, int len) throws IOException {
        int i = 0;
        while (i < s.length) {
            this.writeBytes(s[i]);
            ++i;
        }
    }

    protected void checkBuf(int need) throws IOException {
        if (this.count + need > this.buf.length) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }
}

