/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.RandomGroupsData;
import nom.tam.util.ArrayFuncs;

public class RandomGroupsHDU
extends BasicHDU {
    Object dataArray;

    public RandomGroupsHDU(Header h, Data d2) {
        this.myHeader = h;
        this.myData = d2;
    }

    @Override
    protected boolean canBePrimary() {
        return true;
    }

    @Override
    protected void setPrimaryHDU(boolean status) {
        try {
            super.setPrimaryHDU(status);
        }
        catch (FitsException e2) {
            System.err.println("Unreachable catch in RandomGroupsHDU");
        }
        if (status) {
            this.myHeader.setSimple(true);
        } else {
            this.myHeader.setXtension("IMAGE");
        }
    }

    static Header manufactureHeader(Data d2) throws FitsException {
        if (d2 == null) {
            throw new FitsException("Attempt to create null Random Groups data");
        }
        Header h = new Header();
        d2.fillHeader(h);
        return h;
    }

    public static boolean isHeader(Header hdr) {
        if (hdr.getBooleanValue("SIMPLE")) {
            return hdr.getBooleanValue("GROUPS");
        }
        String s = hdr.getStringValue("XTENSION");
        if (s.trim().equals("IMAGE")) {
            return hdr.getBooleanValue("GROUPS");
        }
        return false;
    }

    public boolean isHeader() {
        return RandomGroupsHDU.isHeader(this.myHeader);
    }

    public static boolean isData(Object oo) {
        String cn;
        Object[][] o;
        return oo instanceof Object[][] && (o = (Object[][])oo).length > 0 && o[0].length == 2 && ArrayFuncs.getBaseClass(o[0][0]) == ArrayFuncs.getBaseClass(o[0][1]) && ((cn = o[0][0].getClass().getName()).length() == 2 && cn.charAt(1) != 'Z' || cn.charAt(1) != 'C');
    }

    @Override
    public Data manufactureData() throws FitsException {
        return RandomGroupsHDU.manufactureData(this.myHeader);
    }

    public static Data manufactureData(Header hdr) throws FitsException {
        int gcount = hdr.getIntValue("GCOUNT", -1);
        int pcount = hdr.getIntValue("PCOUNT", -1);
        if (!hdr.getBooleanValue("GROUPS") || hdr.getIntValue("NAXIS1", -1) != 0 || gcount < 0 || pcount < 0 || hdr.getIntValue("NAXIS") < 2) {
            throw new FitsException("Invalid Random Groups Parameters");
        }
        Object dataArray = gcount > 0 ? new Object[gcount][2] : new Object[][]{};
        Object[] sampleRow = RandomGroupsHDU.generateSampleRow(hdr);
        int i = 0;
        while (i < gcount) {
            dataArray[i][0] = ((Object[])ArrayFuncs.deepClone(sampleRow))[0];
            dataArray[i][1] = ((Object[])ArrayFuncs.deepClone(sampleRow))[1];
            ++i;
        }
        return new RandomGroupsData((Object[][])dataArray);
    }

    static Object[] generateSampleRow(Header h) throws FitsException {
        Class<Number> baseClass;
        int ndim = h.getIntValue("NAXIS", 0) - 1;
        int[] dims = new int[ndim];
        int bitpix = h.getIntValue("BITPIX", 0);
        switch (bitpix) {
            case 8: {
                baseClass = Byte.TYPE;
                break;
            }
            case 16: {
                baseClass = Short.TYPE;
                break;
            }
            case 32: {
                baseClass = Integer.TYPE;
                break;
            }
            case 64: {
                baseClass = Long.TYPE;
                break;
            }
            case -32: {
                baseClass = Float.TYPE;
                break;
            }
            case -64: {
                baseClass = Double.TYPE;
                break;
            }
            default: {
                throw new FitsException("Invalid BITPIX:" + bitpix);
            }
        }
        int i = 0;
        while (i < ndim) {
            long cdim = h.getIntValue("NAXIS" + (i + 2), 0);
            if (cdim < 0L) {
                throw new FitsException("Invalid array dimension:" + cdim);
            }
            dims[ndim - i - 1] = (int)cdim;
            ++i;
        }
        Object[] sample = new Object[]{ArrayFuncs.newInstance(baseClass, h.getIntValue("PCOUNT")), ArrayFuncs.newInstance(baseClass, dims)};
        return sample;
    }

    public static Data encapsulate(Object o) throws FitsException {
        if (o instanceof Object[][]) {
            return new RandomGroupsData((Object[][])o);
        }
        throw new FitsException("Attempt to encapsulate invalid data in Random Group");
    }

    @Override
    public void info() {
        System.out.println("Random Groups HDU");
        if (this.myHeader != null) {
            System.out.println("   HeaderInformation:");
            System.out.println("     Ngroups:" + this.myHeader.getIntValue("GCOUNT"));
            System.out.println("     Npar:   " + this.myHeader.getIntValue("PCOUNT"));
            System.out.println("     BITPIX: " + this.myHeader.getIntValue("BITPIX"));
            System.out.println("     NAXIS:  " + this.myHeader.getIntValue("NAXIS"));
            int i = 0;
            while (i < this.myHeader.getIntValue("NAXIS")) {
                System.out.println("      NAXIS" + (i + 1) + "= " + this.myHeader.getIntValue("NAXIS" + (i + 1)));
                ++i;
            }
        } else {
            System.out.println("    No Header Information");
        }
        Object[][] data = null;
        if (this.myData != null) {
            try {
                data = (Object[][])this.myData.getData();
            }
            catch (FitsException e2) {
                data = null;
            }
        }
        if (data == null || data.length < 1 || data[0].length != 2) {
            System.out.println("    Invalid/unreadable data");
        } else {
            System.out.println("    Number of groups:" + data.length);
            System.out.println("    Parameters: " + ArrayFuncs.arrayDescription(data[0][0]));
            System.out.println("    Data:" + ArrayFuncs.arrayDescription(data[0][1]));
        }
    }
}

