/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IAxis;

public class FixedAxis
implements IAxis {
    private int bins;
    private double min;
    private double binWidth;
    private int xunder;
    private int xover;

    public FixedAxis(int n, double d2, double d3) {
        if (n < 1) {
            throw new IllegalArgumentException("bins=" + n);
        }
        if (d3 <= d2) {
            throw new IllegalArgumentException("max <= min");
        }
        this.bins = n;
        this.min = d2;
        this.binWidth = (d3 - d2) / (double)n;
    }

    public double binCentre(int n) {
        return this.min + this.binWidth * (double)n + this.binWidth / 2.0;
    }

    public double binLowerEdge(int n) {
        if (n == -2) {
            return Double.NEGATIVE_INFINITY;
        }
        if (n == -1) {
            return this.upperEdge();
        }
        return this.min + this.binWidth * (double)n;
    }

    public int bins() {
        return this.bins;
    }

    public double binUpperEdge(int n) {
        if (n == -2) {
            return this.min;
        }
        if (n == -1) {
            return Double.POSITIVE_INFINITY;
        }
        return this.min + this.binWidth * (double)(n + 1);
    }

    public double binWidth(int n) {
        return this.binWidth;
    }

    public int coordToIndex(double d2) {
        if (d2 < this.min) {
            return -2;
        }
        int n = (int)Math.floor((d2 - this.min) / this.binWidth);
        if (n >= this.bins) {
            return -1;
        }
        return n;
    }

    public double lowerEdge() {
        return this.min;
    }

    public double upperEdge() {
        return this.min + this.binWidth * (double)this.bins;
    }

    int xgetBin(double d2) {
        if (d2 < this.min) {
            return this.xunder;
        }
        int n = (int)Math.floor((d2 - this.min) / this.binWidth);
        if (n > this.bins) {
            return this.xover;
        }
        return n + 1;
    }

    int xmap(int n) {
        if (n >= this.bins) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return this.xunder;
        }
        if (n == -1) {
            return this.xover;
        }
        throw new IllegalArgumentException("bin=" + n);
    }
}

