/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;

final class RETokenPOSIX
extends REToken {
    static final int ALNUM = 0;
    static final int ALPHA = 1;
    static final int BLANK = 2;
    static final int CNTRL = 3;
    static final int DIGIT = 4;
    static final int GRAPH = 5;
    static final int LOWER = 6;
    static final int PRINT = 7;
    static final int PUNCT = 8;
    static final int SPACE = 9;
    static final int UPPER = 10;
    static final int XDIGIT = 11;
    static final String[] s_nameTable = new String[]{"alnum", "alpha", "blank", "cntrl", "digit", "graph", "lower", "print", "punct", "space", "upper", "xdigit"};
    int type;
    boolean insens;
    boolean negated;

    static int intValue(String string) {
        int n = 0;
        while (n < s_nameTable.length) {
            if (s_nameTable[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    int getMinimumLength() {
        return 1;
    }

    boolean match(CharIndexed charIndexed, REMatch rEMatch) {
        char c2 = charIndexed.charAt(rEMatch.index);
        if (c2 == '\uffff') {
            return false;
        }
        boolean bl = false;
        switch (this.type) {
            case 0: {
                bl = Character.isLetterOrDigit(c2) || c2 == '_';
                break;
            }
            case 1: {
                bl = Character.isLetter(c2);
                break;
            }
            case 2: {
                bl = c2 == ' ' || c2 == '\t';
                break;
            }
            case 3: {
                bl = Character.isISOControl(c2);
                break;
            }
            case 4: {
                bl = Character.isDigit(c2);
                break;
            }
            case 5: {
                bl = !(Character.isWhitespace(c2) || Character.isISOControl(c2));
                break;
            }
            case 6: {
                bl = this.insens && Character.isLetter(c2) || Character.isLowerCase(c2);
                break;
            }
            case 7: {
                bl = !Character.isWhitespace(c2) && !Character.isISOControl(c2) || c2 == ' ';
                break;
            }
            case 8: {
                bl = "`~!@#$%^&*()-_=+[]{}\\|;:'\"/?,.<>".indexOf(c2) != -1;
                break;
            }
            case 9: {
                bl = Character.isWhitespace(c2);
                break;
            }
            case 10: {
                bl = this.insens && Character.isLetter(c2) || Character.isUpperCase(c2);
                break;
            }
            case 11: {
                bl = Character.isDigit(c2) || "abcdefABCDEF".indexOf(c2) != -1;
                break;
            }
        }
        if (this.negated) {
            boolean bl2 = bl = !bl;
        }
        if (bl) {
            ++rEMatch.index;
            return this.next(charIndexed, rEMatch);
        }
        return false;
    }

    void dump(StringBuffer stringBuffer) {
        if (this.negated) {
            stringBuffer.append('^');
        }
        stringBuffer.append("[:" + s_nameTable[this.type] + ":]");
    }

    RETokenPOSIX(int n, int n2, boolean bl, boolean bl2) {
        super(n);
        this.type = n2;
        this.insens = bl;
        this.negated = bl2;
    }
}

