/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.mbox;

import java.io.IOException;
import java.io.OutputStream;

class ContentLengthCounter
extends OutputStream {
    private long size = 0L;
    private boolean inHeader = true;
    private int lastb1 = -1;
    private int lastb2 = -1;

    ContentLengthCounter() {
    }

    public void write(int b2) throws IOException {
        if (this.inHeader) {
            if (b2 == 13 && this.lastb1 == 13) {
                this.inHeader = false;
            } else if (b2 == 10) {
                if (this.lastb1 == 10) {
                    this.inHeader = false;
                } else if (this.lastb1 == 13 && this.lastb2 == 10) {
                    this.inHeader = false;
                }
            }
            this.lastb2 = this.lastb1;
            this.lastb1 = b2;
        } else {
            ++this.size;
        }
    }

    public void write(byte[] b2) throws IOException {
        if (this.inHeader) {
            super.write(b2);
        } else {
            this.size += (long)b2.length;
        }
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.inHeader) {
            super.write(b2, off, len);
        } else {
            this.size += (long)len;
        }
    }

    public long getSize() {
        return this.size;
    }

    public static void main(String[] argv) throws Exception {
        int b2;
        ContentLengthCounter os = new ContentLengthCounter();
        while ((b2 = System.in.read()) >= 0) {
            os.write(b2);
        }
        System.out.println("size " + os.getSize());
    }
}

