/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.ser;

import com.mchange.v1.io.InputStreamUtils;
import com.mchange.v1.io.OutputStreamUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.ser.IndirectPolicy;
import com.mchange.v2.ser.IndirectlySerialized;
import com.mchange.v2.ser.Indirector;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class SerializableUtils {
    static final MLogger logger = MLog.getLogger(SerializableUtils.class);

    private SerializableUtils() {
    }

    public static byte[] toByteArray(Object obj) throws NotSerializableException {
        return SerializableUtils.serializeToByteArray(obj);
    }

    public static byte[] toByteArray(Object obj, Indirector indirector, IndirectPolicy policy) throws NotSerializableException {
        try {
            if (policy == IndirectPolicy.DEFINITELY_INDIRECT) {
                if (indirector == null) {
                    throw new IllegalArgumentException("null indirector is not consistent with " + policy);
                }
                IndirectlySerialized indirect = indirector.indirectForm(obj);
                return SerializableUtils.toByteArray(indirect);
            }
            if (policy == IndirectPolicy.INDIRECT_ON_EXCEPTION) {
                if (indirector == null) {
                    throw new IllegalArgumentException("null indirector is not consistent with " + policy);
                }
                try {
                    return SerializableUtils.toByteArray(obj);
                }
                catch (NotSerializableException e2) {
                    return SerializableUtils.toByteArray(obj, indirector, IndirectPolicy.DEFINITELY_INDIRECT);
                }
            }
            if (policy == IndirectPolicy.DEFINITELY_DIRECT) {
                return SerializableUtils.toByteArray(obj);
            }
            throw new InternalError("unknown indirecting policy: " + policy);
        }
        catch (NotSerializableException e3) {
            throw e3;
        }
        catch (Exception e4) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while serializing an Object to a byte[] with an Indirector.", e4);
            }
            throw new NotSerializableException(e4.toString());
        }
    }

    public static byte[] serializeToByteArray(Object obj) throws NotSerializableException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(obj);
            return baos.toByteArray();
        }
        catch (NotSerializableException e2) {
            e2.fillInStackTrace();
            throw e2;
        }
        catch (IOException e3) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "An IOException occurred while writing into a ByteArrayOutputStream?!?", e3);
            }
            throw new Error("IOException writing to a byte array!");
        }
    }

    public static Object fromByteArray(byte[] bytes) throws IOException, ClassNotFoundException {
        Object out = SerializableUtils.deserializeFromByteArray(bytes);
        if (out instanceof IndirectlySerialized) {
            return ((IndirectlySerialized)out).getObject();
        }
        return out;
    }

    public static Object fromByteArray(byte[] bytes, boolean ignore_indirects) throws IOException, ClassNotFoundException {
        if (ignore_indirects) {
            return SerializableUtils.deserializeFromByteArray(bytes);
        }
        return SerializableUtils.fromByteArray(bytes);
    }

    public static Object deserializeFromByteArray(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        return in.readObject();
    }

    public static Object testSerializeDeserialize(Object o) throws IOException, ClassNotFoundException {
        return SerializableUtils.deepCopy(o);
    }

    public static Object deepCopy(Object o) throws IOException, ClassNotFoundException {
        byte[] bytes = SerializableUtils.serializeToByteArray(o);
        return SerializableUtils.deserializeFromByteArray(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object unmarshallObjectFromFile(File file) throws IOException, ClassNotFoundException {
        Object object;
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            object = in.readObject();
        }
        catch (Throwable throwable) {
            InputStreamUtils.attemptClose(in);
            throw throwable;
        }
        InputStreamUtils.attemptClose(in);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void marshallObjectToFile(Object o, File file) throws IOException {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            out.writeObject(o);
        }
        catch (Throwable throwable) {
            OutputStreamUtils.attemptClose(out);
            throw throwable;
        }
        OutputStreamUtils.attemptClose(out);
    }
}

