/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.function.Double9Function;
import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.function.DoubleProcedure;
import cern.colt.function.IntIntDoubleFunction;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix1DProcedure;
import cern.colt.matrix.doublealgo.Formatter;
import cern.colt.matrix.doublealgo.Sorting;
import cern.colt.matrix.impl.AbstractMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Property;
import cern.jet.math.Functions;

public abstract class DoubleMatrix2D
extends AbstractMatrix2D {
    protected DoubleMatrix2D() {
    }

    public double aggregate(DoubleDoubleFunction doubleDoubleFunction, DoubleFunction doubleFunction) {
        if (this.size() == 0) {
            return Double.NaN;
        }
        double d2 = doubleFunction.apply(this.getQuick(this.rows - 1, this.columns - 1));
        int n = 1;
        int n2 = this.rows;
        while (--n2 >= 0) {
            int n3 = this.columns - n;
            while (--n3 >= 0) {
                d2 = doubleDoubleFunction.apply(d2, doubleFunction.apply(this.getQuick(n2, n3)));
            }
            n = 0;
        }
        return d2;
    }

    public double aggregate(DoubleMatrix2D doubleMatrix2D, DoubleDoubleFunction doubleDoubleFunction, DoubleDoubleFunction doubleDoubleFunction2) {
        this.checkShape(doubleMatrix2D);
        if (this.size() == 0) {
            return Double.NaN;
        }
        double d2 = doubleDoubleFunction2.apply(this.getQuick(this.rows - 1, this.columns - 1), doubleMatrix2D.getQuick(this.rows - 1, this.columns - 1));
        int n = 1;
        int n2 = this.rows;
        while (--n2 >= 0) {
            int n3 = this.columns - n;
            while (--n3 >= 0) {
                d2 = doubleDoubleFunction.apply(d2, doubleDoubleFunction2.apply(this.getQuick(n2, n3), doubleMatrix2D.getQuick(n2, n3)));
            }
            n = 0;
        }
        return d2;
    }

    public DoubleMatrix2D assign(double[][] dArray) {
        if (dArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + dArray.length + "rows()=" + this.rows());
        }
        int n = this.rows;
        while (--n >= 0) {
            double[] dArray2 = dArray[n];
            if (dArray2.length != this.columns) {
                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray2.length + "columns()=" + this.columns());
            }
            int n2 = this.columns;
            while (--n2 >= 0) {
                this.setQuick(n, n2, dArray2[n2]);
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(double d2) {
        int n = this.rows;
        int n2 = this.columns;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                this.setQuick(n3, n4, d2);
                ++n4;
            }
            ++n3;
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleFunction doubleFunction) {
        int n = this.rows;
        while (--n >= 0) {
            int n2 = this.columns;
            while (--n2 >= 0) {
                this.setQuick(n, n2, doubleFunction.apply(this.getQuick(n, n2)));
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D == this) {
            return this;
        }
        this.checkShape(doubleMatrix2D);
        if (this.haveSharedCells(doubleMatrix2D)) {
            doubleMatrix2D = doubleMatrix2D.copy();
        }
        int n = this.rows;
        while (--n >= 0) {
            int n2 = this.columns;
            while (--n2 >= 0) {
                this.setQuick(n, n2, doubleMatrix2D.getQuick(n, n2));
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D, DoubleDoubleFunction doubleDoubleFunction) {
        this.checkShape(doubleMatrix2D);
        int n = this.rows;
        while (--n >= 0) {
            int n2 = this.columns;
            while (--n2 >= 0) {
                this.setQuick(n, n2, doubleDoubleFunction.apply(this.getQuick(n, n2), doubleMatrix2D.getQuick(n, n2)));
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = this.rows;
        while (--n2 >= 0) {
            int n3 = this.columns;
            while (--n3 >= 0) {
                if (this.getQuick(n2, n3) == 0.0) continue;
                ++n;
            }
        }
        return n;
    }

    public DoubleMatrix2D copy() {
        return this.like().assign(this);
    }

    public boolean equals(double d2) {
        return Property.DEFAULT.equals(this, d2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DoubleMatrix2D)) {
            return false;
        }
        return Property.DEFAULT.equals(this, (DoubleMatrix2D)object);
    }

    public DoubleMatrix2D forEachNonZero(IntIntDoubleFunction intIntDoubleFunction) {
        int n = this.rows;
        while (--n >= 0) {
            int n2 = this.columns;
            while (--n2 >= 0) {
                double d2;
                double d3 = this.getQuick(n, n2);
                if (d3 == 0.0 || (d2 = intIntDoubleFunction.apply(n, n2, d3)) == d3) continue;
                this.setQuick(n, n2, d2);
            }
        }
        return this;
    }

    public double get(int n, int n2) {
        if (n2 < 0 || n2 >= this.columns || n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + n + ", column:" + n2);
        }
        return this.getQuick(n, n2);
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, DoubleArrayList doubleArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        doubleArrayList.clear();
        int n = this.rows;
        int n2 = this.columns;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                double d2 = this.getQuick(n3, n4);
                if (d2 != 0.0) {
                    intArrayList.add(n3);
                    intArrayList2.add(n4);
                    doubleArrayList.add(d2);
                }
                ++n4;
            }
            ++n3;
        }
    }

    public abstract double getQuick(int var1, int var2);

    protected boolean haveSharedCells(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D == null) {
            return false;
        }
        if (this == doubleMatrix2D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(doubleMatrix2D.getContent());
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix2D doubleMatrix2D) {
        return false;
    }

    public DoubleMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract DoubleMatrix2D like(int var1, int var2);

    public abstract DoubleMatrix1D like1D(int var1);

    protected abstract DoubleMatrix1D like1D(int var1, int var2, int var3);

    public void set(int n, int n2, double d2) {
        if (n2 < 0 || n2 >= this.columns || n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + n + ", column:" + n2);
        }
        this.setQuick(n, n2, d2);
    }

    public abstract void setQuick(int var1, int var2, double var3);

    public double[][] toArray() {
        double[][] dArray = new double[this.rows][this.columns];
        int n = this.rows;
        while (--n >= 0) {
            double[] dArray2 = dArray[n];
            int n2 = this.columns;
            while (--n2 >= 0) {
                dArray2[n2] = this.getQuick(n, n2);
            }
        }
        return dArray;
    }

    public String toString() {
        return new Formatter().toString(this);
    }

    protected DoubleMatrix2D view() {
        return (DoubleMatrix2D)this.clone();
    }

    public DoubleMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = this.index(0, n);
        int n4 = this.rowStride;
        return this.like1D(n2, n3, n4);
    }

    public DoubleMatrix2D viewColumnFlip() {
        return (DoubleMatrix2D)this.view().vColumnFlip();
    }

    public DoubleMatrix2D viewDice() {
        return (DoubleMatrix2D)this.view().vDice();
    }

    public DoubleMatrix2D viewPart(int n, int n2, int n3, int n4) {
        return (DoubleMatrix2D)this.view().vPart(n, n2, n3, n4);
    }

    public DoubleMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = this.index(n, 0);
        int n4 = this.columnStride;
        return this.like1D(n2, n3, n4);
    }

    public DoubleMatrix2D viewRowFlip() {
        return (DoubleMatrix2D)this.view().vRowFlip();
    }

    public DoubleMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null) {
            nArray = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray2.length];
        int n2 = nArray.length;
        while (--n2 >= 0) {
            nArray3[n2] = this._rowOffset(this._rowRank(nArray[n2]));
        }
        int n3 = nArray2.length;
        while (--n3 >= 0) {
            nArray4[n3] = this._columnOffset(this._columnRank(nArray2[n3]));
        }
        return this.viewSelectionLike(nArray3, nArray4);
    }

    public DoubleMatrix2D viewSelection(DoubleMatrix1DProcedure doubleMatrix1DProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        int n = 0;
        while (n < this.rows) {
            if (doubleMatrix1DProcedure.apply(this.viewRow(n))) {
                intArrayList.add(n);
            }
            ++n;
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements(), null);
    }

    protected abstract DoubleMatrix2D viewSelectionLike(int[] var1, int[] var2);

    public DoubleMatrix2D viewSorted(int n) {
        return Sorting.mergeSort.sort(this, n);
    }

    public DoubleMatrix2D viewStrides(int n, int n2) {
        return (DoubleMatrix2D)this.view().vStrides(n, n2);
    }

    private boolean xforEach(DoubleProcedure doubleProcedure) {
        int n = this.rows;
        while (--n >= 0) {
            int n2 = this.columns;
            while (--n2 >= 0) {
                if (doubleProcedure.apply(this.getQuick(n, n2))) continue;
                return false;
            }
        }
        return true;
    }

    public void zAssign8Neighbors(DoubleMatrix2D doubleMatrix2D, Double9Function double9Function) {
        if (double9Function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(doubleMatrix2D);
        if (this.rows < 3 || this.columns < 3) {
            return;
        }
        int n = this.rows - 1;
        int n2 = this.columns - 1;
        int n3 = 1;
        while (n3 < n) {
            double d2 = this.getQuick(n3 - 1, 0);
            double d3 = this.getQuick(n3 - 1, 1);
            double d4 = this.getQuick(n3, 0);
            double d5 = this.getQuick(n3, 1);
            double d6 = this.getQuick(n3 + 1, 0);
            double d7 = this.getQuick(n3 + 1, 1);
            int n4 = 1;
            while (n4 < n2) {
                double d8 = this.getQuick(n3 - 1, n4 + 1);
                double d9 = this.getQuick(n3, n4 + 1);
                double d10 = this.getQuick(n3 + 1, n4 + 1);
                doubleMatrix2D.setQuick(n3, n4, double9Function.apply(d2, d3, d8, d4, d5, d9, d6, d7, d10));
                d2 = d3;
                d4 = d5;
                d6 = d7;
                d3 = d8;
                d5 = d9;
                d7 = d10;
                ++n4;
            }
            ++n3;
        }
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        return this.zMult(doubleMatrix1D, doubleMatrix1D2, 1.0, doubleMatrix1D2 == null ? 1.0 : 0.0, false);
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, double d2, double d3, boolean bl) {
        if (bl) {
            return this.viewDice().zMult(doubleMatrix1D, doubleMatrix1D2, d2, d3, false);
        }
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = new DenseDoubleMatrix1D(this.rows);
        }
        if (this.columns != doubleMatrix1D.size() || this.rows > doubleMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + doubleMatrix1D.toStringShort() + ", " + doubleMatrix1D2.toStringShort());
        }
        int n = this.rows;
        while (--n >= 0) {
            double d4 = 0.0;
            int n2 = this.columns;
            while (--n2 >= 0) {
                d4 += this.getQuick(n, n2) * doubleMatrix1D.getQuick(n2);
            }
            doubleMatrix1D2.setQuick(n, d2 * d4 + d3 * doubleMatrix1D2.getQuick(n));
        }
        return doubleMatrix1D2;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        return this.zMult(doubleMatrix2D, doubleMatrix2D2, 1.0, doubleMatrix2D2 == null ? 1.0 : 0.0, false, false);
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, double d2, double d3, boolean bl, boolean bl2) {
        if (bl) {
            return this.viewDice().zMult(doubleMatrix2D, doubleMatrix2D2, d2, d3, false, bl2);
        }
        if (bl2) {
            return this.zMult(doubleMatrix2D.viewDice(), doubleMatrix2D2, d2, d3, bl, false);
        }
        int n = this.rows;
        int n2 = this.columns;
        int n3 = doubleMatrix2D.columns;
        if (doubleMatrix2D2 == null) {
            doubleMatrix2D2 = new DenseDoubleMatrix2D(n, n3);
        }
        if (doubleMatrix2D.rows != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + doubleMatrix2D.toStringShort());
        }
        if (doubleMatrix2D2.rows != n || doubleMatrix2D2.columns != n3) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + doubleMatrix2D.toStringShort() + ", " + doubleMatrix2D2.toStringShort());
        }
        if (this == doubleMatrix2D2 || doubleMatrix2D == doubleMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        int n4 = n3;
        while (--n4 >= 0) {
            int n5 = n;
            while (--n5 >= 0) {
                double d4 = 0.0;
                int n6 = n2;
                while (--n6 >= 0) {
                    d4 += this.getQuick(n5, n6) * doubleMatrix2D.getQuick(n6, n4);
                }
                doubleMatrix2D2.setQuick(n5, n4, d2 * d4 + d3 * doubleMatrix2D2.getQuick(n5, n4));
            }
        }
        return doubleMatrix2D2;
    }

    public double zSum() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.aggregate(Functions.plus, Functions.identity);
    }
}

