﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connect/model/CustomerQualityMetrics.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Connect {
namespace Model {

CustomerQualityMetrics::CustomerQualityMetrics(JsonView jsonValue) { *this = jsonValue; }

CustomerQualityMetrics& CustomerQualityMetrics::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Audio")) {
    m_audio = jsonValue.GetObject("Audio");
    m_audioHasBeenSet = true;
  }
  return *this;
}

JsonValue CustomerQualityMetrics::Jsonize() const {
  JsonValue payload;

  if (m_audioHasBeenSet) {
    payload.WithObject("Audio", m_audio.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
