﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codecommit/model/SetFileModeEntry.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CodeCommit {
namespace Model {

SetFileModeEntry::SetFileModeEntry(JsonView jsonValue) { *this = jsonValue; }

SetFileModeEntry& SetFileModeEntry::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("filePath")) {
    m_filePath = jsonValue.GetString("filePath");
    m_filePathHasBeenSet = true;
  }
  if (jsonValue.ValueExists("fileMode")) {
    m_fileMode = FileModeTypeEnumMapper::GetFileModeTypeEnumForName(jsonValue.GetString("fileMode"));
    m_fileModeHasBeenSet = true;
  }
  return *this;
}

JsonValue SetFileModeEntry::Jsonize() const {
  JsonValue payload;

  if (m_filePathHasBeenSet) {
    payload.WithString("filePath", m_filePath);
  }

  if (m_fileModeHasBeenSet) {
    payload.WithString("fileMode", FileModeTypeEnumMapper::GetNameForFileModeTypeEnum(m_fileMode));
  }

  return payload;
}

}  // namespace Model
}  // namespace CodeCommit
}  // namespace Aws
