﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codebuild/CodeBuild_EXPORTS.h>
#include <aws/codebuild/model/LogsConfigStatusType.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CodeBuild {
namespace Model {

/**
 * <p> Information about CloudWatch Logs for a build project. </p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CloudWatchLogsConfig">AWS
 * API Reference</a></p>
 */
class CloudWatchLogsConfig {
 public:
  AWS_CODEBUILD_API CloudWatchLogsConfig() = default;
  AWS_CODEBUILD_API CloudWatchLogsConfig(Aws::Utils::Json::JsonView jsonValue);
  AWS_CODEBUILD_API CloudWatchLogsConfig& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CODEBUILD_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The current status of the logs in CloudWatch Logs for a build project. Valid
   * values are:</p> <ul> <li> <p> <code>ENABLED</code>: CloudWatch Logs are enabled
   * for this build project.</p> </li> <li> <p> <code>DISABLED</code>: CloudWatch
   * Logs are not enabled for this build project.</p> </li> </ul>
   */
  inline LogsConfigStatusType GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(LogsConfigStatusType value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline CloudWatchLogsConfig& WithStatus(LogsConfigStatusType value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The group name of the logs in CloudWatch Logs. For more information, see <a
   * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working
   * with Log Groups and Log Streams</a>. </p>
   */
  inline const Aws::String& GetGroupName() const { return m_groupName; }
  inline bool GroupNameHasBeenSet() const { return m_groupNameHasBeenSet; }
  template <typename GroupNameT = Aws::String>
  void SetGroupName(GroupNameT&& value) {
    m_groupNameHasBeenSet = true;
    m_groupName = std::forward<GroupNameT>(value);
  }
  template <typename GroupNameT = Aws::String>
  CloudWatchLogsConfig& WithGroupName(GroupNameT&& value) {
    SetGroupName(std::forward<GroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The prefix of the stream name of the CloudWatch Logs. For more information,
   * see <a
   * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working
   * with Log Groups and Log Streams</a>. </p>
   */
  inline const Aws::String& GetStreamName() const { return m_streamName; }
  inline bool StreamNameHasBeenSet() const { return m_streamNameHasBeenSet; }
  template <typename StreamNameT = Aws::String>
  void SetStreamName(StreamNameT&& value) {
    m_streamNameHasBeenSet = true;
    m_streamName = std::forward<StreamNameT>(value);
  }
  template <typename StreamNameT = Aws::String>
  CloudWatchLogsConfig& WithStreamName(StreamNameT&& value) {
    SetStreamName(std::forward<StreamNameT>(value));
    return *this;
  }
  ///@}
 private:
  LogsConfigStatusType m_status{LogsConfigStatusType::NOT_SET};
  bool m_statusHasBeenSet = false;

  Aws::String m_groupName;
  bool m_groupNameHasBeenSet = false;

  Aws::String m_streamName;
  bool m_streamNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeBuild
}  // namespace Aws
