﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cloudfront/model/ImportSourceType.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace CloudFront {
namespace Model {
namespace ImportSourceTypeMapper {

static const int S3_HASH = HashingUtils::HashString("S3");

ImportSourceType GetImportSourceTypeForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == S3_HASH) {
    return ImportSourceType::S3;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<ImportSourceType>(hashCode);
  }

  return ImportSourceType::NOT_SET;
}

Aws::String GetNameForImportSourceType(ImportSourceType enumValue) {
  switch (enumValue) {
    case ImportSourceType::NOT_SET:
      return {};
    case ImportSourceType::S3:
      return "S3";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace ImportSourceTypeMapper
}  // namespace Model
}  // namespace CloudFront
}  // namespace Aws
