﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cleanrooms/CleanRoomsRequest.h>
#include <aws/cleanrooms/CleanRooms_EXPORTS.h>
#include <aws/cleanrooms/model/PrivacyBudgetType.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace CleanRooms {
namespace Model {

/**
 */
class ListPrivacyBudgetsRequest : public CleanRoomsRequest {
 public:
  AWS_CLEANROOMS_API ListPrivacyBudgetsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ListPrivacyBudgets"; }

  AWS_CLEANROOMS_API Aws::String SerializePayload() const override;

  AWS_CLEANROOMS_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>A unique identifier for one of your memberships for a collaboration. The
   * privacy budget is retrieved from the collaboration that this membership belongs
   * to. Accepts a membership ID.</p>
   */
  inline const Aws::String& GetMembershipIdentifier() const { return m_membershipIdentifier; }
  inline bool MembershipIdentifierHasBeenSet() const { return m_membershipIdentifierHasBeenSet; }
  template <typename MembershipIdentifierT = Aws::String>
  void SetMembershipIdentifier(MembershipIdentifierT&& value) {
    m_membershipIdentifierHasBeenSet = true;
    m_membershipIdentifier = std::forward<MembershipIdentifierT>(value);
  }
  template <typename MembershipIdentifierT = Aws::String>
  ListPrivacyBudgetsRequest& WithMembershipIdentifier(MembershipIdentifierT&& value) {
    SetMembershipIdentifier(std::forward<MembershipIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The privacy budget type.</p>
   */
  inline PrivacyBudgetType GetPrivacyBudgetType() const { return m_privacyBudgetType; }
  inline bool PrivacyBudgetTypeHasBeenSet() const { return m_privacyBudgetTypeHasBeenSet; }
  inline void SetPrivacyBudgetType(PrivacyBudgetType value) {
    m_privacyBudgetTypeHasBeenSet = true;
    m_privacyBudgetType = value;
  }
  inline ListPrivacyBudgetsRequest& WithPrivacyBudgetType(PrivacyBudgetType value) {
    SetPrivacyBudgetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The pagination token that's used to fetch the next set of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListPrivacyBudgetsRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of results that are returned for an API request call. The
   * service chooses a default number if you don't set one. The service might return
   * a `nextToken` even if the `maxResults` value has not been met.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline ListPrivacyBudgetsRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the access budget resource to filter
   * privacy budgets by.</p>
   */
  inline const Aws::String& GetAccessBudgetResourceArn() const { return m_accessBudgetResourceArn; }
  inline bool AccessBudgetResourceArnHasBeenSet() const { return m_accessBudgetResourceArnHasBeenSet; }
  template <typename AccessBudgetResourceArnT = Aws::String>
  void SetAccessBudgetResourceArn(AccessBudgetResourceArnT&& value) {
    m_accessBudgetResourceArnHasBeenSet = true;
    m_accessBudgetResourceArn = std::forward<AccessBudgetResourceArnT>(value);
  }
  template <typename AccessBudgetResourceArnT = Aws::String>
  ListPrivacyBudgetsRequest& WithAccessBudgetResourceArn(AccessBudgetResourceArnT&& value) {
    SetAccessBudgetResourceArn(std::forward<AccessBudgetResourceArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_membershipIdentifier;
  bool m_membershipIdentifierHasBeenSet = false;

  PrivacyBudgetType m_privacyBudgetType{PrivacyBudgetType::NOT_SET};
  bool m_privacyBudgetTypeHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  int m_maxResults{0};
  bool m_maxResultsHasBeenSet = false;

  Aws::String m_accessBudgetResourceArn;
  bool m_accessBudgetResourceArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace CleanRooms
}  // namespace Aws
