#include <fcntl.h>
#include <termios.h>
#include <unistd.h>
		
#include <stdio.h>
#include <stdlib.h>

#include <ctapi.h>

#define OK			0

static struct termios sav;

void restore_tty()
{
	tcsetattr(0, TCSADRAIN, &sav);
}

void init_tty()
{
   	struct termios t;

   	tcgetattr(STDIN_FILENO, &t);
   	sav = t;
   	t.c_lflag &= ~(ICANON);
   	t.c_cc[VMIN] = 1;
   	t.c_cc[VTIME] = 0;
	tcsetattr(STDIN_FILENO, TCSADRAIN, &t);
}

int getch(void)
{
	char c = 0;
	
	fflush(STDIN_FILENO);
	if (read(STDIN_FILENO, &c, 1) == 1)
		return c;
	
	return c;
}


int	main( int ArgC, char **ArgV )
{
	int		RC;
	int		i;
	char	Key;

	// APUDs
	unsigned char	GetStatusIFC[]  = { 0x20, 0x13, 0x00, 0x46, 0x00 };
	unsigned char	GetStatusICC[]	= { 0x20, 0x13, 0x00, 0x80, 0x00 };
	unsigned char	ResetCT[]		= { 0x20, 0x10, 0x01, 0x01, 0x00 };
	unsigned char	EjectICC[]		= { 0x20, 0x15, 0x01, 0x00, 0x00 };

	// parameter for CT_data
	unsigned char	Dad;
	unsigned char	Sad;
    unsigned short	Lc;
    unsigned char*	Cmd;
    unsigned short	Lr;
    unsigned char	Rsp[256];
	
	// Port for CT_init
	unsigned short	Port = 1;
	
//	init_tty();
	
	printf("\n\n\n        CT-API Sample - (c) SCM MICROSYSTEMS\n\n");
	printf("CT_init\t\t:");
	
	// initializing the library
	RC = CT_init(0, Port);
	
	if (RC != OK)
	{
		printf(" failed !\n");
		exit(1);
	}
	printf(" succesful, use /dev/ttyS%d\n", Port);
	
	// get firmware and library version
	Dad = 1;
	Sad = 2;
	Lc	= sizeof(GetStatusIFC);
	Cmd = GetStatusIFC;
	Lr	= sizeof(Rsp);

	RC = CT_data(0, &Dad, &Sad, Lc, Cmd, &Lr, Rsp);
	if (RC != OK)
	{
		printf("CT_data failed !\n");
		exit(1);
	}

	if (15 <  Lr && Rsp[Lr - 2]  == 0x90)
	{
		printf("\nRSR3 Firmware\t: %d.%d\n", Rsp[0x0A], Rsp[0x0B]);
		printf("\nLibrary Version\t: %c %d.%d\n", Rsp[0x0C], Rsp[0x0D], Rsp[0x0E]);	 
	}		
	
	// test card status
	Lc	= sizeof(GetStatusICC);
	Cmd = GetStatusICC;
	
	printf("\nCheck ICC\t: ");
	
	do
	{
		Dad = 1;
		Sad = 2;
		Lr	= sizeof(Rsp);
	
		RC = CT_data(0, &Dad, &Sad, Lc, Cmd, &Lr, Rsp);
		if (RC != OK)
		{
			printf("CT_data failed !\n");
			exit(1);
		}

		if (2 <= Lr && Rsp[Lr-2] == 0x90)
		{
			if (Rsp[0] == 0x00) 
			{
				printf("\nplease insert ICC and press any key !\n"); 
			}
			else 
			{
				printf("ICC inserted !\n"); 
				break;	
			}
		}
		else
		{
			printf("GETSTATUS failed, SW1 = %02X, SW2 = %02X\n", Rsp[0], Rsp[1]); 
		}

		Key = getch();
	}
	while (Key != 27);
	
	// reset ICC and show ATR
	Dad = 1;
	Sad = 2;
	Lc	= sizeof(ResetCT);
	Cmd = ResetCT;
	Lr	= sizeof(Rsp);
	
	RC = CT_data(0, &Dad, &Sad, Lc, Cmd, &Lr, Rsp);
	if (RC != OK)
	{
		printf("CT_data failed !\n");
		exit(1);
	}
	
	printf("\n\nRESET CT (ATR)\t: ");
	if (2 <= Lr && Rsp[Lr-2] == 0x90)
	{
		for (i = 0; i < Lr-2; i++ )
		{
			if (i && !(i & 0x0F )) printf("\n\t\t  ");
			printf( "%02X ", Rsp[i] );
		}
	}
	else
	{
		printf(" failed, SW1 = %02X, SW2 = %02X\n", Rsp[0], Rsp[1]); 
	}

	// eject ICC
	Dad = 1;
	Sad = 2;
	Lc	= sizeof(EjectICC);
	Cmd = EjectICC;
	Lr	= sizeof(Rsp);
	
	printf("\n\nEJECT CT\t: ");
	RC = CT_data(0, &Dad, &Sad, Lc, Cmd, &Lr, Rsp);
	if (RC != OK)
	{
		printf("CT_data failed !\n");
		exit(1);
	}
	
	if (2 <= Lr && Rsp[Lr - 2]  == 0x90)
	{
		printf("ICC disconnected !\n");
	}
	else
	{
		printf(" failed, SW1 = %02X, SW2 = %02X\n", Rsp[0], Rsp[1]); 
	}
	
	printf("\nCT_close\t: ");
	RC = CT_close(0);
	if (RC != OK)
	{
		printf("failed !\n\n");
	}
	else
	{
		printf("succesful !\n\n\n");
	}

	restore_tty();
		
	return 1;
}
