/*

Copyright 2006 Suzanne Skinner, John Spray

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/



#include "util.h"

uint16 lr_lookup[0x10000] = {
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0, 32768, 16384, 49152,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0, 32768,
    16384, 49152,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0, 32768, 16384, 49152,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0, 32768, 16384, 49152,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0, 32768, 16384, 49152,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0, 32768, 16384, 49152,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0, 32768,
    16384, 49152,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0, 32768, 16384, 49152,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0, 32768, 16384, 49152,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0, 32768, 16384, 49152,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0, 32768, 16384, 49152,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0, 32768,
    16384, 49152,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0, 32768, 16384, 49152,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048, 34816, 18432, 51200,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024, 33792, 17408, 50176,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072, 35840, 19456, 52224,     0,     0,     0,     0,
        0, 32768,     0, 32768,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384,     0,     0,     0,     0,     0, 32768,     0, 32768,
        0, 32768,     0, 32768, 32768,     0, 49152, 16384,     0,     0,
        0,     0,     0, 32768,     0, 32768,     0, 32768,     0, 32768,
    32768,     0, 49152, 16384,     0,     0,     0,     0,     0, 32768,
        0, 32768,     0, 32768,     0, 32768, 32768,     0, 49152, 16384,
        0,     0,     0,     0,     0, 32768,     0, 32768,     0, 32768,
        0, 32768, 32768,     0, 49152, 16384,  2048,  2048,  2048,  2048,
     2048, 34816,  2048, 34816,  2048, 34816,  2048, 34816, 34816,  2048,
    51200, 18432,     0,     0,     0,     0,     0, 32768,     0, 32768,
        0, 32768,     0, 32768, 32768,     0, 49152, 16384,  2048,  2048,
     2048,  2048,  2048, 34816,  2048, 34816,  2048, 34816,  2048, 34816,
    34816,  2048, 51200, 18432,     0,     0,     0,     0,     0, 32768,
        0, 32768,     0, 32768,     0, 32768, 32768,     0, 49152, 16384,
     2048,  2048,  2048,  2048,  2048, 34816,  2048, 34816,  2048, 34816,
     2048, 34816, 34816,  2048, 51200, 18432,     0,     0,     0,     0,
        0, 32768,     0, 32768,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384,  2048,  2048,  2048,  2048,  2048, 34816,  2048, 34816,
     2048, 34816,  2048, 34816, 34816,  2048, 51200, 18432,  2048,  2048,
     2048,  2048,  2048, 34816,  2048, 34816,  2048, 34816,  2048, 34816,
    34816,  2048, 51200, 18432,     0,     0,     0,     0,     0, 32768,
        0, 32768,     0, 32768,     0, 32768, 32768,     0, 49152, 16384,
     3072,  3072,  3072,  3072,  3072, 35840,  3072, 35840,  3072, 35840,
     3072, 35840, 35840,  3072, 52224, 19456,  1024,  1024,  1024,  1024,
     1024, 33792,  1024, 33792,  1024, 33792,  1024, 33792, 33792,  1024,
    50176, 17408,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0, 16384, 16384,
    16384, 49152,     0, 32768,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0, 16384, 16384, 16384, 49152,     0, 32768,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
    16384, 16384, 16384, 49152,     0, 32768,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0, 16384, 16384, 16384, 49152,
        0, 32768,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768,  1024,  1024,
     1024,  1024,  1024,  1024, 17408, 17408,  1024,  1024, 17408, 17408,
    17408, 50176,  1024, 33792,  1024,  1024,  1024,  1024,  1024,  1024,
    17408, 17408,  1024,  1024, 17408, 17408, 17408, 50176,  1024, 33792,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
    16384, 16384, 16384, 49152,     0, 32768,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0, 16384, 16384, 16384, 49152,
        0, 32768,  1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,
     1024,  1024, 17408, 17408, 17408, 50176,  1024, 33792,  1024,  1024,
     1024,  1024,  1024,  1024, 17408, 17408,  1024,  1024, 17408, 17408,
    17408, 50176,  1024, 33792,  1024,  1024,  1024,  1024,  1024,  1024,
    17408, 17408,  1024,  1024, 17408, 17408, 17408, 50176,  1024, 33792,
     3072,  3072,  3072,  3072,  3072,  3072, 19456, 19456,  3072,  3072,
    19456, 19456, 19456, 52224,  3072, 35840,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0, 16384, 16384, 16384, 49152,
        0, 32768,  2048,  2048,  2048,  2048,  2048,  2048, 18432, 18432,
     2048,  2048, 18432, 18432, 18432, 51200,  2048, 34816,     0,     0,
        0,     0,     0, 32768, 16384, 49152,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0, 32768,
    16384, 49152,     0, 32768, 16384, 49152, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0, 32768, 16384, 49152,     0, 32768,
    16384, 49152, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0, 32768, 16384, 49152,     0, 32768, 16384, 49152, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0, 32768, 16384, 49152,
        0, 32768, 16384, 49152, 49152, 16384, 32768,     0,  2048,  2048,
     2048,  2048,  2048, 34816, 18432, 51200,  2048, 34816, 18432, 51200,
    51200, 18432, 34816,  2048,  1024,  1024,  1024,  1024,  1024, 33792,
    17408, 50176,  1024, 33792, 17408, 50176, 50176, 17408, 33792,  1024,
     3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,  3072, 35840,
    19456, 52224, 52224, 19456, 35840,  3072,     0,     0,     0,     0,
        0, 32768, 16384, 49152,     0, 32768, 16384, 49152, 49152, 16384,
    32768,     0,  2048,  2048,  2048,  2048,  2048, 34816, 18432, 51200,
     2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,  1024,  1024,
     1024,  1024,  1024, 33792, 17408, 50176,  1024, 33792, 17408, 50176,
    50176, 17408, 33792,  1024,  3072,  3072,  3072,  3072,  3072, 35840,
    19456, 52224,  3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,  3072, 35840,
    19456, 52224, 52224, 19456, 35840,  3072,  1024,  1024,  1024,  1024,
     1024, 33792, 17408, 50176,  1024, 33792, 17408, 50176, 50176, 17408,
    33792,  1024,  2048,  2048,  2048,  2048,  2048, 34816, 18432, 51200,
     2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,     0,     0,
        0,     0,     0, 32768, 16384, 49152,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0, 32768,
    16384, 49152,     0, 32768, 16384, 49152, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0, 32768, 16384, 49152,     0, 32768,
    16384, 49152, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0, 32768, 16384, 49152,     0, 32768, 16384, 49152, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0, 32768, 16384, 49152,
        0, 32768, 16384, 49152, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0, 32768, 16384, 49152,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0,  2048,  2048,  2048,  2048,  2048, 34816,
    18432, 51200,  2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,
     1024,  1024,  1024,  1024,  1024, 33792, 17408, 50176,  1024, 33792,
    17408, 50176, 50176, 17408, 33792,  1024,  3072,  3072,  3072,  3072,
     3072, 35840, 19456, 52224,  3072, 35840, 19456, 52224, 52224, 19456,
    35840,  3072,     0,     0,     0,     0,     0, 32768, 16384, 49152,
        0, 32768, 16384, 49152, 49152, 16384, 32768,     0,  2048,  2048,
     2048,  2048,  2048, 34816, 18432, 51200,  2048, 34816, 18432, 51200,
    51200, 18432, 34816,  2048,  1024,  1024,  1024,  1024,  1024, 33792,
    17408, 50176,  1024, 33792, 17408, 50176, 50176, 17408, 33792,  1024,
     3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,  3072, 35840,
    19456, 52224, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     3072, 35840, 19456, 52224,  3072, 35840, 19456, 52224, 52224, 19456,
    35840,  3072,  1024,  1024,  1024,  1024,  1024, 33792, 17408, 50176,
     1024, 33792, 17408, 50176, 50176, 17408, 33792,  1024,  3072,  3072,
     3072,  3072,  3072, 35840, 19456, 52224,  3072, 35840, 19456, 52224,
    52224, 19456, 35840,  3072,  1024,  1024,  1024,  1024,  1024, 33792,
    17408, 50176,  1024, 33792, 17408, 50176, 50176, 17408, 33792,  1024,
        0, 32768,     0, 32768, 32768,     0, 49152, 16384, 32768,     0,
    49152, 16384, 16384, 16384,     0,     0,  2048, 34816,  2048, 34816,
    34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432, 18432, 18432,
     2048,  2048,     0, 32768,     0, 32768, 32768,     0, 49152, 16384,
    32768,     0, 49152, 16384, 16384, 16384,     0,     0,  2048, 34816,
     2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432,
    18432, 18432,  2048,  2048,  2048, 34816,  2048, 34816, 34816,  2048,
    51200, 18432, 34816,  2048, 51200, 18432, 18432, 18432,  2048,  2048,
        0, 32768,     0, 32768, 32768,     0, 49152, 16384, 32768,     0,
    49152, 16384, 16384, 16384,     0,     0,  3072, 35840,  3072, 35840,
    35840,  3072, 52224, 19456, 35840,  3072, 52224, 19456, 19456, 19456,
     3072,  3072,  1024, 33792,  1024, 33792, 33792,  1024, 50176, 17408,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,  2048, 34816,
     2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432,
    18432, 18432,  2048,  2048,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
     3072, 35840,  3072, 35840, 35840,  3072, 52224, 19456, 35840,  3072,
    52224, 19456, 19456, 19456,  3072,  3072,  1024, 33792,  1024, 33792,
    33792,  1024, 50176, 17408, 33792,  1024, 50176, 17408, 17408, 17408,
     1024,  1024,  1024, 33792,  1024, 33792, 33792,  1024, 50176, 17408,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,  1024, 33792,
     1024, 33792, 33792,  1024, 50176, 17408, 33792,  1024, 50176, 17408,
    17408, 17408,  1024,  1024,  1024, 33792,  1024, 33792, 33792,  1024,
    50176, 17408, 33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,
     1024, 33792,  1024, 33792, 33792,  1024, 50176, 17408, 33792,  1024,
    50176, 17408, 17408, 17408,  1024,  1024,     0,     0, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0,     0,     0, 16384, 16384, 16384, 49152,     0, 32768,
    16384, 49152,     0, 32768, 32768,     0, 32768,     0,  1024,  1024,
    17408, 17408, 17408, 50176,  1024, 33792, 17408, 50176,  1024, 33792,
    33792,  1024, 33792,  1024,  1024,  1024, 17408, 17408, 17408, 50176,
     1024, 33792, 17408, 50176,  1024, 33792, 33792,  1024, 33792,  1024,
     1024,  1024, 17408, 17408, 17408, 50176,  1024, 33792, 17408, 50176,
     1024, 33792, 33792,  1024, 33792,  1024,  3072,  3072, 19456, 19456,
    19456, 52224,  3072, 35840, 19456, 52224,  3072, 35840, 35840,  3072,
    35840,  3072,  1024,  1024, 17408, 17408, 17408, 50176,  1024, 33792,
    17408, 50176,  1024, 33792, 33792,  1024, 33792,  1024,  3072,  3072,
    19456, 19456, 19456, 52224,  3072, 35840, 19456, 52224,  3072, 35840,
    35840,  3072, 35840,  3072,  1024,  1024, 17408, 17408, 17408, 50176,
     1024, 33792, 17408, 50176,  1024, 33792, 33792,  1024, 33792,  1024,
     3072,  3072, 19456, 19456, 19456, 52224,  3072, 35840, 19456, 52224,
     3072, 35840, 35840,  3072, 35840,  3072,  1024,  1024, 17408, 17408,
    17408, 50176,  1024, 33792, 17408, 50176,  1024, 33792, 33792,  1024,
    33792,  1024,  3072,  3072, 19456, 19456, 19456, 52224,  3072, 35840,
    19456, 52224,  3072, 35840, 35840,  3072, 35840,  3072,  3072,  3072,
    19456, 19456, 19456, 52224,  3072, 35840, 19456, 52224,  3072, 35840,
    35840,  3072, 35840,  3072,  1024,  1024, 17408, 17408, 17408, 50176,
     1024, 33792, 17408, 50176,  1024, 33792, 33792,  1024, 33792,  1024,
     2048,  2048, 18432, 18432, 18432, 51200,  2048, 34816, 18432, 51200,
     2048, 34816, 34816,  2048, 34816,  2048,     0,     0, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0,     0, 32768, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,  2048, 34816,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  1024, 33792, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,
    52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072,  1024, 33792, 17408, 50176, 50176, 17408, 33792,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  3072, 35840,
    19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072,  1024, 33792, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  1024, 33792, 17408, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072,
    52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,  1024, 33792,
    17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024,  1024, 33792, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
     1024, 33792, 17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0, 32768, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0, 32768, 16384, 49152,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0, 32768,
    16384, 49152,     0, 32768, 16384, 49152, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0, 32768, 16384, 49152,     0, 32768,
    16384, 49152, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0, 32768, 16384, 49152,     0, 32768, 16384, 49152, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0, 32768, 16384, 49152,
        0, 32768, 16384, 49152, 49152, 16384, 32768,     0,  2048,  2048,
     2048,  2048,  2048, 34816, 18432, 51200,  2048, 34816, 18432, 51200,
    51200, 18432, 34816,  2048,  1024,  1024,  1024,  1024,  1024, 33792,
    17408, 50176,  1024, 33792, 17408, 50176, 50176, 17408, 33792,  1024,
     3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,  3072, 35840,
    19456, 52224, 52224, 19456, 35840,  3072,     0,     0,     0,     0,
        0, 32768, 16384, 49152,     0, 32768, 16384, 49152, 49152, 16384,
    32768,     0,  2048,  2048,  2048,  2048,  2048, 34816, 18432, 51200,
     2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,  1024,  1024,
     1024,  1024,  1024, 33792, 17408, 50176,  1024, 33792, 17408, 50176,
    50176, 17408, 33792,  1024,  3072,  3072,  3072,  3072,  3072, 35840,
    19456, 52224,  3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,  3072, 35840,
    19456, 52224, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     3072, 35840, 19456, 52224,  3072, 35840, 19456, 52224, 52224, 19456,
    35840,  3072,  2048,  2048,  2048,  2048,  2048, 34816, 18432, 51200,
     2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048,  2048, 34816, 18432, 51200,  2048, 34816, 18432, 51200,
    51200, 18432, 34816,  2048,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
     2048, 34816,  2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048,
    51200, 18432, 18432, 18432,  2048,  2048,     0, 32768,     0, 32768,
    32768,     0, 49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,
        0,     0,  2048, 34816,  2048, 34816, 34816,  2048, 51200, 18432,
    34816,  2048, 51200, 18432, 18432, 18432,  2048,  2048,  2048, 34816,
     2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432,
    18432, 18432,  2048,  2048,  2048, 34816,  2048, 34816, 34816,  2048,
    51200, 18432, 34816,  2048, 51200, 18432, 18432, 18432,  2048,  2048,
     3072, 35840,  3072, 35840, 35840,  3072, 52224, 19456, 35840,  3072,
    52224, 19456, 19456, 19456,  3072,  3072,  3072, 35840,  3072, 35840,
    35840,  3072, 52224, 19456, 35840,  3072, 52224, 19456, 19456, 19456,
     3072,  3072,  2048, 34816,  2048, 34816, 34816,  2048, 51200, 18432,
    34816,  2048, 51200, 18432, 18432, 18432,  2048,  2048,  2048, 34816,
     2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432,
    18432, 18432,  2048,  2048,  3072, 35840,  3072, 35840, 35840,  3072,
    52224, 19456, 35840,  3072, 52224, 19456, 19456, 19456,  3072,  3072,
     3072, 35840,  3072, 35840, 35840,  3072, 52224, 19456, 35840,  3072,
    52224, 19456, 19456, 19456,  3072,  3072,  3072, 35840,  3072, 35840,
    35840,  3072, 52224, 19456, 35840,  3072, 52224, 19456, 19456, 19456,
     3072,  3072,  1024, 33792,  1024, 33792, 33792,  1024, 50176, 17408,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,  2048, 34816,
     2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432,
    18432, 18432,  2048,  2048,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,
        0, 32768, 32768,     0, 32768,     0,     0,     0, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0,  1024,  1024, 17408, 17408, 17408, 50176,  1024, 33792,
    17408, 50176,  1024, 33792, 33792,  1024, 33792,  1024,  1024,  1024,
    17408, 17408, 17408, 50176,  1024, 33792, 17408, 50176,  1024, 33792,
    33792,  1024, 33792,  1024,  1024,  1024, 17408, 17408, 17408, 50176,
     1024, 33792, 17408, 50176,  1024, 33792, 33792,  1024, 33792,  1024,
     3072,  3072, 19456, 19456, 19456, 52224,  3072, 35840, 19456, 52224,
     3072, 35840, 35840,  3072, 35840,  3072,     0,     0, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0,  2048,  2048, 18432, 18432, 18432, 51200,  2048, 34816,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,  1024,  1024,
    17408, 17408, 17408, 50176,  1024, 33792, 17408, 50176,  1024, 33792,
    33792,  1024, 33792,  1024,  3072,  3072, 19456, 19456, 19456, 52224,
     3072, 35840, 19456, 52224,  3072, 35840, 35840,  3072, 35840,  3072,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,
        0, 32768, 32768,     0, 32768,     0,  2048,  2048, 18432, 18432,
    18432, 51200,  2048, 34816, 18432, 51200,  2048, 34816, 34816,  2048,
    34816,  2048,  2048,  2048, 18432, 18432, 18432, 51200,  2048, 34816,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,  2048,  2048,
    18432, 18432, 18432, 51200,  2048, 34816, 18432, 51200,  2048, 34816,
    34816,  2048, 34816,  2048,  2048,  2048, 18432, 18432, 18432, 51200,
     2048, 34816, 18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,
     2048,  2048, 18432, 18432, 18432, 51200,  2048, 34816, 18432, 51200,
     2048, 34816, 34816,  2048, 34816,  2048,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,  2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  1024, 33792,
    17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024,  3072, 35840, 19456, 52224, 52224, 19456,
    35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,
    52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072,  2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048, 34816,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  3072, 35840, 19456, 52224, 52224, 19456,
    35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  2048, 34816, 18432, 51200,
    51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048,  2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048, 34816,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,     0, 32768, 16384, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
     2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0, 32768, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,  2048, 34816,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  1024, 33792, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,
    52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072,  3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072,
    52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,  3072, 35840,
    19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224, 52224, 19456,
    35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,
    52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072,  3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072,
    52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,  3072, 35840,
    19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224, 52224, 19456,
    35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     1024, 33792, 17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024,  2048, 34816, 18432, 51200,
    51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048,     0, 32768, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 34816,  2048,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 34816,  2048, 51200, 18432, 18432, 18432,
     2048,  2048, 18432, 18432,  2048,  2048,  2048,  2048,  2048,  2048,
    35840,  3072, 52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,
     3072,  3072,  3072,  3072,  3072,  3072, 35840,  3072, 52224, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 35840,  3072, 52224, 19456, 19456, 19456,  3072,  3072,
    19456, 19456,  3072,  3072,  3072,  3072,  3072,  3072, 33792,  1024,
    50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 35840,  3072, 52224, 19456, 19456, 19456,
     3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,  3072,  3072,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 35840,  3072, 52224, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 35840,  3072,
    52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,
     3072,  3072,  3072,  3072, 33792,  1024, 50176, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 33792,  1024, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 32768,     0,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 17408, 50176,  1024, 33792, 33792,  1024,
    33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,  1024,  1024,
    19456, 52224,  3072, 35840, 35840,  3072, 35840,  3072, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072, 17408, 50176,  1024, 33792,
    33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,
     1024,  1024, 19456, 52224,  3072, 35840, 35840,  3072, 35840,  3072,
    35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072, 19456, 52224,
     3072, 35840, 35840,  3072, 35840,  3072, 35840,  3072, 35840,  3072,
     3072,  3072,  3072,  3072, 19456, 52224,  3072, 35840, 35840,  3072,
    35840,  3072, 35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,  2048, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 19456, 52224,  3072, 35840, 35840,  3072, 35840,  3072,
    35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072, 19456, 52224,
     3072, 35840, 35840,  3072, 35840,  3072, 35840,  3072, 35840,  3072,
     3072,  3072,  3072,  3072, 18432, 51200,  2048, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,  2048, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 16384, 49152,     0, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 18432, 51200,
     2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0, 32768,     0, 32768,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384,     0,     0,     0,     0,     0, 32768,     0, 32768,
        0, 32768,     0, 32768, 32768,     0, 49152, 16384,     0,     0,
        0,     0,     0, 32768,     0, 32768,     0, 32768,     0, 32768,
    32768,     0, 49152, 16384,     0,     0,     0,     0,     0, 32768,
        0, 32768,     0, 32768,     0, 32768, 32768,     0, 49152, 16384,
        0,     0,     0,     0,     0, 32768,     0, 32768,     0, 32768,
        0, 32768, 32768,     0, 49152, 16384,  2048,  2048,  2048,  2048,
     2048, 34816,  2048, 34816,  2048, 34816,  2048, 34816, 34816,  2048,
    51200, 18432,     0,     0,     0,     0,     0, 32768,     0, 32768,
        0, 32768,     0, 32768, 32768,     0, 49152, 16384,  2048,  2048,
     2048,  2048,  2048, 34816,  2048, 34816,  2048, 34816,  2048, 34816,
    34816,  2048, 51200, 18432,     0,     0,     0,     0,     0, 32768,
        0, 32768,     0, 32768,     0, 32768, 32768,     0, 49152, 16384,
     2048,  2048,  2048,  2048,  2048, 34816,  2048, 34816,  2048, 34816,
     2048, 34816, 34816,  2048, 51200, 18432,     0,     0,     0,     0,
        0, 32768,     0, 32768,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384,  2048,  2048,  2048,  2048,  2048, 34816,  2048, 34816,
     2048, 34816,  2048, 34816, 34816,  2048, 51200, 18432,  2048,  2048,
     2048,  2048,  2048, 34816,  2048, 34816,  2048, 34816,  2048, 34816,
    34816,  2048, 51200, 18432,     0,     0,     0,     0,     0, 32768,
        0, 32768,     0, 32768,     0, 32768, 32768,     0, 49152, 16384,
     3072,  3072,  3072,  3072,  3072, 35840,  3072, 35840,  3072, 35840,
     3072, 35840, 35840,  3072, 52224, 19456,  1024,  1024,  1024,  1024,
     1024, 33792,  1024, 33792,  1024, 33792,  1024, 33792, 33792,  1024,
    50176, 17408,     0, 32768,     0, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0, 16384, 16384,  2048, 34816,
     2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048, 18432, 18432,     0, 32768,     0, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0, 16384, 16384,
     2048, 34816,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048, 18432, 18432,  2048, 34816,  2048, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
    18432, 18432,     0, 32768,     0, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0, 16384, 16384,  2048, 34816,
     2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048, 18432, 18432,     0, 32768,     0, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0, 16384, 16384,
     2048, 34816,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048, 18432, 18432,     0, 32768,     0, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
    16384, 16384,  2048, 34816,  2048, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048, 18432, 18432,     0, 32768,
        0, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0, 16384, 16384,     0, 32768,     0, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0, 16384, 16384,
        0, 32768,     0, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0, 16384, 16384,  1024, 33792,  1024, 33792,
    33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,
    17408, 17408,  1024, 33792,  1024, 33792, 33792,  1024, 33792,  1024,
    33792,  1024, 33792,  1024,  1024,  1024, 17408, 17408,     0,     0,
        0,     0,     0, 32768, 16384, 49152,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0, 32768,
    16384, 49152,     0, 32768, 16384, 49152, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0, 32768, 16384, 49152,     0, 32768,
    16384, 49152, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0, 32768, 16384, 49152,     0, 32768, 16384, 49152, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0, 32768, 16384, 49152,
        0, 32768, 16384, 49152, 49152, 16384, 32768,     0,  2048,  2048,
     2048,  2048,  2048, 34816, 18432, 51200,  2048, 34816, 18432, 51200,
    51200, 18432, 34816,  2048,  1024,  1024,  1024,  1024,  1024, 33792,
    17408, 50176,  1024, 33792, 17408, 50176, 50176, 17408, 33792,  1024,
     3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,  3072, 35840,
    19456, 52224, 52224, 19456, 35840,  3072,     0,     0,     0,     0,
        0, 32768, 16384, 49152,     0, 32768, 16384, 49152, 49152, 16384,
    32768,     0,  2048,  2048,  2048,  2048,  2048, 34816, 18432, 51200,
     2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,  1024,  1024,
     1024,  1024,  1024, 33792, 17408, 50176,  1024, 33792, 17408, 50176,
    50176, 17408, 33792,  1024,  3072,  3072,  3072,  3072,  3072, 35840,
    19456, 52224,  3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,  3072, 35840,
    19456, 52224, 52224, 19456, 35840,  3072,  1024,  1024,  1024,  1024,
     1024, 33792, 17408, 50176,  1024, 33792, 17408, 50176, 50176, 17408,
    33792,  1024,  2048,  2048,  2048,  2048,  2048, 34816, 18432, 51200,
     2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,     0,     0,
        0,     0,     0, 32768, 16384, 49152,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
     2048, 34816,  2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048,
    51200, 18432, 18432, 18432,  2048,  2048,     0, 32768,     0, 32768,
    32768,     0, 49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,
        0,     0,  2048, 34816,  2048, 34816, 34816,  2048, 51200, 18432,
    34816,  2048, 51200, 18432, 18432, 18432,  2048,  2048,  2048, 34816,
     2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432,
    18432, 18432,  2048,  2048,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
     3072, 35840,  3072, 35840, 35840,  3072, 52224, 19456, 35840,  3072,
    52224, 19456, 19456, 19456,  3072,  3072,  1024, 33792,  1024, 33792,
    33792,  1024, 50176, 17408, 33792,  1024, 50176, 17408, 17408, 17408,
     1024,  1024,  2048, 34816,  2048, 34816, 34816,  2048, 51200, 18432,
    34816,  2048, 51200, 18432, 18432, 18432,  2048,  2048,     0, 32768,
        0, 32768, 32768,     0, 49152, 16384, 32768,     0, 49152, 16384,
    16384, 16384,     0,     0,  3072, 35840,  3072, 35840, 35840,  3072,
    52224, 19456, 35840,  3072, 52224, 19456, 19456, 19456,  3072,  3072,
     1024, 33792,  1024, 33792, 33792,  1024, 50176, 17408, 33792,  1024,
    50176, 17408, 17408, 17408,  1024,  1024,  1024, 33792,  1024, 33792,
    33792,  1024, 50176, 17408, 33792,  1024, 50176, 17408, 17408, 17408,
     1024,  1024,  1024, 33792,  1024, 33792, 33792,  1024, 50176, 17408,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,     0, 32768,
        0, 32768, 32768,     0, 49152, 16384, 32768,     0, 49152, 16384,
    16384, 16384,     0,     0,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
        0, 32768,     0, 32768, 32768,     0, 49152, 16384, 32768,     0,
    49152, 16384, 16384, 16384,     0,     0,  2048, 34816,  2048, 34816,
    34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432, 18432, 18432,
     2048,  2048,     0, 32768,     0, 32768, 32768,     0, 49152, 16384,
    32768,     0, 49152, 16384, 16384, 16384,     0,     0,  2048, 34816,
     2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432,
    18432, 18432,  2048,  2048,  2048, 34816,  2048, 34816, 34816,  2048,
    51200, 18432, 34816,  2048, 51200, 18432, 18432, 18432,  2048,  2048,
        0, 32768,     0, 32768, 32768,     0, 49152, 16384, 32768,     0,
    49152, 16384, 16384, 16384,     0,     0,  3072, 35840,  3072, 35840,
    35840,  3072, 52224, 19456, 35840,  3072, 52224, 19456, 19456, 19456,
     3072,  3072,  1024, 33792,  1024, 33792, 33792,  1024, 50176, 17408,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,  2048, 34816,
     2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432,
    18432, 18432,  2048,  2048,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
     3072, 35840,  3072, 35840, 35840,  3072, 52224, 19456, 35840,  3072,
    52224, 19456, 19456, 19456,  3072,  3072,  1024, 33792,  1024, 33792,
    33792,  1024, 50176, 17408, 33792,  1024, 50176, 17408, 17408, 17408,
     1024,  1024,  1024, 33792,  1024, 33792, 33792,  1024, 50176, 17408,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,  1024, 33792,
     1024, 33792, 33792,  1024, 50176, 17408, 33792,  1024, 50176, 17408,
    17408, 17408,  1024,  1024,  1024, 33792,  1024, 33792, 33792,  1024,
    50176, 17408, 33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,
     1024, 33792,  1024, 33792, 33792,  1024, 50176, 17408, 33792,  1024,
    50176, 17408, 17408, 17408,  1024,  1024, 34816,  2048, 34816,  2048,
     2048,  2048, 18432, 18432,  2048,  2048, 18432, 18432, 18432, 18432,
     2048,  2048, 32768,     0, 32768,     0,     0,     0, 16384, 16384,
        0,     0, 16384, 16384, 16384, 16384,     0,     0, 34816,  2048,
    34816,  2048,  2048,  2048, 18432, 18432,  2048,  2048, 18432, 18432,
    18432, 18432,  2048,  2048, 32768,     0, 32768,     0,     0,     0,
    16384, 16384,     0,     0, 16384, 16384, 16384, 16384,     0,     0,
    32768,     0, 32768,     0,     0,     0, 16384, 16384,     0,     0,
    16384, 16384, 16384, 16384,     0,     0, 32768,     0, 32768,     0,
        0,     0, 16384, 16384,     0,     0, 16384, 16384, 16384, 16384,
        0,     0, 33792,  1024, 33792,  1024,  1024,  1024, 17408, 17408,
     1024,  1024, 17408, 17408, 17408, 17408,  1024,  1024, 33792,  1024,
    33792,  1024,  1024,  1024, 17408, 17408,  1024,  1024, 17408, 17408,
    17408, 17408,  1024,  1024, 32768,     0, 32768,     0,     0,     0,
    16384, 16384,     0,     0, 16384, 16384, 16384, 16384,     0,     0,
    32768,     0, 32768,     0,     0,     0, 16384, 16384,     0,     0,
    16384, 16384, 16384, 16384,     0,     0, 33792,  1024, 33792,  1024,
     1024,  1024, 17408, 17408,  1024,  1024, 17408, 17408, 17408, 17408,
     1024,  1024, 33792,  1024, 33792,  1024,  1024,  1024, 17408, 17408,
     1024,  1024, 17408, 17408, 17408, 17408,  1024,  1024, 33792,  1024,
    33792,  1024,  1024,  1024, 17408, 17408,  1024,  1024, 17408, 17408,
    17408, 17408,  1024,  1024, 33792,  1024, 33792,  1024,  1024,  1024,
    17408, 17408,  1024,  1024, 17408, 17408, 17408, 17408,  1024,  1024,
    33792,  1024, 33792,  1024,  1024,  1024, 17408, 17408,  1024,  1024,
    17408, 17408, 17408, 17408,  1024,  1024, 33792,  1024, 33792,  1024,
     1024,  1024, 17408, 17408,  1024,  1024, 17408, 17408, 17408, 17408,
     1024,  1024,     0, 32768, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,  2048, 34816,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  1024, 33792, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,
    52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072,  1024, 33792, 17408, 50176, 50176, 17408, 33792,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  3072, 35840,
    19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072,  1024, 33792, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  1024, 33792, 17408, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072,
    52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,  1024, 33792,
    17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024,  1024, 33792, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
     1024, 33792, 17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0, 32768, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 34816,  2048,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 32768,     0, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    35840,  3072, 52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,
     3072,  3072,  3072,  3072,  3072,  3072, 33792,  1024, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 33792,  1024,
    50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 33792,  1024, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 33792,  1024,
    50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 33792,  1024, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 32768,     0,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
     2048, 34816,  2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048,
    51200, 18432, 18432, 18432,  2048,  2048,     0, 32768,     0, 32768,
    32768,     0, 49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,
        0,     0,  2048, 34816,  2048, 34816, 34816,  2048, 51200, 18432,
    34816,  2048, 51200, 18432, 18432, 18432,  2048,  2048,  2048, 34816,
     2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432,
    18432, 18432,  2048,  2048,  2048, 34816,  2048, 34816, 34816,  2048,
    51200, 18432, 34816,  2048, 51200, 18432, 18432, 18432,  2048,  2048,
     3072, 35840,  3072, 35840, 35840,  3072, 52224, 19456, 35840,  3072,
    52224, 19456, 19456, 19456,  3072,  3072,  3072, 35840,  3072, 35840,
    35840,  3072, 52224, 19456, 35840,  3072, 52224, 19456, 19456, 19456,
     3072,  3072,  2048, 34816,  2048, 34816, 34816,  2048, 51200, 18432,
    34816,  2048, 51200, 18432, 18432, 18432,  2048,  2048,  2048, 34816,
     2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432,
    18432, 18432,  2048,  2048,  3072, 35840,  3072, 35840, 35840,  3072,
    52224, 19456, 35840,  3072, 52224, 19456, 19456, 19456,  3072,  3072,
     3072, 35840,  3072, 35840, 35840,  3072, 52224, 19456, 35840,  3072,
    52224, 19456, 19456, 19456,  3072,  3072,  3072, 35840,  3072, 35840,
    35840,  3072, 52224, 19456, 35840,  3072, 52224, 19456, 19456, 19456,
     3072,  3072,  1024, 33792,  1024, 33792, 33792,  1024, 50176, 17408,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,  2048, 34816,
     2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432,
    18432, 18432,  2048,  2048,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
    34816,  2048, 34816,  2048,  2048,  2048, 18432, 18432,  2048,  2048,
    18432, 18432, 18432, 18432,  2048,  2048, 34816,  2048, 34816,  2048,
     2048,  2048, 18432, 18432,  2048,  2048, 18432, 18432, 18432, 18432,
     2048,  2048, 34816,  2048, 34816,  2048,  2048,  2048, 18432, 18432,
     2048,  2048, 18432, 18432, 18432, 18432,  2048,  2048, 34816,  2048,
    34816,  2048,  2048,  2048, 18432, 18432,  2048,  2048, 18432, 18432,
    18432, 18432,  2048,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
    18432, 18432,  2048,  2048, 18432, 18432, 18432, 18432,  2048,  2048,
    32768,     0, 32768,     0,     0,     0, 16384, 16384,     0,     0,
    16384, 16384, 16384, 16384,     0,     0, 35840,  3072, 35840,  3072,
     3072,  3072, 19456, 19456,  3072,  3072, 19456, 19456, 19456, 19456,
     3072,  3072, 33792,  1024, 33792,  1024,  1024,  1024, 17408, 17408,
     1024,  1024, 17408, 17408, 17408, 17408,  1024,  1024, 34816,  2048,
    34816,  2048,  2048,  2048, 18432, 18432,  2048,  2048, 18432, 18432,
    18432, 18432,  2048,  2048, 32768,     0, 32768,     0,     0,     0,
    16384, 16384,     0,     0, 16384, 16384, 16384, 16384,     0,     0,
    35840,  3072, 35840,  3072,  3072,  3072, 19456, 19456,  3072,  3072,
    19456, 19456, 19456, 19456,  3072,  3072, 33792,  1024, 33792,  1024,
     1024,  1024, 17408, 17408,  1024,  1024, 17408, 17408, 17408, 17408,
     1024,  1024, 33792,  1024, 33792,  1024,  1024,  1024, 17408, 17408,
     1024,  1024, 17408, 17408, 17408, 17408,  1024,  1024, 33792,  1024,
    33792,  1024,  1024,  1024, 17408, 17408,  1024,  1024, 17408, 17408,
    17408, 17408,  1024,  1024, 32768,     0, 32768,     0,     0,     0,
    16384, 16384,     0,     0, 16384, 16384, 16384, 16384,     0,     0,
    32768,     0, 32768,     0,     0,     0, 16384, 16384,     0,     0,
    16384, 16384, 16384, 16384,     0,     0,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,  2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  1024, 33792,
    17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024,  3072, 35840, 19456, 52224, 52224, 19456,
    35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,
    52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072,  2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048, 34816,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  3072, 35840, 19456, 52224, 52224, 19456,
    35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  2048, 34816, 18432, 51200,
    51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048,  2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048, 34816,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,     0, 32768, 16384, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
     2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 34816,  2048, 51200, 18432, 18432, 18432,  2048,  2048,
    18432, 18432,  2048,  2048,  2048,  2048,  2048,  2048, 34816,  2048,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 35840,  3072, 52224, 19456, 19456, 19456,
     3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,  3072,  3072,
    35840,  3072, 52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,
     3072,  3072,  3072,  3072,  3072,  3072, 35840,  3072, 52224, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 34816,  2048,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 32768,     0, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    35840,  3072, 52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,
     3072,  3072,  3072,  3072,  3072,  3072, 33792,  1024, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 34816,  2048, 51200, 18432, 18432, 18432,  2048,  2048,
    18432, 18432,  2048,  2048,  2048,  2048,  2048,  2048, 32768,     0,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 32768,     0, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    32768,     0, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 32768,     0, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 34816,  2048,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 34816,  2048, 51200, 18432, 18432, 18432,
     2048,  2048, 18432, 18432,  2048,  2048,  2048,  2048,  2048,  2048,
    35840,  3072, 52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,
     3072,  3072,  3072,  3072,  3072,  3072, 35840,  3072, 52224, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 35840,  3072, 52224, 19456, 19456, 19456,  3072,  3072,
    19456, 19456,  3072,  3072,  3072,  3072,  3072,  3072, 33792,  1024,
    50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 35840,  3072, 52224, 19456, 19456, 19456,
     3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,  3072,  3072,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 35840,  3072, 52224, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 35840,  3072,
    52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,
     3072,  3072,  3072,  3072, 33792,  1024, 50176, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 33792,  1024, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 32768,     0,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,  2048,  2048, 18432, 18432, 18432, 18432,
     2048,  2048, 18432, 18432,  2048,  2048,  2048,  2048,  2048,  2048,
        0,     0, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,  3072,  3072, 19456, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072,  1024,  1024, 17408, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,     0,     0,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 19456, 19456,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024, 19456, 19456,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0, 16384, 16384,
    16384, 49152,     0, 32768,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0, 16384, 16384, 16384, 49152,     0, 32768,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
    16384, 16384, 16384, 49152,     0, 32768,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0, 16384, 16384, 16384, 49152,
        0, 32768,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768,  1024,  1024,
     1024,  1024,  1024,  1024, 17408, 17408,  1024,  1024, 17408, 17408,
    17408, 50176,  1024, 33792,  1024,  1024,  1024,  1024,  1024,  1024,
    17408, 17408,  1024,  1024, 17408, 17408, 17408, 50176,  1024, 33792,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
    16384, 16384, 16384, 49152,     0, 32768,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0, 16384, 16384, 16384, 49152,
        0, 32768,  1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,
     1024,  1024, 17408, 17408, 17408, 50176,  1024, 33792,  1024,  1024,
     1024,  1024,  1024,  1024, 17408, 17408,  1024,  1024, 17408, 17408,
    17408, 50176,  1024, 33792,  1024,  1024,  1024,  1024,  1024,  1024,
    17408, 17408,  1024,  1024, 17408, 17408, 17408, 50176,  1024, 33792,
     3072,  3072,  3072,  3072,  3072,  3072, 19456, 19456,  3072,  3072,
    19456, 19456, 19456, 52224,  3072, 35840,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0, 16384, 16384, 16384, 49152,
        0, 32768,  2048,  2048,  2048,  2048,  2048,  2048, 18432, 18432,
     2048,  2048, 18432, 18432, 18432, 51200,  2048, 34816,     0,     0,
        0,     0,     0, 32768, 16384, 49152,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0, 32768,
    16384, 49152,     0, 32768, 16384, 49152, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0, 32768, 16384, 49152,     0, 32768,
    16384, 49152, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0, 32768, 16384, 49152,     0, 32768, 16384, 49152, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0, 32768, 16384, 49152,
        0, 32768, 16384, 49152, 49152, 16384, 32768,     0,  2048,  2048,
     2048,  2048,  2048, 34816, 18432, 51200,  2048, 34816, 18432, 51200,
    51200, 18432, 34816,  2048,  1024,  1024,  1024,  1024,  1024, 33792,
    17408, 50176,  1024, 33792, 17408, 50176, 50176, 17408, 33792,  1024,
     3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,  3072, 35840,
    19456, 52224, 52224, 19456, 35840,  3072,     0,     0,     0,     0,
        0, 32768, 16384, 49152,     0, 32768, 16384, 49152, 49152, 16384,
    32768,     0,  2048,  2048,  2048,  2048,  2048, 34816, 18432, 51200,
     2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,  1024,  1024,
     1024,  1024,  1024, 33792, 17408, 50176,  1024, 33792, 17408, 50176,
    50176, 17408, 33792,  1024,  3072,  3072,  3072,  3072,  3072, 35840,
    19456, 52224,  3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,  3072, 35840,
    19456, 52224, 52224, 19456, 35840,  3072,  1024,  1024,  1024,  1024,
     1024, 33792, 17408, 50176,  1024, 33792, 17408, 50176, 50176, 17408,
    33792,  1024,  2048,  2048,  2048,  2048,  2048, 34816, 18432, 51200,
     2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,     0,     0,
        0,     0,     0, 32768, 16384, 49152,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0,     0,     0, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0, 32768,     0, 32768,
        0,     0, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0, 32768,     0, 32768,  1024,  1024, 17408, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024, 33792,
     1024, 33792,  1024,  1024, 17408, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024, 33792,  1024, 33792,  1024,  1024,
    17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024, 33792,  1024, 33792,  1024,  1024, 17408, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024, 33792,  1024, 33792,
        0,     0, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0, 32768,     0, 32768,     0,     0, 16384, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0, 32768,
        0, 32768,  1024,  1024, 17408, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024, 33792,  1024, 33792,  1024,  1024,
    17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024, 33792,  1024, 33792,     0,     0, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0, 32768,     0, 32768,
        0,     0, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0, 32768,     0, 32768,     0,     0, 16384, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0, 32768,
        0, 32768,  2048,  2048, 18432, 18432, 18432, 18432,  2048,  2048,
    18432, 18432,  2048,  2048,  2048, 34816,  2048, 34816,     0,     0,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0, 32768,     0, 32768,  2048,  2048, 18432, 18432, 18432, 18432,
     2048,  2048, 18432, 18432,  2048,  2048,  2048, 34816,  2048, 34816,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,
        0, 32768, 32768,     0, 32768,     0,     0,     0, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0,  1024,  1024, 17408, 17408, 17408, 50176,  1024, 33792,
    17408, 50176,  1024, 33792, 33792,  1024, 33792,  1024,  1024,  1024,
    17408, 17408, 17408, 50176,  1024, 33792, 17408, 50176,  1024, 33792,
    33792,  1024, 33792,  1024,  1024,  1024, 17408, 17408, 17408, 50176,
     1024, 33792, 17408, 50176,  1024, 33792, 33792,  1024, 33792,  1024,
     3072,  3072, 19456, 19456, 19456, 52224,  3072, 35840, 19456, 52224,
     3072, 35840, 35840,  3072, 35840,  3072,     0,     0, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0,  2048,  2048, 18432, 18432, 18432, 51200,  2048, 34816,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,  1024,  1024,
    17408, 17408, 17408, 50176,  1024, 33792, 17408, 50176,  1024, 33792,
    33792,  1024, 33792,  1024,  3072,  3072, 19456, 19456, 19456, 52224,
     3072, 35840, 19456, 52224,  3072, 35840, 35840,  3072, 35840,  3072,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,
        0, 32768, 32768,     0, 32768,     0,  2048,  2048, 18432, 18432,
    18432, 51200,  2048, 34816, 18432, 51200,  2048, 34816, 34816,  2048,
    34816,  2048,  2048,  2048, 18432, 18432, 18432, 51200,  2048, 34816,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,     0,     0,
    16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,     0, 32768,
    32768,     0, 32768,     0,  2048,  2048, 18432, 18432, 18432, 51200,
     2048, 34816, 18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,
        0, 32768, 32768,     0, 32768,     0,     0,     0, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0,     0,     0, 16384, 16384, 16384, 49152,     0, 32768,
    16384, 49152,     0, 32768, 32768,     0, 32768,     0,  1024,  1024,
    17408, 17408, 17408, 50176,  1024, 33792, 17408, 50176,  1024, 33792,
    33792,  1024, 33792,  1024,  1024,  1024, 17408, 17408, 17408, 50176,
     1024, 33792, 17408, 50176,  1024, 33792, 33792,  1024, 33792,  1024,
     1024,  1024, 17408, 17408, 17408, 50176,  1024, 33792, 17408, 50176,
     1024, 33792, 33792,  1024, 33792,  1024,  3072,  3072, 19456, 19456,
    19456, 52224,  3072, 35840, 19456, 52224,  3072, 35840, 35840,  3072,
    35840,  3072,  1024,  1024, 17408, 17408, 17408, 50176,  1024, 33792,
    17408, 50176,  1024, 33792, 33792,  1024, 33792,  1024,  3072,  3072,
    19456, 19456, 19456, 52224,  3072, 35840, 19456, 52224,  3072, 35840,
    35840,  3072, 35840,  3072,  1024,  1024, 17408, 17408, 17408, 50176,
     1024, 33792, 17408, 50176,  1024, 33792, 33792,  1024, 33792,  1024,
     3072,  3072, 19456, 19456, 19456, 52224,  3072, 35840, 19456, 52224,
     3072, 35840, 35840,  3072, 35840,  3072,  1024,  1024, 17408, 17408,
    17408, 50176,  1024, 33792, 17408, 50176,  1024, 33792, 33792,  1024,
    33792,  1024,  3072,  3072, 19456, 19456, 19456, 52224,  3072, 35840,
    19456, 52224,  3072, 35840, 35840,  3072, 35840,  3072,  3072,  3072,
    19456, 19456, 19456, 52224,  3072, 35840, 19456, 52224,  3072, 35840,
    35840,  3072, 35840,  3072,  1024,  1024, 17408, 17408, 17408, 50176,
     1024, 33792, 17408, 50176,  1024, 33792, 33792,  1024, 33792,  1024,
     2048,  2048, 18432, 18432, 18432, 51200,  2048, 34816, 18432, 51200,
     2048, 34816, 34816,  2048, 34816,  2048,     0,     0, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0,     0, 32768, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,  2048, 34816,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  1024, 33792, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,
    52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072,  1024, 33792, 17408, 50176, 50176, 17408, 33792,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  3072, 35840,
    19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072,  1024, 33792, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  1024, 33792, 17408, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072,
    52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,  1024, 33792,
    17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024,  1024, 33792, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
     1024, 33792, 17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0, 32768, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 17408, 17408,
     1024,  1024,  1024, 33792,  1024, 33792,  1024, 33792,  1024, 33792,
    33792,  1024, 33792,  1024, 17408, 17408,  1024,  1024,  1024, 33792,
     1024, 33792,  1024, 33792,  1024, 33792, 33792,  1024, 33792,  1024,
    17408, 17408,  1024,  1024,  1024, 33792,  1024, 33792,  1024, 33792,
     1024, 33792, 33792,  1024, 33792,  1024, 17408, 17408,  1024,  1024,
     1024, 33792,  1024, 33792,  1024, 33792,  1024, 33792, 33792,  1024,
    33792,  1024, 17408, 17408,  1024,  1024,  1024, 33792,  1024, 33792,
     1024, 33792,  1024, 33792, 33792,  1024, 33792,  1024, 19456, 19456,
     3072,  3072,  3072, 35840,  3072, 35840,  3072, 35840,  3072, 35840,
    35840,  3072, 35840,  3072, 16384, 16384,     0,     0,     0, 32768,
        0, 32768,     0, 32768,     0, 32768, 32768,     0, 32768,     0,
    18432, 18432,  2048,  2048,  2048, 34816,  2048, 34816,  2048, 34816,
     2048, 34816, 34816,  2048, 34816,  2048, 17408, 17408,  1024,  1024,
     1024, 33792,  1024, 33792,  1024, 33792,  1024, 33792, 33792,  1024,
    33792,  1024, 19456, 19456,  3072,  3072,  3072, 35840,  3072, 35840,
     3072, 35840,  3072, 35840, 35840,  3072, 35840,  3072, 16384, 16384,
        0,     0,     0, 32768,     0, 32768,     0, 32768,     0, 32768,
    32768,     0, 32768,     0, 18432, 18432,  2048,  2048,  2048, 34816,
     2048, 34816,  2048, 34816,  2048, 34816, 34816,  2048, 34816,  2048,
    18432, 18432,  2048,  2048,  2048, 34816,  2048, 34816,  2048, 34816,
     2048, 34816, 34816,  2048, 34816,  2048, 16384, 16384,     0,     0,
        0, 32768,     0, 32768,     0, 32768,     0, 32768, 32768,     0,
    32768,     0, 18432, 18432,  2048,  2048,  2048, 34816,  2048, 34816,
     2048, 34816,  2048, 34816, 34816,  2048, 34816,  2048, 16384, 16384,
        0,     0,     0, 32768,     0, 32768,     0, 32768,     0, 32768,
    32768,     0, 32768,     0, 17408, 50176,  1024, 33792, 33792,  1024,
    33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,  1024,  1024,
    19456, 52224,  3072, 35840, 35840,  3072, 35840,  3072, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072, 17408, 50176,  1024, 33792,
    33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,
     1024,  1024, 19456, 52224,  3072, 35840, 35840,  3072, 35840,  3072,
    35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072, 19456, 52224,
     3072, 35840, 35840,  3072, 35840,  3072, 35840,  3072, 35840,  3072,
     3072,  3072,  3072,  3072, 17408, 50176,  1024, 33792, 33792,  1024,
    33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,  1024,  1024,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 16384, 49152,     0, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 19456, 52224,  3072, 35840, 35840,  3072, 35840,  3072,
    35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072, 17408, 50176,
     1024, 33792, 33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,
     1024,  1024,  1024,  1024, 18432, 51200,  2048, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    16384, 49152,     0, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 16384, 49152,     0, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 16384, 49152,     0, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 16384, 49152,
        0, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,
        0, 32768, 32768,     0, 32768,     0,     0,     0, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0,  1024,  1024, 17408, 17408, 17408, 50176,  1024, 33792,
    17408, 50176,  1024, 33792, 33792,  1024, 33792,  1024,  1024,  1024,
    17408, 17408, 17408, 50176,  1024, 33792, 17408, 50176,  1024, 33792,
    33792,  1024, 33792,  1024,  1024,  1024, 17408, 17408, 17408, 50176,
     1024, 33792, 17408, 50176,  1024, 33792, 33792,  1024, 33792,  1024,
     3072,  3072, 19456, 19456, 19456, 52224,  3072, 35840, 19456, 52224,
     3072, 35840, 35840,  3072, 35840,  3072,     0,     0, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0,  2048,  2048, 18432, 18432, 18432, 51200,  2048, 34816,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,  1024,  1024,
    17408, 17408, 17408, 50176,  1024, 33792, 17408, 50176,  1024, 33792,
    33792,  1024, 33792,  1024,  3072,  3072, 19456, 19456, 19456, 52224,
     3072, 35840, 19456, 52224,  3072, 35840, 35840,  3072, 35840,  3072,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,
        0, 32768, 32768,     0, 32768,     0,  2048,  2048, 18432, 18432,
    18432, 51200,  2048, 34816, 18432, 51200,  2048, 34816, 34816,  2048,
    34816,  2048,  2048,  2048, 18432, 18432, 18432, 51200,  2048, 34816,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,  2048,  2048,
    18432, 18432, 18432, 51200,  2048, 34816, 18432, 51200,  2048, 34816,
    34816,  2048, 34816,  2048,  2048,  2048, 18432, 18432, 18432, 51200,
     2048, 34816, 18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,
     2048,  2048, 18432, 18432, 18432, 51200,  2048, 34816, 18432, 51200,
     2048, 34816, 34816,  2048, 34816,  2048,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,  2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  1024, 33792,
    17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024,  3072, 35840, 19456, 52224, 52224, 19456,
    35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,
    52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072,  2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048, 34816,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  3072, 35840, 19456, 52224, 52224, 19456,
    35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  2048, 34816, 18432, 51200,
    51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048,  2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048, 34816,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,     0, 32768, 16384, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
     2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 17408, 17408,  1024,  1024,  1024, 33792,  1024, 33792,
     1024, 33792,  1024, 33792, 33792,  1024, 33792,  1024, 17408, 17408,
     1024,  1024,  1024, 33792,  1024, 33792,  1024, 33792,  1024, 33792,
    33792,  1024, 33792,  1024, 16384, 16384,     0,     0,     0, 32768,
        0, 32768,     0, 32768,     0, 32768, 32768,     0, 32768,     0,
    16384, 16384,     0,     0,     0, 32768,     0, 32768,     0, 32768,
        0, 32768, 32768,     0, 32768,     0, 16384, 16384,     0,     0,
        0, 32768,     0, 32768,     0, 32768,     0, 32768, 32768,     0,
    32768,     0, 18432, 18432,  2048,  2048,  2048, 34816,  2048, 34816,
     2048, 34816,  2048, 34816, 34816,  2048, 34816,  2048, 16384, 16384,
        0,     0,     0, 32768,     0, 32768,     0, 32768,     0, 32768,
    32768,     0, 32768,     0, 18432, 18432,  2048,  2048,  2048, 34816,
     2048, 34816,  2048, 34816,  2048, 34816, 34816,  2048, 34816,  2048,
    16384, 16384,     0,     0,     0, 32768,     0, 32768,     0, 32768,
        0, 32768, 32768,     0, 32768,     0, 18432, 18432,  2048,  2048,
     2048, 34816,  2048, 34816,  2048, 34816,  2048, 34816, 34816,  2048,
    34816,  2048, 16384, 16384,     0,     0,     0, 32768,     0, 32768,
        0, 32768,     0, 32768, 32768,     0, 32768,     0, 18432, 18432,
     2048,  2048,  2048, 34816,  2048, 34816,  2048, 34816,  2048, 34816,
    34816,  2048, 34816,  2048, 18432, 18432,  2048,  2048,  2048, 34816,
     2048, 34816,  2048, 34816,  2048, 34816, 34816,  2048, 34816,  2048,
    18432, 18432,  2048,  2048,  2048, 34816,  2048, 34816,  2048, 34816,
     2048, 34816, 34816,  2048, 34816,  2048, 18432, 18432,  2048,  2048,
     2048, 34816,  2048, 34816,  2048, 34816,  2048, 34816, 34816,  2048,
    34816,  2048, 18432, 18432,  2048,  2048,  2048, 34816,  2048, 34816,
     2048, 34816,  2048, 34816, 34816,  2048, 34816,  2048, 17408, 50176,
     1024, 33792, 33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,
     1024,  1024,  1024,  1024, 19456, 52224,  3072, 35840, 35840,  3072,
    35840,  3072, 35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072,
    16384, 49152,     0, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 18432, 51200,  2048, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,
     2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 18432, 51200,  2048, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,  2048, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,
     2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 18432, 51200,  2048, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 16384, 49152,     0, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 16384, 49152,
        0, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 17408, 50176,  1024, 33792, 33792,  1024,
    33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,  1024,  1024,
    19456, 52224,  3072, 35840, 35840,  3072, 35840,  3072, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072, 17408, 50176,  1024, 33792,
    33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,
     1024,  1024, 19456, 52224,  3072, 35840, 35840,  3072, 35840,  3072,
    35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072, 19456, 52224,
     3072, 35840, 35840,  3072, 35840,  3072, 35840,  3072, 35840,  3072,
     3072,  3072,  3072,  3072, 19456, 52224,  3072, 35840, 35840,  3072,
    35840,  3072, 35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,  2048, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 19456, 52224,  3072, 35840, 35840,  3072, 35840,  3072,
    35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072, 19456, 52224,
     3072, 35840, 35840,  3072, 35840,  3072, 35840,  3072, 35840,  3072,
     3072,  3072,  3072,  3072, 18432, 51200,  2048, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,  2048, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 16384, 49152,     0, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 18432, 51200,
     2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  1024, 33792,  1024, 33792,
    33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,
     1024,  1024,  3072, 35840,  3072, 35840, 35840,  3072, 35840,  3072,
    35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072,     0, 32768,
        0, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,  2048, 34816,  2048, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
     2048, 34816,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048,  2048, 34816,  2048, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048,  2048, 34816,  2048, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,  2048, 34816,
     2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048,  2048, 34816,  2048, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
     2048, 34816,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048,  2048, 34816,  2048, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048,  2048, 34816,  2048, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,  2048, 34816,
     2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048,     0, 32768,     0, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
     2048, 34816,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048,     0, 32768,     0, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0, 32768, 16384, 49152,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0, 32768,
    16384, 49152,     0, 32768, 16384, 49152, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0, 32768, 16384, 49152,     0, 32768,
    16384, 49152, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0, 32768, 16384, 49152,     0, 32768, 16384, 49152, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0, 32768, 16384, 49152,
        0, 32768, 16384, 49152, 49152, 16384, 32768,     0,  2048,  2048,
     2048,  2048,  2048, 34816, 18432, 51200,  2048, 34816, 18432, 51200,
    51200, 18432, 34816,  2048,  1024,  1024,  1024,  1024,  1024, 33792,
    17408, 50176,  1024, 33792, 17408, 50176, 50176, 17408, 33792,  1024,
     3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,  3072, 35840,
    19456, 52224, 52224, 19456, 35840,  3072,     0,     0,     0,     0,
        0, 32768, 16384, 49152,     0, 32768, 16384, 49152, 49152, 16384,
    32768,     0,  2048,  2048,  2048,  2048,  2048, 34816, 18432, 51200,
     2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,  1024,  1024,
     1024,  1024,  1024, 33792, 17408, 50176,  1024, 33792, 17408, 50176,
    50176, 17408, 33792,  1024,  3072,  3072,  3072,  3072,  3072, 35840,
    19456, 52224,  3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,  3072, 35840,
    19456, 52224, 52224, 19456, 35840,  3072,  1024,  1024,  1024,  1024,
     1024, 33792, 17408, 50176,  1024, 33792, 17408, 50176, 50176, 17408,
    33792,  1024,  2048,  2048,  2048,  2048,  2048, 34816, 18432, 51200,
     2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,     0,     0,
        0,     0,     0, 32768, 16384, 49152,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
     2048, 34816,  2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048,
    51200, 18432, 18432, 18432,  2048,  2048,     0, 32768,     0, 32768,
    32768,     0, 49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,
        0,     0,  2048, 34816,  2048, 34816, 34816,  2048, 51200, 18432,
    34816,  2048, 51200, 18432, 18432, 18432,  2048,  2048,  2048, 34816,
     2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432,
    18432, 18432,  2048,  2048,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
     3072, 35840,  3072, 35840, 35840,  3072, 52224, 19456, 35840,  3072,
    52224, 19456, 19456, 19456,  3072,  3072,  1024, 33792,  1024, 33792,
    33792,  1024, 50176, 17408, 33792,  1024, 50176, 17408, 17408, 17408,
     1024,  1024,  2048, 34816,  2048, 34816, 34816,  2048, 51200, 18432,
    34816,  2048, 51200, 18432, 18432, 18432,  2048,  2048,     0, 32768,
        0, 32768, 32768,     0, 49152, 16384, 32768,     0, 49152, 16384,
    16384, 16384,     0,     0,  3072, 35840,  3072, 35840, 35840,  3072,
    52224, 19456, 35840,  3072, 52224, 19456, 19456, 19456,  3072,  3072,
     1024, 33792,  1024, 33792, 33792,  1024, 50176, 17408, 33792,  1024,
    50176, 17408, 17408, 17408,  1024,  1024,  1024, 33792,  1024, 33792,
    33792,  1024, 50176, 17408, 33792,  1024, 50176, 17408, 17408, 17408,
     1024,  1024,  1024, 33792,  1024, 33792, 33792,  1024, 50176, 17408,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,     0, 32768,
        0, 32768, 32768,     0, 49152, 16384, 32768,     0, 49152, 16384,
    16384, 16384,     0,     0,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,
        0, 32768, 32768,     0, 32768,     0,     0,     0, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0,  1024,  1024, 17408, 17408, 17408, 50176,  1024, 33792,
    17408, 50176,  1024, 33792, 33792,  1024, 33792,  1024,  1024,  1024,
    17408, 17408, 17408, 50176,  1024, 33792, 17408, 50176,  1024, 33792,
    33792,  1024, 33792,  1024,  1024,  1024, 17408, 17408, 17408, 50176,
     1024, 33792, 17408, 50176,  1024, 33792, 33792,  1024, 33792,  1024,
     3072,  3072, 19456, 19456, 19456, 52224,  3072, 35840, 19456, 52224,
     3072, 35840, 35840,  3072, 35840,  3072,     0,     0, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0,  2048,  2048, 18432, 18432, 18432, 51200,  2048, 34816,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,  1024,  1024,
    17408, 17408, 17408, 50176,  1024, 33792, 17408, 50176,  1024, 33792,
    33792,  1024, 33792,  1024,  3072,  3072, 19456, 19456, 19456, 52224,
     3072, 35840, 19456, 52224,  3072, 35840, 35840,  3072, 35840,  3072,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,
        0, 32768, 32768,     0, 32768,     0,  2048,  2048, 18432, 18432,
    18432, 51200,  2048, 34816, 18432, 51200,  2048, 34816, 34816,  2048,
    34816,  2048,  2048,  2048, 18432, 18432, 18432, 51200,  2048, 34816,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,     0,     0,
    16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,     0, 32768,
    32768,     0, 32768,     0,  2048,  2048, 18432, 18432, 18432, 51200,
     2048, 34816, 18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,
        0, 32768, 32768,     0, 32768,     0,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,  2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  1024, 33792,
    17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024,  3072, 35840, 19456, 52224, 52224, 19456,
    35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  1024, 33792, 17408, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,     0, 32768,
    16384, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,  3072, 35840, 19456, 52224, 52224, 19456,
    35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     1024, 33792, 17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024,  2048, 34816, 18432, 51200,
    51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048,     0, 32768, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0, 32768,
    16384, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0, 32768, 16384, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0, 32768, 16384, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0, 32768, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,  2048, 34816,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  1024, 33792, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,
    52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072,  1024, 33792, 17408, 50176, 50176, 17408, 33792,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  3072, 35840,
    19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072,  1024, 33792, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  1024, 33792, 17408, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072,
    52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,  1024, 33792,
    17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024,  1024, 33792, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
     1024, 33792, 17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0, 32768, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 34816,  2048,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 32768,     0, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    35840,  3072, 52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,
     3072,  3072,  3072,  3072,  3072,  3072, 33792,  1024, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 33792,  1024,
    50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 33792,  1024, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 33792,  1024,
    50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 33792,  1024, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 32768,     0,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 17408, 50176,  1024, 33792, 33792,  1024,
    33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,  1024,  1024,
    19456, 52224,  3072, 35840, 35840,  3072, 35840,  3072, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072, 17408, 50176,  1024, 33792,
    33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,
     1024,  1024, 19456, 52224,  3072, 35840, 35840,  3072, 35840,  3072,
    35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072, 19456, 52224,
     3072, 35840, 35840,  3072, 35840,  3072, 35840,  3072, 35840,  3072,
     3072,  3072,  3072,  3072, 17408, 50176,  1024, 33792, 33792,  1024,
    33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,  1024,  1024,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 16384, 49152,     0, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 19456, 52224,  3072, 35840, 35840,  3072, 35840,  3072,
    35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072, 17408, 50176,
     1024, 33792, 33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,
     1024,  1024,  1024,  1024, 18432, 51200,  2048, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    16384, 49152,     0, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 16384, 49152,     0, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 16384, 49152,     0, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 16384, 49152,
        0, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,  2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  1024, 33792,
    17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024,  3072, 35840, 19456, 52224, 52224, 19456,
    35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,
    52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072,  2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048, 34816,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  3072, 35840, 19456, 52224, 52224, 19456,
    35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     3072, 35840, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  2048, 34816, 18432, 51200,
    51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048,  2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048, 34816,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,     0, 32768, 16384, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
     2048, 34816, 18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048,     0, 32768, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 34816,  2048, 51200, 18432, 18432, 18432,  2048,  2048,
    18432, 18432,  2048,  2048,  2048,  2048,  2048,  2048, 34816,  2048,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 35840,  3072, 52224, 19456, 19456, 19456,
     3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,  3072,  3072,
    35840,  3072, 52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,
     3072,  3072,  3072,  3072,  3072,  3072, 35840,  3072, 52224, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 34816,  2048,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 32768,     0, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    35840,  3072, 52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,
     3072,  3072,  3072,  3072,  3072,  3072, 33792,  1024, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 34816,  2048, 51200, 18432, 18432, 18432,  2048,  2048,
    18432, 18432,  2048,  2048,  2048,  2048,  2048,  2048, 32768,     0,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 32768,     0, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    32768,     0, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 32768,     0, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 17408, 50176,
     1024, 33792, 33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,
     1024,  1024,  1024,  1024, 19456, 52224,  3072, 35840, 35840,  3072,
    35840,  3072, 35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072,
    16384, 49152,     0, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 18432, 51200,  2048, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,
     2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 18432, 51200,  2048, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,  2048, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,
     2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 18432, 51200,  2048, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 16384, 49152,     0, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 16384, 49152,
        0, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
    52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 19456, 19456,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024, 19456, 19456,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0, 32768,
    16384, 49152,     0, 32768, 16384, 49152, 49152, 16384, 49152, 16384,
        0,     0,     0,     0,     0, 32768, 16384, 49152,     0, 32768,
    16384, 49152, 49152, 16384, 49152, 16384,     0,     0,     0,     0,
        0, 32768, 16384, 49152,     0, 32768, 16384, 49152, 49152, 16384,
    49152, 16384,     0,     0,     0,     0,     0, 32768, 16384, 49152,
        0, 32768, 16384, 49152, 49152, 16384, 49152, 16384,     0,     0,
        0,     0,     0, 32768, 16384, 49152,     0, 32768, 16384, 49152,
    49152, 16384, 49152, 16384,  2048,  2048,  2048,  2048,  2048, 34816,
    18432, 51200,  2048, 34816, 18432, 51200, 51200, 18432, 51200, 18432,
     1024,  1024,  1024,  1024,  1024, 33792, 17408, 50176,  1024, 33792,
    17408, 50176, 50176, 17408, 50176, 17408,  3072,  3072,  3072,  3072,
     3072, 35840, 19456, 52224,  3072, 35840, 19456, 52224, 52224, 19456,
    52224, 19456,     0,     0,     0,     0,     0, 32768, 16384, 49152,
        0, 32768, 16384, 49152, 49152, 16384, 49152, 16384,  2048,  2048,
     2048,  2048,  2048, 34816, 18432, 51200,  2048, 34816, 18432, 51200,
    51200, 18432, 51200, 18432,  1024,  1024,  1024,  1024,  1024, 33792,
    17408, 50176,  1024, 33792, 17408, 50176, 50176, 17408, 50176, 17408,
     3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,  3072, 35840,
    19456, 52224, 52224, 19456, 52224, 19456,  3072,  3072,  3072,  3072,
     3072, 35840, 19456, 52224,  3072, 35840, 19456, 52224, 52224, 19456,
    52224, 19456,  1024,  1024,  1024,  1024,  1024, 33792, 17408, 50176,
     1024, 33792, 17408, 50176, 50176, 17408, 50176, 17408,  2048,  2048,
     2048,  2048,  2048, 34816, 18432, 51200,  2048, 34816, 18432, 51200,
    51200, 18432, 51200, 18432,     0,     0,     0,     0,     0, 32768,
    16384, 49152,     0, 32768, 16384, 49152, 49152, 16384, 49152, 16384,
        0, 32768,     0, 32768, 32768,     0, 49152, 16384, 32768,     0,
    49152, 16384, 16384, 16384, 16384, 16384,  2048, 34816,  2048, 34816,
    34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432, 18432, 18432,
    18432, 18432,     0, 32768,     0, 32768, 32768,     0, 49152, 16384,
    32768,     0, 49152, 16384, 16384, 16384, 16384, 16384,  2048, 34816,
     2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432,
    18432, 18432, 18432, 18432,  2048, 34816,  2048, 34816, 34816,  2048,
    51200, 18432, 34816,  2048, 51200, 18432, 18432, 18432, 18432, 18432,
        0, 32768,     0, 32768, 32768,     0, 49152, 16384, 32768,     0,
    49152, 16384, 16384, 16384, 16384, 16384,  3072, 35840,  3072, 35840,
    35840,  3072, 52224, 19456, 35840,  3072, 52224, 19456, 19456, 19456,
    19456, 19456,  1024, 33792,  1024, 33792, 33792,  1024, 50176, 17408,
    33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408,  2048, 34816,
     2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432,
    18432, 18432, 18432, 18432,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384, 16384, 16384,
     3072, 35840,  3072, 35840, 35840,  3072, 52224, 19456, 35840,  3072,
    52224, 19456, 19456, 19456, 19456, 19456,  1024, 33792,  1024, 33792,
    33792,  1024, 50176, 17408, 33792,  1024, 50176, 17408, 17408, 17408,
    17408, 17408,  1024, 33792,  1024, 33792, 33792,  1024, 50176, 17408,
    33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408,  1024, 33792,
     1024, 33792, 33792,  1024, 50176, 17408, 33792,  1024, 50176, 17408,
    17408, 17408, 17408, 17408,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384, 16384, 16384,
        0, 32768,     0, 32768, 32768,     0, 49152, 16384, 32768,     0,
    49152, 16384, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
    16384, 49152, 16384, 49152, 16384, 49152, 16384, 49152, 49152, 16384,
    32768,     0,     0,     0, 16384, 16384, 16384, 49152, 16384, 49152,
    16384, 49152, 16384, 49152, 49152, 16384, 32768,     0,  1024,  1024,
    17408, 17408, 17408, 50176, 17408, 50176, 17408, 50176, 17408, 50176,
    50176, 17408, 33792,  1024,  1024,  1024, 17408, 17408, 17408, 50176,
    17408, 50176, 17408, 50176, 17408, 50176, 50176, 17408, 33792,  1024,
     1024,  1024, 17408, 17408, 17408, 50176, 17408, 50176, 17408, 50176,
    17408, 50176, 50176, 17408, 33792,  1024,  3072,  3072, 19456, 19456,
    19456, 52224, 19456, 52224, 19456, 52224, 19456, 52224, 52224, 19456,
    35840,  3072,     0,     0, 16384, 16384, 16384, 49152, 16384, 49152,
    16384, 49152, 16384, 49152, 49152, 16384, 32768,     0,  2048,  2048,
    18432, 18432, 18432, 51200, 18432, 51200, 18432, 51200, 18432, 51200,
    51200, 18432, 34816,  2048,  1024,  1024, 17408, 17408, 17408, 50176,
    17408, 50176, 17408, 50176, 17408, 50176, 50176, 17408, 33792,  1024,
     3072,  3072, 19456, 19456, 19456, 52224, 19456, 52224, 19456, 52224,
    19456, 52224, 52224, 19456, 35840,  3072,     0,     0, 16384, 16384,
    16384, 49152, 16384, 49152, 16384, 49152, 16384, 49152, 49152, 16384,
    32768,     0,  2048,  2048, 18432, 18432, 18432, 51200, 18432, 51200,
    18432, 51200, 18432, 51200, 51200, 18432, 34816,  2048,  2048,  2048,
    18432, 18432, 18432, 51200, 18432, 51200, 18432, 51200, 18432, 51200,
    51200, 18432, 34816,  2048,     0,     0, 16384, 16384, 16384, 49152,
    16384, 49152, 16384, 49152, 16384, 49152, 49152, 16384, 32768,     0,
     2048,  2048, 18432, 18432, 18432, 51200, 18432, 51200, 18432, 51200,
    18432, 51200, 51200, 18432, 34816,  2048,     0,     0, 16384, 16384,
    16384, 49152, 16384, 49152, 16384, 49152, 16384, 49152, 49152, 16384,
    32768,     0,     0, 32768, 16384, 49152, 49152, 16384, 49152, 16384,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0,  2048, 34816,
    18432, 51200, 51200, 18432, 51200, 18432, 51200, 18432, 51200, 18432,
    18432, 18432,  2048,  2048,  1024, 33792, 17408, 50176, 50176, 17408,
    50176, 17408, 50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,
     3072, 35840, 19456, 52224, 52224, 19456, 52224, 19456, 52224, 19456,
    52224, 19456, 19456, 19456,  3072,  3072,  3072, 35840, 19456, 52224,
    52224, 19456, 52224, 19456, 52224, 19456, 52224, 19456, 19456, 19456,
     3072,  3072,  1024, 33792, 17408, 50176, 50176, 17408, 50176, 17408,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,  2048, 34816,
    18432, 51200, 51200, 18432, 51200, 18432, 51200, 18432, 51200, 18432,
    18432, 18432,  2048,  2048,     0, 32768, 16384, 49152, 49152, 16384,
    49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
     3072, 35840, 19456, 52224, 52224, 19456, 52224, 19456, 52224, 19456,
    52224, 19456, 19456, 19456,  3072,  3072,  1024, 33792, 17408, 50176,
    50176, 17408, 50176, 17408, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024,  2048, 34816, 18432, 51200, 51200, 18432, 51200, 18432,
    51200, 18432, 51200, 18432, 18432, 18432,  2048,  2048,     0, 32768,
    16384, 49152, 49152, 16384, 49152, 16384, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0,     0, 32768, 16384, 49152, 49152, 16384,
    49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
        0, 32768, 16384, 49152, 49152, 16384, 49152, 16384, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0,     0, 32768, 16384, 49152,
    49152, 16384, 49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0,     0, 32768, 16384, 49152, 49152, 16384, 49152, 16384,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0,     0, 32768,
    16384, 49152, 49152, 16384, 49152, 16384, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0,  2048, 34816, 18432, 51200, 51200, 18432,
    51200, 18432, 51200, 18432, 51200, 18432, 18432, 18432,  2048,  2048,
     1024, 33792, 17408, 50176, 50176, 17408, 50176, 17408, 50176, 17408,
    50176, 17408, 17408, 17408,  1024,  1024,  3072, 35840, 19456, 52224,
    52224, 19456, 52224, 19456, 52224, 19456, 52224, 19456, 19456, 19456,
     3072,  3072,  3072, 35840, 19456, 52224, 52224, 19456, 52224, 19456,
    52224, 19456, 52224, 19456, 19456, 19456,  3072,  3072,  1024, 33792,
    17408, 50176, 50176, 17408, 50176, 17408, 50176, 17408, 50176, 17408,
    17408, 17408,  1024,  1024,  3072, 35840, 19456, 52224, 52224, 19456,
    52224, 19456, 52224, 19456, 52224, 19456, 19456, 19456,  3072,  3072,
     1024, 33792, 17408, 50176, 50176, 17408, 50176, 17408, 50176, 17408,
    50176, 17408, 17408, 17408,  1024,  1024,  3072, 35840, 19456, 52224,
    52224, 19456, 52224, 19456, 52224, 19456, 52224, 19456, 19456, 19456,
     3072,  3072,  1024, 33792, 17408, 50176, 50176, 17408, 50176, 17408,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,  3072, 35840,
    19456, 52224, 52224, 19456, 52224, 19456, 52224, 19456, 52224, 19456,
    19456, 19456,  3072,  3072,  1024, 33792, 17408, 50176, 50176, 17408,
    50176, 17408, 50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,
     1024, 33792, 17408, 50176, 50176, 17408, 50176, 17408, 50176, 17408,
    50176, 17408, 17408, 17408,  1024,  1024,  1024, 33792, 17408, 50176,
    50176, 17408, 50176, 17408, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024,     0, 32768, 16384, 49152, 49152, 16384, 49152, 16384,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0,     0, 32768,
    16384, 49152, 49152, 16384, 49152, 16384, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 34816,  2048, 51200, 18432, 18432, 18432,
    18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432,  2048,  2048,
    32768,     0, 49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 35840,  3072, 52224, 19456,
    19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456,
     3072,  3072, 33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 33792,  1024,
    50176, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
    33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408,  1024,  1024, 33792,  1024, 50176, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
     1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 33792,  1024,
    50176, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
    33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408,  1024,  1024, 33792,  1024, 50176, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
     1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 32768,     0,
    49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 32768,     0, 49152, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    17408, 50176, 17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024, 19456, 52224, 19456, 52224,
    52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072, 17408, 50176, 17408, 50176, 50176, 17408, 33792,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024, 19456, 52224,
    19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072, 19456, 52224, 19456, 52224, 52224, 19456,
    35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
    17408, 50176, 17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024, 18432, 51200, 18432, 51200,
    51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048, 16384, 49152, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 19456, 52224,
    19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072, 17408, 50176, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
    18432, 51200, 18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048, 16384, 49152, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 16384, 49152, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 16384, 49152,
    16384, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 16384, 49152, 16384, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    16384, 49152, 16384, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 52224, 19456, 52224, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 52224, 19456,
    52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,
     3072,  3072,  3072,  3072, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 50176, 17408, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0, 32768, 16384, 49152, 49152, 16384, 49152, 16384,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0,  2048, 34816,
    18432, 51200, 51200, 18432, 51200, 18432, 51200, 18432, 51200, 18432,
    18432, 18432,  2048,  2048,  1024, 33792, 17408, 50176, 50176, 17408,
    50176, 17408, 50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,
     3072, 35840, 19456, 52224, 52224, 19456, 52224, 19456, 52224, 19456,
    52224, 19456, 19456, 19456,  3072,  3072,  3072, 35840, 19456, 52224,
    52224, 19456, 52224, 19456, 52224, 19456, 52224, 19456, 19456, 19456,
     3072,  3072,  3072, 35840, 19456, 52224, 52224, 19456, 52224, 19456,
    52224, 19456, 52224, 19456, 19456, 19456,  3072,  3072,  2048, 34816,
    18432, 51200, 51200, 18432, 51200, 18432, 51200, 18432, 51200, 18432,
    18432, 18432,  2048,  2048,  2048, 34816, 18432, 51200, 51200, 18432,
    51200, 18432, 51200, 18432, 51200, 18432, 18432, 18432,  2048,  2048,
     3072, 35840, 19456, 52224, 52224, 19456, 52224, 19456, 52224, 19456,
    52224, 19456, 19456, 19456,  3072,  3072,  3072, 35840, 19456, 52224,
    52224, 19456, 52224, 19456, 52224, 19456, 52224, 19456, 19456, 19456,
     3072,  3072,  2048, 34816, 18432, 51200, 51200, 18432, 51200, 18432,
    51200, 18432, 51200, 18432, 18432, 18432,  2048,  2048,  2048, 34816,
    18432, 51200, 51200, 18432, 51200, 18432, 51200, 18432, 51200, 18432,
    18432, 18432,  2048,  2048,  2048, 34816, 18432, 51200, 51200, 18432,
    51200, 18432, 51200, 18432, 51200, 18432, 18432, 18432,  2048,  2048,
        0, 32768, 16384, 49152, 49152, 16384, 49152, 16384, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0,  2048, 34816, 18432, 51200,
    51200, 18432, 51200, 18432, 51200, 18432, 51200, 18432, 18432, 18432,
     2048,  2048,     0, 32768, 16384, 49152, 49152, 16384, 49152, 16384,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 34816,  2048,
    51200, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432,
    18432, 18432,  2048,  2048, 34816,  2048, 51200, 18432, 18432, 18432,
    18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432,  2048,  2048,
    35840,  3072, 52224, 19456, 19456, 19456, 19456, 19456, 19456, 19456,
    19456, 19456, 19456, 19456,  3072,  3072, 35840,  3072, 52224, 19456,
    19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456,
     3072,  3072, 35840,  3072, 52224, 19456, 19456, 19456, 19456, 19456,
    19456, 19456, 19456, 19456, 19456, 19456,  3072,  3072, 33792,  1024,
    50176, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 34816,  2048, 51200, 18432, 18432, 18432,
    18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432,  2048,  2048,
    32768,     0, 49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 35840,  3072, 52224, 19456,
    19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456,
     3072,  3072, 33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 34816,  2048,
    51200, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432,
    18432, 18432,  2048,  2048, 32768,     0, 49152, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    32768,     0, 49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 32768,     0, 49152, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 32768,     0, 49152, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 32768,     0,
    49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 17408, 50176, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
    19456, 52224, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072, 16384, 49152, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 18432, 51200, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048, 18432, 51200, 18432, 51200, 51200, 18432,
    34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,
    18432, 51200, 18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200, 18432, 51200,
    51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048, 18432, 51200, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048, 18432, 51200, 18432, 51200, 51200, 18432,
    34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,
    18432, 51200, 18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200, 18432, 51200,
    51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048, 16384, 49152, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 18432, 51200,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048, 16384, 49152, 16384, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    52224, 19456, 52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,
     3072,  3072,  3072,  3072,  3072,  3072, 52224, 19456, 52224, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 51200, 18432, 51200, 18432, 18432, 18432,  2048,  2048,
    18432, 18432,  2048,  2048,  2048,  2048,  2048,  2048, 51200, 18432,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 51200, 18432, 51200, 18432, 18432, 18432,
     2048,  2048, 18432, 18432,  2048,  2048,  2048,  2048,  2048,  2048,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 51200, 18432, 51200, 18432,
    18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,  2048,  2048,
     2048,  2048, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 51200, 18432,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    51200, 18432, 51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,
     2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 52224, 19456, 52224, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 52224, 19456, 52224, 19456, 19456, 19456,  3072,  3072,
    19456, 19456,  3072,  3072,  3072,  3072,  3072,  3072, 52224, 19456,
    52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,
     3072,  3072,  3072,  3072, 52224, 19456, 52224, 19456, 19456, 19456,
     3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,  3072,  3072,
    52224, 19456, 52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,
     3072,  3072,  3072,  3072,  3072,  3072, 50176, 17408, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 51200, 18432, 51200, 18432, 18432, 18432,  2048,  2048,
    18432, 18432,  2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 52224, 19456, 52224, 19456, 19456, 19456,
     3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,  3072,  3072,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 51200, 18432, 51200, 18432,
    18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,  2048,  2048,
     2048,  2048, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 19456, 19456, 19456, 19456, 19456, 19456,  3072,  3072,
    19456, 19456,  3072,  3072,  3072,  3072,  3072,  3072, 17408, 17408,
    17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 19456, 19456, 19456, 19456, 19456, 19456,
     3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,  3072,  3072,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0, 32768,     0, 32768, 32768,     0, 49152, 16384, 32768,     0,
    49152, 16384, 16384, 16384, 16384, 16384,  2048, 34816,  2048, 34816,
    34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432, 18432, 18432,
    18432, 18432,     0, 32768,     0, 32768, 32768,     0, 49152, 16384,
    32768,     0, 49152, 16384, 16384, 16384, 16384, 16384,  2048, 34816,
     2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432,
    18432, 18432, 18432, 18432,  2048, 34816,  2048, 34816, 34816,  2048,
    51200, 18432, 34816,  2048, 51200, 18432, 18432, 18432, 18432, 18432,
        0, 32768,     0, 32768, 32768,     0, 49152, 16384, 32768,     0,
    49152, 16384, 16384, 16384, 16384, 16384,  3072, 35840,  3072, 35840,
    35840,  3072, 52224, 19456, 35840,  3072, 52224, 19456, 19456, 19456,
    19456, 19456,  1024, 33792,  1024, 33792, 33792,  1024, 50176, 17408,
    33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408,  2048, 34816,
     2048, 34816, 34816,  2048, 51200, 18432, 34816,  2048, 51200, 18432,
    18432, 18432, 18432, 18432,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384, 16384, 16384,
     3072, 35840,  3072, 35840, 35840,  3072, 52224, 19456, 35840,  3072,
    52224, 19456, 19456, 19456, 19456, 19456,  1024, 33792,  1024, 33792,
    33792,  1024, 50176, 17408, 33792,  1024, 50176, 17408, 17408, 17408,
    17408, 17408,  1024, 33792,  1024, 33792, 33792,  1024, 50176, 17408,
    33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408,  1024, 33792,
     1024, 33792, 33792,  1024, 50176, 17408, 33792,  1024, 50176, 17408,
    17408, 17408, 17408, 17408,     0, 32768,     0, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384, 16384, 16384,
        0, 32768,     0, 32768, 32768,     0, 49152, 16384, 32768,     0,
    49152, 16384, 16384, 16384, 16384, 16384, 34816,  2048, 34816,  2048,
     2048,  2048, 18432, 18432,  2048,  2048, 18432, 18432, 18432, 18432,
    18432, 18432, 32768,     0, 32768,     0,     0,     0, 16384, 16384,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384, 34816,  2048,
    34816,  2048,  2048,  2048, 18432, 18432,  2048,  2048, 18432, 18432,
    18432, 18432, 18432, 18432, 32768,     0, 32768,     0,     0,     0,
    16384, 16384,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
    32768,     0, 32768,     0,     0,     0, 16384, 16384,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384, 32768,     0, 32768,     0,
        0,     0, 16384, 16384,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384, 33792,  1024, 33792,  1024,  1024,  1024, 17408, 17408,
     1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408, 33792,  1024,
    33792,  1024,  1024,  1024, 17408, 17408,  1024,  1024, 17408, 17408,
    17408, 17408, 17408, 17408, 32768,     0, 32768,     0,     0,     0,
    16384, 16384,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
    32768,     0, 32768,     0,     0,     0, 16384, 16384,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384, 33792,  1024, 33792,  1024,
     1024,  1024, 17408, 17408,  1024,  1024, 17408, 17408, 17408, 17408,
    17408, 17408, 33792,  1024, 33792,  1024,  1024,  1024, 17408, 17408,
     1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408, 33792,  1024,
    33792,  1024,  1024,  1024, 17408, 17408,  1024,  1024, 17408, 17408,
    17408, 17408, 17408, 17408, 33792,  1024, 33792,  1024,  1024,  1024,
    17408, 17408,  1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408,
    32768,     0, 32768,     0,     0,     0, 16384, 16384,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384, 32768,     0, 32768,     0,
        0,     0, 16384, 16384,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384,     0, 32768, 16384, 49152, 49152, 16384, 49152, 16384,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0,  2048, 34816,
    18432, 51200, 51200, 18432, 51200, 18432, 51200, 18432, 51200, 18432,
    18432, 18432,  2048,  2048,  1024, 33792, 17408, 50176, 50176, 17408,
    50176, 17408, 50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,
     3072, 35840, 19456, 52224, 52224, 19456, 52224, 19456, 52224, 19456,
    52224, 19456, 19456, 19456,  3072,  3072,  3072, 35840, 19456, 52224,
    52224, 19456, 52224, 19456, 52224, 19456, 52224, 19456, 19456, 19456,
     3072,  3072,  1024, 33792, 17408, 50176, 50176, 17408, 50176, 17408,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,  2048, 34816,
    18432, 51200, 51200, 18432, 51200, 18432, 51200, 18432, 51200, 18432,
    18432, 18432,  2048,  2048,     0, 32768, 16384, 49152, 49152, 16384,
    49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
     3072, 35840, 19456, 52224, 52224, 19456, 52224, 19456, 52224, 19456,
    52224, 19456, 19456, 19456,  3072,  3072,  1024, 33792, 17408, 50176,
    50176, 17408, 50176, 17408, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024,  2048, 34816, 18432, 51200, 51200, 18432, 51200, 18432,
    51200, 18432, 51200, 18432, 18432, 18432,  2048,  2048,     0, 32768,
    16384, 49152, 49152, 16384, 49152, 16384, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0,     0, 32768, 16384, 49152, 49152, 16384,
    49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
        0, 32768, 16384, 49152, 49152, 16384, 49152, 16384, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0,     0, 32768, 16384, 49152,
    49152, 16384, 49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0,     0, 32768, 16384, 49152, 49152, 16384, 49152, 16384,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 34816,  2048,
    51200, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432,
    18432, 18432,  2048,  2048, 32768,     0, 49152, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    35840,  3072, 52224, 19456, 19456, 19456, 19456, 19456, 19456, 19456,
    19456, 19456, 19456, 19456,  3072,  3072, 33792,  1024, 50176, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
     1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 33792,  1024,
    50176, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 32768,     0, 49152, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    32768,     0, 49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 33792,  1024, 50176, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
     1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 32768,     0,
    49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 32768,     0, 49152, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    32768,     0, 49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 32768,     0, 49152, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 32768,     0, 49152, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 32768,     0,
    49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 34816,  2048, 51200, 18432, 18432, 18432,
    18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432,  2048,  2048,
    32768,     0, 49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 35840,  3072, 52224, 19456,
    19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456,
     3072,  3072, 33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 33792,  1024,
    50176, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
    33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408,  1024,  1024, 33792,  1024, 50176, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
     1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 33792,  1024,
    50176, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
    33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408,  1024,  1024, 33792,  1024, 50176, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
     1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 32768,     0,
    49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 32768,     0, 49152, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0,     0,     0, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0,  1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,  1024,  1024,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
     1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408,  1024,  1024,  1024,  1024, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
     1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,  1024,  1024,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
     1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408,  1024,  1024,  1024,  1024, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
     1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,  1024,  1024,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 52224, 19456, 52224, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 52224, 19456,
    52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,
     3072,  3072,  3072,  3072, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 50176, 17408, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,
    17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 34816,  2048,
    51200, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432,
    18432, 18432,  2048,  2048, 34816,  2048, 51200, 18432, 18432, 18432,
    18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432,  2048,  2048,
    35840,  3072, 52224, 19456, 19456, 19456, 19456, 19456, 19456, 19456,
    19456, 19456, 19456, 19456,  3072,  3072, 35840,  3072, 52224, 19456,
    19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456,
     3072,  3072, 35840,  3072, 52224, 19456, 19456, 19456, 19456, 19456,
    19456, 19456, 19456, 19456, 19456, 19456,  3072,  3072, 33792,  1024,
    50176, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 34816,  2048, 51200, 18432, 18432, 18432,
    18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432,  2048,  2048,
    32768,     0, 49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 35840,  3072, 52224, 19456,
    19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456,
     3072,  3072, 33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 34816,  2048,
    51200, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432,
    18432, 18432,  2048,  2048, 32768,     0, 49152, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    32768,     0, 49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 32768,     0, 49152, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 32768,     0, 49152, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 32768,     0,
    49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0,  2048,  2048, 18432, 18432, 18432, 18432,
    18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432,  2048,  2048,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0,  3072,  3072, 19456, 19456,
    19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456, 19456,
     3072,  3072,  1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,  1024,  1024,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0,     0,     0, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0,  1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,  1024,  1024,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0,     0,     0, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    52224, 19456, 52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,
     3072,  3072,  3072,  3072,  3072,  3072, 52224, 19456, 52224, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 51200, 18432, 51200, 18432, 18432, 18432,  2048,  2048,
    18432, 18432,  2048,  2048,  2048,  2048,  2048,  2048, 51200, 18432,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 51200, 18432, 51200, 18432, 18432, 18432,
     2048,  2048, 18432, 18432,  2048,  2048,  2048,  2048,  2048,  2048,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 51200, 18432, 51200, 18432,
    18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,  2048,  2048,
     2048,  2048, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 51200, 18432,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    51200, 18432, 51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,
     2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 19456, 19456, 19456, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 18432, 18432,
    18432, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 19456, 19456, 19456, 19456, 19456, 19456,  3072,  3072,
    19456, 19456,  3072,  3072,  3072,  3072,  3072,  3072, 17408, 17408,
    17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 19456, 19456, 19456, 19456, 19456, 19456,
     3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,  3072,  3072,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 17408, 17408,
    17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,
    17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
    16384, 49152, 16384, 49152, 16384, 49152, 16384, 49152, 49152, 16384,
    32768,     0,     0,     0, 16384, 16384, 16384, 49152, 16384, 49152,
    16384, 49152, 16384, 49152, 49152, 16384, 32768,     0,  1024,  1024,
    17408, 17408, 17408, 50176, 17408, 50176, 17408, 50176, 17408, 50176,
    50176, 17408, 33792,  1024,  1024,  1024, 17408, 17408, 17408, 50176,
    17408, 50176, 17408, 50176, 17408, 50176, 50176, 17408, 33792,  1024,
     1024,  1024, 17408, 17408, 17408, 50176, 17408, 50176, 17408, 50176,
    17408, 50176, 50176, 17408, 33792,  1024,  3072,  3072, 19456, 19456,
    19456, 52224, 19456, 52224, 19456, 52224, 19456, 52224, 52224, 19456,
    35840,  3072,     0,     0, 16384, 16384, 16384, 49152, 16384, 49152,
    16384, 49152, 16384, 49152, 49152, 16384, 32768,     0,  2048,  2048,
    18432, 18432, 18432, 51200, 18432, 51200, 18432, 51200, 18432, 51200,
    51200, 18432, 34816,  2048,  1024,  1024, 17408, 17408, 17408, 50176,
    17408, 50176, 17408, 50176, 17408, 50176, 50176, 17408, 33792,  1024,
     3072,  3072, 19456, 19456, 19456, 52224, 19456, 52224, 19456, 52224,
    19456, 52224, 52224, 19456, 35840,  3072,     0,     0, 16384, 16384,
    16384, 49152, 16384, 49152, 16384, 49152, 16384, 49152, 49152, 16384,
    32768,     0,  2048,  2048, 18432, 18432, 18432, 51200, 18432, 51200,
    18432, 51200, 18432, 51200, 51200, 18432, 34816,  2048,  2048,  2048,
    18432, 18432, 18432, 51200, 18432, 51200, 18432, 51200, 18432, 51200,
    51200, 18432, 34816,  2048,     0,     0, 16384, 16384, 16384, 49152,
    16384, 49152, 16384, 49152, 16384, 49152, 49152, 16384, 32768,     0,
     2048,  2048, 18432, 18432, 18432, 51200, 18432, 51200, 18432, 51200,
    18432, 51200, 51200, 18432, 34816,  2048,     0,     0, 16384, 16384,
    16384, 49152, 16384, 49152, 16384, 49152, 16384, 49152, 49152, 16384,
    32768,     0,     0, 32768, 16384, 49152, 49152, 16384, 49152, 16384,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0,  2048, 34816,
    18432, 51200, 51200, 18432, 51200, 18432, 51200, 18432, 51200, 18432,
    18432, 18432,  2048,  2048,  1024, 33792, 17408, 50176, 50176, 17408,
    50176, 17408, 50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,
     3072, 35840, 19456, 52224, 52224, 19456, 52224, 19456, 52224, 19456,
    52224, 19456, 19456, 19456,  3072,  3072,  3072, 35840, 19456, 52224,
    52224, 19456, 52224, 19456, 52224, 19456, 52224, 19456, 19456, 19456,
     3072,  3072,  1024, 33792, 17408, 50176, 50176, 17408, 50176, 17408,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,  2048, 34816,
    18432, 51200, 51200, 18432, 51200, 18432, 51200, 18432, 51200, 18432,
    18432, 18432,  2048,  2048,     0, 32768, 16384, 49152, 49152, 16384,
    49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
     3072, 35840, 19456, 52224, 52224, 19456, 52224, 19456, 52224, 19456,
    52224, 19456, 19456, 19456,  3072,  3072,  1024, 33792, 17408, 50176,
    50176, 17408, 50176, 17408, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024,  2048, 34816, 18432, 51200, 51200, 18432, 51200, 18432,
    51200, 18432, 51200, 18432, 18432, 18432,  2048,  2048,     0, 32768,
    16384, 49152, 49152, 16384, 49152, 16384, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0,     0, 32768, 16384, 49152, 49152, 16384,
    49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
        0, 32768, 16384, 49152, 49152, 16384, 49152, 16384, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0,     0, 32768, 16384, 49152,
    49152, 16384, 49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0,     0, 32768, 16384, 49152, 49152, 16384, 49152, 16384,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 17408, 17408,
    17408, 17408, 17408, 50176,  1024, 33792, 17408, 50176,  1024, 33792,
    33792,  1024, 33792,  1024, 17408, 17408, 17408, 17408, 17408, 50176,
     1024, 33792, 17408, 50176,  1024, 33792, 33792,  1024, 33792,  1024,
    16384, 16384, 16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,
        0, 32768, 32768,     0, 32768,     0, 16384, 16384, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0, 16384, 16384, 16384, 16384, 16384, 49152,     0, 32768,
    16384, 49152,     0, 32768, 32768,     0, 32768,     0, 18432, 18432,
    18432, 18432, 18432, 51200,  2048, 34816, 18432, 51200,  2048, 34816,
    34816,  2048, 34816,  2048, 16384, 16384, 16384, 16384, 16384, 49152,
        0, 32768, 16384, 49152,     0, 32768, 32768,     0, 32768,     0,
    18432, 18432, 18432, 18432, 18432, 51200,  2048, 34816, 18432, 51200,
     2048, 34816, 34816,  2048, 34816,  2048, 16384, 16384, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0, 18432, 18432, 18432, 18432, 18432, 51200,  2048, 34816,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048, 16384, 16384,
    16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,     0, 32768,
    32768,     0, 32768,     0, 18432, 18432, 18432, 18432, 18432, 51200,
     2048, 34816, 18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,
    18432, 18432, 18432, 18432, 18432, 51200,  2048, 34816, 18432, 51200,
     2048, 34816, 34816,  2048, 34816,  2048, 16384, 16384, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0, 18432, 18432, 18432, 18432, 18432, 51200,  2048, 34816,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048, 16384, 16384,
    16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,     0, 32768,
    32768,     0, 32768,     0, 17408, 50176, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
    19456, 52224, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072, 16384, 49152, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 18432, 51200, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048, 16384, 49152, 16384, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    18432, 51200, 18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048, 16384, 49152, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 18432, 51200, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 16384, 49152,
    16384, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 18432, 51200, 18432, 51200, 51200, 18432,
    34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,
    16384, 49152, 16384, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 16384, 49152, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 16384, 49152, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 16384, 49152,
    16384, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 16384, 49152, 16384, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    17408, 50176, 17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024, 19456, 52224, 19456, 52224,
    52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072, 17408, 50176, 17408, 50176, 50176, 17408, 33792,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024, 19456, 52224,
    19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072, 19456, 52224, 19456, 52224, 52224, 19456,
    35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
    17408, 50176, 17408, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024, 18432, 51200, 18432, 51200,
    51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048, 16384, 49152, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 19456, 52224,
    19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072, 17408, 50176, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
    18432, 51200, 18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048, 16384, 49152, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 16384, 49152, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 16384, 49152,
    16384, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 16384, 49152, 16384, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    16384, 49152, 16384, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 52224, 19456, 52224, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 52224, 19456,
    52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,
     3072,  3072,  3072,  3072, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 50176, 17408, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 17408, 50176,  1024, 33792, 33792,  1024, 33792,  1024,
    33792,  1024, 33792,  1024,  1024,  1024,  1024,  1024, 19456, 52224,
     3072, 35840, 35840,  3072, 35840,  3072, 35840,  3072, 35840,  3072,
     3072,  3072,  3072,  3072, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,  2048, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 16384, 49152,     0, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 18432, 51200,
     2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 16384, 49152,     0, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 16384, 49152,
        0, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    16384, 49152,     0, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 16384, 49152,     0, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 16384, 49152,     0, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 17408, 50176, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
    19456, 52224, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072, 16384, 49152, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 18432, 51200, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048, 18432, 51200, 18432, 51200, 51200, 18432,
    34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,
    18432, 51200, 18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200, 18432, 51200,
    51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048, 18432, 51200, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048, 18432, 51200, 18432, 51200, 51200, 18432,
    34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,
    18432, 51200, 18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200, 18432, 51200,
    51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048, 16384, 49152, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 18432, 51200,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048, 16384, 49152, 16384, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    52224, 19456, 52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,
     3072,  3072,  3072,  3072,  3072,  3072, 52224, 19456, 52224, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 51200, 18432, 51200, 18432, 18432, 18432,  2048,  2048,
    18432, 18432,  2048,  2048,  2048,  2048,  2048,  2048, 51200, 18432,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 51200, 18432, 51200, 18432, 18432, 18432,
     2048,  2048, 18432, 18432,  2048,  2048,  2048,  2048,  2048,  2048,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 51200, 18432, 51200, 18432,
    18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,  2048,  2048,
     2048,  2048, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 51200, 18432,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    51200, 18432, 51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,
     2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 16384, 49152,     0, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 16384, 49152,
        0, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 18432, 51200,  2048, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,  2048, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,
     2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 18432, 51200,  2048, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,  2048, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,
     2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 16384, 49152,     0, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    18432, 51200,  2048, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 16384, 49152,     0, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0, 32768, 16384, 49152, 49152, 16384, 49152, 16384,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0,  2048, 34816,
    18432, 51200, 51200, 18432, 51200, 18432, 51200, 18432, 51200, 18432,
    18432, 18432,  2048,  2048,  1024, 33792, 17408, 50176, 50176, 17408,
    50176, 17408, 50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,
     3072, 35840, 19456, 52224, 52224, 19456, 52224, 19456, 52224, 19456,
    52224, 19456, 19456, 19456,  3072,  3072,  3072, 35840, 19456, 52224,
    52224, 19456, 52224, 19456, 52224, 19456, 52224, 19456, 19456, 19456,
     3072,  3072,  1024, 33792, 17408, 50176, 50176, 17408, 50176, 17408,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,  2048, 34816,
    18432, 51200, 51200, 18432, 51200, 18432, 51200, 18432, 51200, 18432,
    18432, 18432,  2048,  2048,     0, 32768, 16384, 49152, 49152, 16384,
    49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
     3072, 35840, 19456, 52224, 52224, 19456, 52224, 19456, 52224, 19456,
    52224, 19456, 19456, 19456,  3072,  3072,  1024, 33792, 17408, 50176,
    50176, 17408, 50176, 17408, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024,  2048, 34816, 18432, 51200, 51200, 18432, 51200, 18432,
    51200, 18432, 51200, 18432, 18432, 18432,  2048,  2048,     0, 32768,
    16384, 49152, 49152, 16384, 49152, 16384, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0,     0, 32768, 16384, 49152, 49152, 16384,
    49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
        0, 32768, 16384, 49152, 49152, 16384, 49152, 16384, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0,     0, 32768, 16384, 49152,
    49152, 16384, 49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0,     0, 32768, 16384, 49152, 49152, 16384, 49152, 16384,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 34816,  2048,
    51200, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432, 18432,
    18432, 18432,  2048,  2048, 32768,     0, 49152, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    35840,  3072, 52224, 19456, 19456, 19456, 19456, 19456, 19456, 19456,
    19456, 19456, 19456, 19456,  3072,  3072, 33792,  1024, 50176, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
     1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 33792,  1024,
    50176, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 32768,     0, 49152, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    32768,     0, 49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 33792,  1024, 50176, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
     1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 32768,     0,
    49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 32768,     0, 49152, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    32768,     0, 49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 32768,     0, 49152, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 32768,     0, 49152, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 32768,     0,
    49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 17408, 50176, 17408, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
    19456, 52224, 19456, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072, 16384, 49152, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 18432, 51200, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 18432, 51200,
    18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048, 16384, 49152, 16384, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    18432, 51200, 18432, 51200, 51200, 18432, 34816,  2048, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048, 16384, 49152, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 18432, 51200, 18432, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 16384, 49152,
    16384, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 18432, 51200, 18432, 51200, 51200, 18432,
    34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,
    16384, 49152, 16384, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 16384, 49152, 16384, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 16384, 49152, 16384, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 16384, 49152,
    16384, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 16384, 49152, 16384, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    52224, 19456, 52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,
     3072,  3072,  3072,  3072,  3072,  3072, 50176, 17408, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 51200, 18432, 51200, 18432, 18432, 18432,  2048,  2048,
    18432, 18432,  2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 52224, 19456, 52224, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 52224, 19456,
    52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,
     3072,  3072,  3072,  3072, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 50176, 17408, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,
    17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    52224, 19456, 52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,
     3072,  3072,  3072,  3072,  3072,  3072, 52224, 19456, 52224, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 51200, 18432, 51200, 18432, 18432, 18432,  2048,  2048,
    18432, 18432,  2048,  2048,  2048,  2048,  2048,  2048, 51200, 18432,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 51200, 18432, 51200, 18432, 18432, 18432,
     2048,  2048, 18432, 18432,  2048,  2048,  2048,  2048,  2048,  2048,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 51200, 18432, 51200, 18432,
    18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,  2048,  2048,
     2048,  2048, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 51200, 18432,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    51200, 18432, 51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,
     2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 19456, 19456, 19456, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 18432, 18432,
    18432, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 18432, 18432,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    18432, 18432,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0, 32768, 16384, 49152,     0, 32768, 16384, 49152,
    49152, 49152, 32768, 32768,     0,     0,     0,     0,     0, 32768,
    16384, 49152,     0, 32768, 16384, 49152, 49152, 49152, 32768, 32768,
        0,     0,     0,     0,     0, 32768, 16384, 49152,     0, 32768,
    16384, 49152, 49152, 49152, 32768, 32768,     0,     0,     0,     0,
        0, 32768, 16384, 49152,     0, 32768, 16384, 49152, 49152, 49152,
    32768, 32768,     0,     0,     0,     0,     0, 32768, 16384, 49152,
        0, 32768, 16384, 49152, 49152, 49152, 32768, 32768,  2048,  2048,
     2048,  2048,  2048, 34816, 18432, 51200,  2048, 34816, 18432, 51200,
    51200, 51200, 34816, 34816,  1024,  1024,  1024,  1024,  1024, 33792,
    17408, 50176,  1024, 33792, 17408, 50176, 50176, 50176, 33792, 33792,
     3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,  3072, 35840,
    19456, 52224, 52224, 52224, 35840, 35840,     0,     0,     0,     0,
        0, 32768, 16384, 49152,     0, 32768, 16384, 49152, 49152, 49152,
    32768, 32768,  2048,  2048,  2048,  2048,  2048, 34816, 18432, 51200,
     2048, 34816, 18432, 51200, 51200, 51200, 34816, 34816,  1024,  1024,
     1024,  1024,  1024, 33792, 17408, 50176,  1024, 33792, 17408, 50176,
    50176, 50176, 33792, 33792,  3072,  3072,  3072,  3072,  3072, 35840,
    19456, 52224,  3072, 35840, 19456, 52224, 52224, 52224, 35840, 35840,
     3072,  3072,  3072,  3072,  3072, 35840, 19456, 52224,  3072, 35840,
    19456, 52224, 52224, 52224, 35840, 35840,  1024,  1024,  1024,  1024,
     1024, 33792, 17408, 50176,  1024, 33792, 17408, 50176, 50176, 50176,
    33792, 33792,  2048,  2048,  2048,  2048,  2048, 34816, 18432, 51200,
     2048, 34816, 18432, 51200, 51200, 51200, 34816, 34816,     0,     0,
        0,     0,     0, 32768, 16384, 49152,     0, 32768, 16384, 49152,
    49152, 49152, 32768, 32768,     0, 32768,     0, 32768, 32768, 32768,
    49152, 49152, 32768, 32768, 49152, 49152, 49152, 16384, 32768,     0,
     2048, 34816,  2048, 34816, 34816, 34816, 51200, 51200, 34816, 34816,
    51200, 51200, 51200, 18432, 34816,  2048,     0, 32768,     0, 32768,
    32768, 32768, 49152, 49152, 32768, 32768, 49152, 49152, 49152, 16384,
    32768,     0,  2048, 34816,  2048, 34816, 34816, 34816, 51200, 51200,
    34816, 34816, 51200, 51200, 51200, 18432, 34816,  2048,  2048, 34816,
     2048, 34816, 34816, 34816, 51200, 51200, 34816, 34816, 51200, 51200,
    51200, 18432, 34816,  2048,     0, 32768,     0, 32768, 32768, 32768,
    49152, 49152, 32768, 32768, 49152, 49152, 49152, 16384, 32768,     0,
     3072, 35840,  3072, 35840, 35840, 35840, 52224, 52224, 35840, 35840,
    52224, 52224, 52224, 19456, 35840,  3072,  1024, 33792,  1024, 33792,
    33792, 33792, 50176, 50176, 33792, 33792, 50176, 50176, 50176, 17408,
    33792,  1024,  2048, 34816,  2048, 34816, 34816, 34816, 51200, 51200,
    34816, 34816, 51200, 51200, 51200, 18432, 34816,  2048,     0, 32768,
        0, 32768, 32768, 32768, 49152, 49152, 32768, 32768, 49152, 49152,
    49152, 16384, 32768,     0,  3072, 35840,  3072, 35840, 35840, 35840,
    52224, 52224, 35840, 35840, 52224, 52224, 52224, 19456, 35840,  3072,
     1024, 33792,  1024, 33792, 33792, 33792, 50176, 50176, 33792, 33792,
    50176, 50176, 50176, 17408, 33792,  1024,  1024, 33792,  1024, 33792,
    33792, 33792, 50176, 50176, 33792, 33792, 50176, 50176, 50176, 17408,
    33792,  1024,  1024, 33792,  1024, 33792, 33792, 33792, 50176, 50176,
    33792, 33792, 50176, 50176, 50176, 17408, 33792,  1024,     0, 32768,
        0, 32768, 32768, 32768, 49152, 49152, 32768, 32768, 49152, 49152,
    49152, 16384, 32768,     0,     0, 32768,     0, 32768, 32768, 32768,
    49152, 49152, 32768, 32768, 49152, 49152, 49152, 16384, 32768,     0,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,
        0, 32768, 32768, 32768, 32768, 32768,     0,     0, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768, 32768,
    32768, 32768,  1024,  1024, 17408, 17408, 17408, 50176,  1024, 33792,
    17408, 50176,  1024, 33792, 33792, 33792, 33792, 33792,  1024,  1024,
    17408, 17408, 17408, 50176,  1024, 33792, 17408, 50176,  1024, 33792,
    33792, 33792, 33792, 33792,  1024,  1024, 17408, 17408, 17408, 50176,
     1024, 33792, 17408, 50176,  1024, 33792, 33792, 33792, 33792, 33792,
     3072,  3072, 19456, 19456, 19456, 52224,  3072, 35840, 19456, 52224,
     3072, 35840, 35840, 35840, 35840, 35840,     0,     0, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768, 32768,
    32768, 32768,  2048,  2048, 18432, 18432, 18432, 51200,  2048, 34816,
    18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816,  1024,  1024,
    17408, 17408, 17408, 50176,  1024, 33792, 17408, 50176,  1024, 33792,
    33792, 33792, 33792, 33792,  3072,  3072, 19456, 19456, 19456, 52224,
     3072, 35840, 19456, 52224,  3072, 35840, 35840, 35840, 35840, 35840,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,
        0, 32768, 32768, 32768, 32768, 32768,  2048,  2048, 18432, 18432,
    18432, 51200,  2048, 34816, 18432, 51200,  2048, 34816, 34816, 34816,
    34816, 34816,  2048,  2048, 18432, 18432, 18432, 51200,  2048, 34816,
    18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816,     0,     0,
    16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,     0, 32768,
    32768, 32768, 32768, 32768,  2048,  2048, 18432, 18432, 18432, 51200,
     2048, 34816, 18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,
        0, 32768, 32768, 32768, 32768, 32768,     0, 32768, 16384, 49152,
    49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0,  2048, 34816, 18432, 51200, 51200, 51200, 34816, 34816,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,  1024, 33792,
    17408, 50176, 50176, 50176, 33792, 33792, 50176, 50176, 33792, 33792,
    33792,  1024, 33792,  1024,  3072, 35840, 19456, 52224, 52224, 52224,
    35840, 35840, 52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072,
     3072, 35840, 19456, 52224, 52224, 52224, 35840, 35840, 52224, 52224,
    35840, 35840, 35840,  3072, 35840,  3072,  1024, 33792, 17408, 50176,
    50176, 50176, 33792, 33792, 50176, 50176, 33792, 33792, 33792,  1024,
    33792,  1024,  2048, 34816, 18432, 51200, 51200, 51200, 34816, 34816,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,     0, 32768,
    16384, 49152, 49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0,  3072, 35840, 19456, 52224, 52224, 52224,
    35840, 35840, 52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072,
     1024, 33792, 17408, 50176, 50176, 50176, 33792, 33792, 50176, 50176,
    33792, 33792, 33792,  1024, 33792,  1024,  2048, 34816, 18432, 51200,
    51200, 51200, 34816, 34816, 51200, 51200, 34816, 34816, 34816,  2048,
    34816,  2048,     0, 32768, 16384, 49152, 49152, 49152, 32768, 32768,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0,     0, 32768,
    16384, 49152, 49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0,     0, 32768, 16384, 49152, 49152, 49152,
    32768, 32768, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
        0, 32768, 16384, 49152, 49152, 49152, 32768, 32768, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0,     0, 32768, 16384, 49152,
    49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0,     0, 32768, 16384, 49152, 49152, 49152, 32768, 32768,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0,  2048, 34816,
    18432, 51200, 51200, 51200, 34816, 34816, 51200, 51200, 34816, 34816,
    34816,  2048, 34816,  2048,  1024, 33792, 17408, 50176, 50176, 50176,
    33792, 33792, 50176, 50176, 33792, 33792, 33792,  1024, 33792,  1024,
     3072, 35840, 19456, 52224, 52224, 52224, 35840, 35840, 52224, 52224,
    35840, 35840, 35840,  3072, 35840,  3072,  3072, 35840, 19456, 52224,
    52224, 52224, 35840, 35840, 52224, 52224, 35840, 35840, 35840,  3072,
    35840,  3072,  1024, 33792, 17408, 50176, 50176, 50176, 33792, 33792,
    50176, 50176, 33792, 33792, 33792,  1024, 33792,  1024,  3072, 35840,
    19456, 52224, 52224, 52224, 35840, 35840, 52224, 52224, 35840, 35840,
    35840,  3072, 35840,  3072,  1024, 33792, 17408, 50176, 50176, 50176,
    33792, 33792, 50176, 50176, 33792, 33792, 33792,  1024, 33792,  1024,
     3072, 35840, 19456, 52224, 52224, 52224, 35840, 35840, 52224, 52224,
    35840, 35840, 35840,  3072, 35840,  3072,  1024, 33792, 17408, 50176,
    50176, 50176, 33792, 33792, 50176, 50176, 33792, 33792, 33792,  1024,
    33792,  1024,  3072, 35840, 19456, 52224, 52224, 52224, 35840, 35840,
    52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072,  1024, 33792,
    17408, 50176, 50176, 50176, 33792, 33792, 50176, 50176, 33792, 33792,
    33792,  1024, 33792,  1024,  1024, 33792, 17408, 50176, 50176, 50176,
    33792, 33792, 50176, 50176, 33792, 33792, 33792,  1024, 33792,  1024,
     1024, 33792, 17408, 50176, 50176, 50176, 33792, 33792, 50176, 50176,
    33792, 33792, 33792,  1024, 33792,  1024,     0, 32768, 16384, 49152,
    49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0,     0, 32768, 16384, 49152, 49152, 49152, 32768, 32768,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 34816, 34816,
    51200, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048, 32768, 32768, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    35840, 35840, 52224, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072, 33792, 33792, 50176, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024, 33792, 33792, 50176, 50176, 50176, 17408, 33792,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024, 33792, 33792,
    50176, 50176, 50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024, 33792, 33792, 50176, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
    33792, 33792, 50176, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024, 33792, 33792, 50176, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024, 33792, 33792, 50176, 50176, 50176, 17408, 33792,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024, 33792, 33792,
    50176, 50176, 50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024, 33792, 33792, 50176, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
    33792, 33792, 50176, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024, 33792, 33792, 50176, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024, 32768, 32768, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 32768, 32768,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 17408, 50176,  1024, 33792, 33792, 33792,
    33792, 33792, 33792, 33792, 33792, 33792, 33792,  1024, 33792,  1024,
    19456, 52224,  3072, 35840, 35840, 35840, 35840, 35840, 35840, 35840,
    35840, 35840, 35840,  3072, 35840,  3072, 17408, 50176,  1024, 33792,
    33792, 33792, 33792, 33792, 33792, 33792, 33792, 33792, 33792,  1024,
    33792,  1024, 19456, 52224,  3072, 35840, 35840, 35840, 35840, 35840,
    35840, 35840, 35840, 35840, 35840,  3072, 35840,  3072, 19456, 52224,
     3072, 35840, 35840, 35840, 35840, 35840, 35840, 35840, 35840, 35840,
    35840,  3072, 35840,  3072, 17408, 50176,  1024, 33792, 33792, 33792,
    33792, 33792, 33792, 33792, 33792, 33792, 33792,  1024, 33792,  1024,
    18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816,  2048, 34816,  2048, 16384, 49152,     0, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 19456, 52224,  3072, 35840, 35840, 35840, 35840, 35840,
    35840, 35840, 35840, 35840, 35840,  3072, 35840,  3072, 17408, 50176,
     1024, 33792, 33792, 33792, 33792, 33792, 33792, 33792, 33792, 33792,
    33792,  1024, 33792,  1024, 18432, 51200,  2048, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    16384, 49152,     0, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 16384, 49152,     0, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 16384, 49152,     0, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 16384, 49152,
        0, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 16384, 49152,     0, 32768, 32768, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072, 50176, 50176, 33792, 33792,
    33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,
     1024,  1024, 52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072,
    35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072, 50176, 50176,
    33792, 33792, 33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,
     1024,  1024,  1024,  1024, 50176, 50176, 33792, 33792, 33792,  1024,
    33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,  1024,  1024,
    50176, 50176, 33792, 33792, 33792,  1024, 33792,  1024, 33792,  1024,
    33792,  1024,  1024,  1024,  1024,  1024, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 50176, 50176,
    33792, 33792, 33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,
     1024,  1024,  1024,  1024, 50176, 50176, 33792, 33792, 33792,  1024,
    33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,  1024,  1024,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0, 32768, 16384, 49152,
    49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0,  2048, 34816, 18432, 51200, 51200, 51200, 34816, 34816,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,  1024, 33792,
    17408, 50176, 50176, 50176, 33792, 33792, 50176, 50176, 33792, 33792,
    33792,  1024, 33792,  1024,  3072, 35840, 19456, 52224, 52224, 52224,
    35840, 35840, 52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072,
     3072, 35840, 19456, 52224, 52224, 52224, 35840, 35840, 52224, 52224,
    35840, 35840, 35840,  3072, 35840,  3072,  3072, 35840, 19456, 52224,
    52224, 52224, 35840, 35840, 52224, 52224, 35840, 35840, 35840,  3072,
    35840,  3072,  2048, 34816, 18432, 51200, 51200, 51200, 34816, 34816,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,  2048, 34816,
    18432, 51200, 51200, 51200, 34816, 34816, 51200, 51200, 34816, 34816,
    34816,  2048, 34816,  2048,  3072, 35840, 19456, 52224, 52224, 52224,
    35840, 35840, 52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072,
     3072, 35840, 19456, 52224, 52224, 52224, 35840, 35840, 52224, 52224,
    35840, 35840, 35840,  3072, 35840,  3072,  2048, 34816, 18432, 51200,
    51200, 51200, 34816, 34816, 51200, 51200, 34816, 34816, 34816,  2048,
    34816,  2048,  2048, 34816, 18432, 51200, 51200, 51200, 34816, 34816,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,  2048, 34816,
    18432, 51200, 51200, 51200, 34816, 34816, 51200, 51200, 34816, 34816,
    34816,  2048, 34816,  2048,     0, 32768, 16384, 49152, 49152, 49152,
    32768, 32768, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
     2048, 34816, 18432, 51200, 51200, 51200, 34816, 34816, 51200, 51200,
    34816, 34816, 34816,  2048, 34816,  2048,     0, 32768, 16384, 49152,
    49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 34816, 34816, 51200, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 34816, 34816,
    51200, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048, 35840, 35840, 52224, 52224, 52224, 19456,
    35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
    35840, 35840, 52224, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072, 35840, 35840, 52224, 52224,
    52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072, 33792, 33792, 50176, 50176, 50176, 17408, 33792,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024, 34816, 34816,
    51200, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048, 32768, 32768, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    35840, 35840, 52224, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072, 33792, 33792, 50176, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024, 34816, 34816, 51200, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 32768, 32768,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    32768, 32768, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 32768, 32768, 49152, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 32768, 32768, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 17408, 50176,
     1024, 33792, 33792, 33792, 33792, 33792, 33792, 33792, 33792, 33792,
    33792,  1024, 33792,  1024, 19456, 52224,  3072, 35840, 35840, 35840,
    35840, 35840, 35840, 35840, 35840, 35840, 35840,  3072, 35840,  3072,
    16384, 49152,     0, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 18432, 51200,  2048, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 18432, 51200,
     2048, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,
    34816,  2048, 34816,  2048, 18432, 51200,  2048, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816,  2048, 34816,  2048, 18432, 51200,  2048, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 18432, 51200,
     2048, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,
    34816,  2048, 34816,  2048, 18432, 51200,  2048, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816,  2048, 34816,  2048, 16384, 49152,     0, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 16384, 49152,
        0, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 52224, 52224, 35840, 35840, 35840,  3072,
    35840,  3072, 35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072,
    52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072, 51200, 51200, 34816, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 51200, 51200,
    34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 51200, 51200, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072, 52224, 52224, 35840, 35840,
    35840,  3072, 35840,  3072, 35840,  3072, 35840,  3072,  3072,  3072,
     3072,  3072, 52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072,
    35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072, 52224, 52224,
    35840, 35840, 35840,  3072, 35840,  3072, 35840,  3072, 35840,  3072,
     3072,  3072,  3072,  3072, 52224, 52224, 35840, 35840, 35840,  3072,
    35840,  3072, 35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072,
    50176, 50176, 33792, 33792, 33792,  1024, 33792,  1024, 33792,  1024,
    33792,  1024,  1024,  1024,  1024,  1024, 51200, 51200, 34816, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 52224, 52224,
    35840, 35840, 35840,  3072, 35840,  3072, 35840,  3072, 35840,  3072,
     3072,  3072,  3072,  3072, 50176, 50176, 33792, 33792, 33792,  1024,
    33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,  1024,  1024,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 35840, 35840, 35840, 35840, 35840,  3072, 35840,  3072,
    35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072, 35840, 35840,
    35840, 35840, 35840,  3072, 35840,  3072, 35840,  3072, 35840,  3072,
     3072,  3072,  3072,  3072, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 34816, 34816, 34816, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 34816, 34816,
    34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 33792,  1024, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0, 32768,     0, 32768, 32768, 32768,
    49152, 49152, 32768, 32768, 49152, 49152, 49152, 16384, 32768,     0,
     2048, 34816,  2048, 34816, 34816, 34816, 51200, 51200, 34816, 34816,
    51200, 51200, 51200, 18432, 34816,  2048,     0, 32768,     0, 32768,
    32768, 32768, 49152, 49152, 32768, 32768, 49152, 49152, 49152, 16384,
    32768,     0,  2048, 34816,  2048, 34816, 34816, 34816, 51200, 51200,
    34816, 34816, 51200, 51200, 51200, 18432, 34816,  2048,  2048, 34816,
     2048, 34816, 34816, 34816, 51200, 51200, 34816, 34816, 51200, 51200,
    51200, 18432, 34816,  2048,     0, 32768,     0, 32768, 32768, 32768,
    49152, 49152, 32768, 32768, 49152, 49152, 49152, 16384, 32768,     0,
     3072, 35840,  3072, 35840, 35840, 35840, 52224, 52224, 35840, 35840,
    52224, 52224, 52224, 19456, 35840,  3072,  1024, 33792,  1024, 33792,
    33792, 33792, 50176, 50176, 33792, 33792, 50176, 50176, 50176, 17408,
    33792,  1024,  2048, 34816,  2048, 34816, 34816, 34816, 51200, 51200,
    34816, 34816, 51200, 51200, 51200, 18432, 34816,  2048,     0, 32768,
        0, 32768, 32768, 32768, 49152, 49152, 32768, 32768, 49152, 49152,
    49152, 16384, 32768,     0,  3072, 35840,  3072, 35840, 35840, 35840,
    52224, 52224, 35840, 35840, 52224, 52224, 52224, 19456, 35840,  3072,
     1024, 33792,  1024, 33792, 33792, 33792, 50176, 50176, 33792, 33792,
    50176, 50176, 50176, 17408, 33792,  1024,  1024, 33792,  1024, 33792,
    33792, 33792, 50176, 50176, 33792, 33792, 50176, 50176, 50176, 17408,
    33792,  1024,  1024, 33792,  1024, 33792, 33792, 33792, 50176, 50176,
    33792, 33792, 50176, 50176, 50176, 17408, 33792,  1024,     0, 32768,
        0, 32768, 32768, 32768, 49152, 49152, 32768, 32768, 49152, 49152,
    49152, 16384, 32768,     0,     0, 32768,     0, 32768, 32768, 32768,
    49152, 49152, 32768, 32768, 49152, 49152, 49152, 16384, 32768,     0,
    34816, 34816, 34816, 34816, 34816,  2048, 51200, 18432, 34816,  2048,
    51200, 18432, 18432, 18432,  2048,  2048, 32768, 32768, 32768, 32768,
    32768,     0, 49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,
        0,     0, 34816, 34816, 34816, 34816, 34816,  2048, 51200, 18432,
    34816,  2048, 51200, 18432, 18432, 18432,  2048,  2048, 32768, 32768,
    32768, 32768, 32768,     0, 49152, 16384, 32768,     0, 49152, 16384,
    16384, 16384,     0,     0, 32768, 32768, 32768, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
    32768, 32768, 32768, 32768, 32768,     0, 49152, 16384, 32768,     0,
    49152, 16384, 16384, 16384,     0,     0, 33792, 33792, 33792, 33792,
    33792,  1024, 50176, 17408, 33792,  1024, 50176, 17408, 17408, 17408,
     1024,  1024, 33792, 33792, 33792, 33792, 33792,  1024, 50176, 17408,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024, 32768, 32768,
    32768, 32768, 32768,     0, 49152, 16384, 32768,     0, 49152, 16384,
    16384, 16384,     0,     0, 32768, 32768, 32768, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
    33792, 33792, 33792, 33792, 33792,  1024, 50176, 17408, 33792,  1024,
    50176, 17408, 17408, 17408,  1024,  1024, 33792, 33792, 33792, 33792,
    33792,  1024, 50176, 17408, 33792,  1024, 50176, 17408, 17408, 17408,
     1024,  1024, 33792, 33792, 33792, 33792, 33792,  1024, 50176, 17408,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024, 33792, 33792,
    33792, 33792, 33792,  1024, 50176, 17408, 33792,  1024, 50176, 17408,
    17408, 17408,  1024,  1024, 32768, 32768, 32768, 32768, 32768,     0,
    49152, 16384, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
    32768, 32768, 32768, 32768, 32768,     0, 49152, 16384, 32768,     0,
    49152, 16384, 16384, 16384,     0,     0,     0, 32768, 16384, 49152,
    49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0,  2048, 34816, 18432, 51200, 51200, 51200, 34816, 34816,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,  1024, 33792,
    17408, 50176, 50176, 50176, 33792, 33792, 50176, 50176, 33792, 33792,
    33792,  1024, 33792,  1024,  3072, 35840, 19456, 52224, 52224, 52224,
    35840, 35840, 52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072,
     3072, 35840, 19456, 52224, 52224, 52224, 35840, 35840, 52224, 52224,
    35840, 35840, 35840,  3072, 35840,  3072,  1024, 33792, 17408, 50176,
    50176, 50176, 33792, 33792, 50176, 50176, 33792, 33792, 33792,  1024,
    33792,  1024,  2048, 34816, 18432, 51200, 51200, 51200, 34816, 34816,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,     0, 32768,
    16384, 49152, 49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0,  3072, 35840, 19456, 52224, 52224, 52224,
    35840, 35840, 52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072,
     1024, 33792, 17408, 50176, 50176, 50176, 33792, 33792, 50176, 50176,
    33792, 33792, 33792,  1024, 33792,  1024,  2048, 34816, 18432, 51200,
    51200, 51200, 34816, 34816, 51200, 51200, 34816, 34816, 34816,  2048,
    34816,  2048,     0, 32768, 16384, 49152, 49152, 49152, 32768, 32768,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0,     0, 32768,
    16384, 49152, 49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0,     0, 32768, 16384, 49152, 49152, 49152,
    32768, 32768, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
        0, 32768, 16384, 49152, 49152, 49152, 32768, 32768, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0,     0, 32768, 16384, 49152,
    49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 34816, 34816, 51200, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 32768, 32768,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 35840, 35840, 52224, 52224, 52224, 19456,
    35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
    33792, 33792, 50176, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024, 33792, 33792, 50176, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024, 33792, 33792, 50176, 50176, 50176, 17408, 33792,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024, 32768, 32768,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    33792, 33792, 50176, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024, 33792, 33792, 50176, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024, 32768, 32768, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 32768, 32768,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    32768, 32768, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 32768, 32768, 49152, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 32768, 32768, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 34816, 34816,
    51200, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048, 32768, 32768, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    35840, 35840, 52224, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072, 33792, 33792, 50176, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024, 33792, 33792, 50176, 50176, 50176, 17408, 33792,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024, 33792, 33792,
    50176, 50176, 50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024, 33792, 33792, 50176, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
    33792, 33792, 50176, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024, 33792, 33792, 50176, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024, 33792, 33792, 50176, 50176, 50176, 17408, 33792,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024, 33792, 33792,
    50176, 50176, 50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024, 33792, 33792, 50176, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
    33792, 33792, 50176, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024, 33792, 33792, 50176, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024, 32768, 32768, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 32768, 32768,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 32768,     0, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    32768,     0, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 33792,  1024, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 33792,  1024,
    50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 33792,  1024, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 33792,  1024,
    50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 33792,  1024, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 32768,     0,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 32768,     0, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072, 50176, 50176, 33792, 33792,
    33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,
     1024,  1024, 52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072,
    35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072, 50176, 50176,
    33792, 33792, 33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,
     1024,  1024,  1024,  1024, 50176, 50176, 33792, 33792, 33792,  1024,
    33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,  1024,  1024,
    50176, 50176, 33792, 33792, 33792,  1024, 33792,  1024, 33792,  1024,
    33792,  1024,  1024,  1024,  1024,  1024, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 50176, 50176,
    33792, 33792, 33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,
     1024,  1024,  1024,  1024, 50176, 50176, 33792, 33792, 33792,  1024,
    33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,  1024,  1024,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 34816, 34816, 51200, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 34816, 34816,
    51200, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048, 35840, 35840, 52224, 52224, 52224, 19456,
    35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
    35840, 35840, 52224, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072, 35840, 35840, 52224, 52224,
    52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072, 33792, 33792, 50176, 50176, 50176, 17408, 33792,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024, 34816, 34816,
    51200, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048, 32768, 32768, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    35840, 35840, 52224, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072, 33792, 33792, 50176, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024, 34816, 34816, 51200, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 32768, 32768,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    32768, 32768, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 32768, 32768, 49152, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 32768, 32768, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 34816,  2048,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 32768,     0, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    35840,  3072, 52224, 19456, 19456, 19456,  3072,  3072, 19456, 19456,
     3072,  3072,  3072,  3072,  3072,  3072, 33792,  1024, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 33792,  1024,
    50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 32768,     0, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    32768,     0, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 33792,  1024, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 32768,     0,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 32768,     0, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    32768,     0, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 32768,     0, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 32768,     0, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 32768,     0,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 52224, 52224, 35840, 35840, 35840,  3072,
    35840,  3072, 35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072,
    52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072, 51200, 51200, 34816, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 51200, 51200,
    34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 51200, 51200, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 33792,  1024, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,
        0, 32768, 32768, 32768, 32768, 32768,     0,     0, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768, 32768,
    32768, 32768,  1024,  1024, 17408, 17408, 17408, 50176,  1024, 33792,
    17408, 50176,  1024, 33792, 33792, 33792, 33792, 33792,  1024,  1024,
    17408, 17408, 17408, 50176,  1024, 33792, 17408, 50176,  1024, 33792,
    33792, 33792, 33792, 33792,  1024,  1024, 17408, 17408, 17408, 50176,
     1024, 33792, 17408, 50176,  1024, 33792, 33792, 33792, 33792, 33792,
     3072,  3072, 19456, 19456, 19456, 52224,  3072, 35840, 19456, 52224,
     3072, 35840, 35840, 35840, 35840, 35840,     0,     0, 16384, 16384,
    16384, 49152,     0, 32768, 16384, 49152,     0, 32768, 32768, 32768,
    32768, 32768,  2048,  2048, 18432, 18432, 18432, 51200,  2048, 34816,
    18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816,  1024,  1024,
    17408, 17408, 17408, 50176,  1024, 33792, 17408, 50176,  1024, 33792,
    33792, 33792, 33792, 33792,  3072,  3072, 19456, 19456, 19456, 52224,
     3072, 35840, 19456, 52224,  3072, 35840, 35840, 35840, 35840, 35840,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,
        0, 32768, 32768, 32768, 32768, 32768,  2048,  2048, 18432, 18432,
    18432, 51200,  2048, 34816, 18432, 51200,  2048, 34816, 34816, 34816,
    34816, 34816,  2048,  2048, 18432, 18432, 18432, 51200,  2048, 34816,
    18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816,     0,     0,
    16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,     0, 32768,
    32768, 32768, 32768, 32768,  2048,  2048, 18432, 18432, 18432, 51200,
     2048, 34816, 18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816,
        0,     0, 16384, 16384, 16384, 49152,     0, 32768, 16384, 49152,
        0, 32768, 32768, 32768, 32768, 32768,     0, 32768, 16384, 49152,
    49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0,  2048, 34816, 18432, 51200, 51200, 51200, 34816, 34816,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,  1024, 33792,
    17408, 50176, 50176, 50176, 33792, 33792, 50176, 50176, 33792, 33792,
    33792,  1024, 33792,  1024,  3072, 35840, 19456, 52224, 52224, 52224,
    35840, 35840, 52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072,
     3072, 35840, 19456, 52224, 52224, 52224, 35840, 35840, 52224, 52224,
    35840, 35840, 35840,  3072, 35840,  3072,  1024, 33792, 17408, 50176,
    50176, 50176, 33792, 33792, 50176, 50176, 33792, 33792, 33792,  1024,
    33792,  1024,  2048, 34816, 18432, 51200, 51200, 51200, 34816, 34816,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,     0, 32768,
    16384, 49152, 49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0,  3072, 35840, 19456, 52224, 52224, 52224,
    35840, 35840, 52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072,
     1024, 33792, 17408, 50176, 50176, 50176, 33792, 33792, 50176, 50176,
    33792, 33792, 33792,  1024, 33792,  1024,  2048, 34816, 18432, 51200,
    51200, 51200, 34816, 34816, 51200, 51200, 34816, 34816, 34816,  2048,
    34816,  2048,     0, 32768, 16384, 49152, 49152, 49152, 32768, 32768,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0,     0, 32768,
    16384, 49152, 49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0,     0, 32768, 16384, 49152, 49152, 49152,
    32768, 32768, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
        0, 32768, 16384, 49152, 49152, 49152, 32768, 32768, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0,     0, 32768, 16384, 49152,
    49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 17408, 17408,  1024,  1024,  1024, 33792,  1024, 33792,
     1024, 33792,  1024, 33792, 33792, 33792, 33792, 33792, 17408, 17408,
     1024,  1024,  1024, 33792,  1024, 33792,  1024, 33792,  1024, 33792,
    33792, 33792, 33792, 33792, 16384, 16384,     0,     0,     0, 32768,
        0, 32768,     0, 32768,     0, 32768, 32768, 32768, 32768, 32768,
    16384, 16384,     0,     0,     0, 32768,     0, 32768,     0, 32768,
        0, 32768, 32768, 32768, 32768, 32768, 16384, 16384,     0,     0,
        0, 32768,     0, 32768,     0, 32768,     0, 32768, 32768, 32768,
    32768, 32768, 18432, 18432,  2048,  2048,  2048, 34816,  2048, 34816,
     2048, 34816,  2048, 34816, 34816, 34816, 34816, 34816, 16384, 16384,
        0,     0,     0, 32768,     0, 32768,     0, 32768,     0, 32768,
    32768, 32768, 32768, 32768, 18432, 18432,  2048,  2048,  2048, 34816,
     2048, 34816,  2048, 34816,  2048, 34816, 34816, 34816, 34816, 34816,
    16384, 16384,     0,     0,     0, 32768,     0, 32768,     0, 32768,
        0, 32768, 32768, 32768, 32768, 32768, 18432, 18432,  2048,  2048,
     2048, 34816,  2048, 34816,  2048, 34816,  2048, 34816, 34816, 34816,
    34816, 34816, 16384, 16384,     0,     0,     0, 32768,     0, 32768,
        0, 32768,     0, 32768, 32768, 32768, 32768, 32768, 18432, 18432,
     2048,  2048,  2048, 34816,  2048, 34816,  2048, 34816,  2048, 34816,
    34816, 34816, 34816, 34816, 18432, 18432,  2048,  2048,  2048, 34816,
     2048, 34816,  2048, 34816,  2048, 34816, 34816, 34816, 34816, 34816,
    16384, 16384,     0,     0,     0, 32768,     0, 32768,     0, 32768,
        0, 32768, 32768, 32768, 32768, 32768, 18432, 18432,  2048,  2048,
     2048, 34816,  2048, 34816,  2048, 34816,  2048, 34816, 34816, 34816,
    34816, 34816, 16384, 16384,     0,     0,     0, 32768,     0, 32768,
        0, 32768,     0, 32768, 32768, 32768, 32768, 32768, 17408, 50176,
     1024, 33792, 33792, 33792, 33792, 33792, 33792, 33792, 33792, 33792,
    33792,  1024, 33792,  1024, 19456, 52224,  3072, 35840, 35840, 35840,
    35840, 35840, 35840, 35840, 35840, 35840, 35840,  3072, 35840,  3072,
    16384, 49152,     0, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 18432, 51200,  2048, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 16384, 49152,
        0, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 18432, 51200,  2048, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    16384, 49152,     0, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 18432, 51200,  2048, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 16384, 49152,     0, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 18432, 51200,
     2048, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,
    34816,  2048, 34816,  2048, 16384, 49152,     0, 32768, 32768, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    16384, 49152,     0, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 16384, 49152,     0, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 16384, 49152,     0, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 16384, 49152,
        0, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 17408, 50176,  1024, 33792, 33792, 33792,
    33792, 33792, 33792, 33792, 33792, 33792, 33792,  1024, 33792,  1024,
    19456, 52224,  3072, 35840, 35840, 35840, 35840, 35840, 35840, 35840,
    35840, 35840, 35840,  3072, 35840,  3072, 17408, 50176,  1024, 33792,
    33792, 33792, 33792, 33792, 33792, 33792, 33792, 33792, 33792,  1024,
    33792,  1024, 19456, 52224,  3072, 35840, 35840, 35840, 35840, 35840,
    35840, 35840, 35840, 35840, 35840,  3072, 35840,  3072, 19456, 52224,
     3072, 35840, 35840, 35840, 35840, 35840, 35840, 35840, 35840, 35840,
    35840,  3072, 35840,  3072, 17408, 50176,  1024, 33792, 33792, 33792,
    33792, 33792, 33792, 33792, 33792, 33792, 33792,  1024, 33792,  1024,
    18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816,  2048, 34816,  2048, 16384, 49152,     0, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 19456, 52224,  3072, 35840, 35840, 35840, 35840, 35840,
    35840, 35840, 35840, 35840, 35840,  3072, 35840,  3072, 17408, 50176,
     1024, 33792, 33792, 33792, 33792, 33792, 33792, 33792, 33792, 33792,
    33792,  1024, 33792,  1024, 18432, 51200,  2048, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    16384, 49152,     0, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 16384, 49152,     0, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 16384, 49152,     0, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 16384, 49152,
        0, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 16384, 49152,     0, 32768, 32768, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072, 50176, 50176, 33792, 33792,
    33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,
     1024,  1024, 52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072,
    35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072, 50176, 50176,
    33792, 33792, 33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,
     1024,  1024,  1024,  1024, 50176, 50176, 33792, 33792, 33792,  1024,
    33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,  1024,  1024,
    50176, 50176, 33792, 33792, 33792,  1024, 33792,  1024, 33792,  1024,
    33792,  1024,  1024,  1024,  1024,  1024, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 50176, 50176,
    33792, 33792, 33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,
     1024,  1024,  1024,  1024, 50176, 50176, 33792, 33792, 33792,  1024,
    33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,  1024,  1024,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,  1024, 33792,  1024, 33792,
    33792, 33792, 33792, 33792, 33792, 33792, 33792, 33792, 33792,  1024,
    33792,  1024,  3072, 35840,  3072, 35840, 35840, 35840, 35840, 35840,
    35840, 35840, 35840, 35840, 35840,  3072, 35840,  3072,     0, 32768,
        0, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0,  2048, 34816,  2048, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
     2048, 34816,  2048, 34816, 34816, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816,  2048, 34816,  2048,     0, 32768,     0, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0,  2048, 34816,  2048, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,     0, 32768,
        0, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0,  2048, 34816,  2048, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
        0, 32768,     0, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0,  2048, 34816,  2048, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048,     0, 32768,     0, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0,     0, 32768,
        0, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0,     0, 32768,     0, 32768, 32768, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
        0, 32768,     0, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0,     0, 32768,     0, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 35840, 35840, 35840, 35840, 35840,  3072, 35840,  3072,
    35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072, 33792, 33792,
    33792, 33792, 33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,
     1024,  1024,  1024,  1024, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 17408, 50176,
     1024, 33792, 33792, 33792, 33792, 33792, 33792, 33792, 33792, 33792,
    33792,  1024, 33792,  1024, 19456, 52224,  3072, 35840, 35840, 35840,
    35840, 35840, 35840, 35840, 35840, 35840, 35840,  3072, 35840,  3072,
    16384, 49152,     0, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 18432, 51200,  2048, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 18432, 51200,
     2048, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,
    34816,  2048, 34816,  2048, 18432, 51200,  2048, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816,  2048, 34816,  2048, 18432, 51200,  2048, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 18432, 51200,
     2048, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,
    34816,  2048, 34816,  2048, 18432, 51200,  2048, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816,  2048, 34816,  2048, 16384, 49152,     0, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 16384, 49152,
        0, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 52224, 52224, 35840, 35840, 35840,  3072,
    35840,  3072, 35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072,
    52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072, 51200, 51200, 34816, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 51200, 51200,
    34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 51200, 51200, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0, 32768,     0, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0,  2048, 34816,  2048, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048,     0, 32768,     0, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0,  2048, 34816,
     2048, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,
    34816,  2048, 34816,  2048,  2048, 34816,  2048, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
     2048, 34816,  2048, 34816, 34816, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816,  2048, 34816,  2048,  2048, 34816,  2048, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048,  2048, 34816,  2048, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,  2048, 34816,
     2048, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,
    34816,  2048, 34816,  2048,  2048, 34816,  2048, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
     2048, 34816,  2048, 34816, 34816, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816,  2048, 34816,  2048,  2048, 34816,  2048, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048,  2048, 34816,  2048, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,     0, 32768,
        0, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0,  2048, 34816,  2048, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
        0, 32768,     0, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 34816, 34816, 34816, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 34816, 34816,
    34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 34816, 34816, 34816, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 35840, 35840, 35840, 35840, 35840,  3072, 35840,  3072,
    35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072, 35840, 35840,
    35840, 35840, 35840,  3072, 35840,  3072, 35840,  3072, 35840,  3072,
     3072,  3072,  3072,  3072, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 34816, 34816, 34816, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 34816, 34816,
    34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 33792,  1024, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 34816, 34816, 34816, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 34816, 34816,
    34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0, 32768, 16384, 49152,
    49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0,  2048, 34816, 18432, 51200, 51200, 51200, 34816, 34816,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,  1024, 33792,
    17408, 50176, 50176, 50176, 33792, 33792, 50176, 50176, 33792, 33792,
    33792,  1024, 33792,  1024,  3072, 35840, 19456, 52224, 52224, 52224,
    35840, 35840, 52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072,
     3072, 35840, 19456, 52224, 52224, 52224, 35840, 35840, 52224, 52224,
    35840, 35840, 35840,  3072, 35840,  3072,  1024, 33792, 17408, 50176,
    50176, 50176, 33792, 33792, 50176, 50176, 33792, 33792, 33792,  1024,
    33792,  1024,  2048, 34816, 18432, 51200, 51200, 51200, 34816, 34816,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,     0, 32768,
    16384, 49152, 49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0,  3072, 35840, 19456, 52224, 52224, 52224,
    35840, 35840, 52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072,
     1024, 33792, 17408, 50176, 50176, 50176, 33792, 33792, 50176, 50176,
    33792, 33792, 33792,  1024, 33792,  1024,  2048, 34816, 18432, 51200,
    51200, 51200, 34816, 34816, 51200, 51200, 34816, 34816, 34816,  2048,
    34816,  2048,     0, 32768, 16384, 49152, 49152, 49152, 32768, 32768,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0,     0, 32768,
    16384, 49152, 49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0,     0, 32768, 16384, 49152, 49152, 49152,
    32768, 32768, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
        0, 32768, 16384, 49152, 49152, 49152, 32768, 32768, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0,     0, 32768, 16384, 49152,
    49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 34816, 34816, 51200, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 32768, 32768,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 35840, 35840, 52224, 52224, 52224, 19456,
    35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,
    33792, 33792, 50176, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024, 33792, 33792, 50176, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024, 33792, 33792, 50176, 50176, 50176, 17408, 33792,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024, 32768, 32768,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    33792, 33792, 50176, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024, 33792, 33792, 50176, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024, 32768, 32768, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 32768, 32768,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    32768, 32768, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 32768, 32768, 49152, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 32768, 32768, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 17408, 50176,
     1024, 33792, 33792, 33792, 33792, 33792, 33792, 33792, 33792, 33792,
    33792,  1024, 33792,  1024, 19456, 52224,  3072, 35840, 35840, 35840,
    35840, 35840, 35840, 35840, 35840, 35840, 35840,  3072, 35840,  3072,
    16384, 49152,     0, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 18432, 51200,  2048, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 16384, 49152,
        0, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 18432, 51200,  2048, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    16384, 49152,     0, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 18432, 51200,  2048, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 16384, 49152,     0, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 18432, 51200,
     2048, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,
    34816,  2048, 34816,  2048, 16384, 49152,     0, 32768, 32768, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    16384, 49152,     0, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 16384, 49152,     0, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 16384, 49152,     0, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 16384, 49152,
        0, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 52224, 52224, 35840, 35840, 35840,  3072,
    35840,  3072, 35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072,
    50176, 50176, 33792, 33792, 33792,  1024, 33792,  1024, 33792,  1024,
    33792,  1024,  1024,  1024,  1024,  1024, 51200, 51200, 34816, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072, 50176, 50176, 33792, 33792,
    33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,
     1024,  1024, 52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072,
    35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072, 50176, 50176,
    33792, 33792, 33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,
     1024,  1024,  1024,  1024, 50176, 50176, 33792, 33792, 33792,  1024,
    33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,  1024,  1024,
    50176, 50176, 33792, 33792, 33792,  1024, 33792,  1024, 33792,  1024,
    33792,  1024,  1024,  1024,  1024,  1024, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 50176, 50176,
    33792, 33792, 33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,
     1024,  1024,  1024,  1024, 50176, 50176, 33792, 33792, 33792,  1024,
    33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,  1024,  1024,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 35840, 35840, 35840, 35840, 35840,  3072, 35840,  3072,
    35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072, 33792, 33792,
    33792, 33792, 33792,  1024, 33792,  1024, 33792,  1024, 33792,  1024,
     1024,  1024,  1024,  1024, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 33792,  1024,
    33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024, 33792,  1024, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 52224, 52224, 35840, 35840, 35840,  3072,
    35840,  3072, 35840,  3072, 35840,  3072,  3072,  3072,  3072,  3072,
    52224, 52224, 35840, 35840, 35840,  3072, 35840,  3072, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072, 51200, 51200, 34816, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 51200, 51200,
    34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 51200, 51200, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    52224, 19456, 35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072, 50176, 17408, 33792,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 34816, 34816, 34816, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 34816, 34816,
    34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 34816, 34816, 34816, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 35840,  3072,
    35840,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
     3072,  3072,  3072,  3072, 33792,  1024, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0, 32768, 16384, 49152, 49152, 49152, 49152, 49152,
    49152, 49152, 49152, 49152, 49152, 16384, 32768,     0,  2048, 34816,
    18432, 51200, 51200, 51200, 51200, 51200, 51200, 51200, 51200, 51200,
    51200, 18432, 34816,  2048,  1024, 33792, 17408, 50176, 50176, 50176,
    50176, 50176, 50176, 50176, 50176, 50176, 50176, 17408, 33792,  1024,
     3072, 35840, 19456, 52224, 52224, 52224, 52224, 52224, 52224, 52224,
    52224, 52224, 52224, 19456, 35840,  3072,  3072, 35840, 19456, 52224,
    52224, 52224, 52224, 52224, 52224, 52224, 52224, 52224, 52224, 19456,
    35840,  3072,  1024, 33792, 17408, 50176, 50176, 50176, 50176, 50176,
    50176, 50176, 50176, 50176, 50176, 17408, 33792,  1024,  2048, 34816,
    18432, 51200, 51200, 51200, 51200, 51200, 51200, 51200, 51200, 51200,
    51200, 18432, 34816,  2048,     0, 32768, 16384, 49152, 49152, 49152,
    49152, 49152, 49152, 49152, 49152, 49152, 49152, 16384, 32768,     0,
     3072, 35840, 19456, 52224, 52224, 52224, 52224, 52224, 52224, 52224,
    52224, 52224, 52224, 19456, 35840,  3072,  1024, 33792, 17408, 50176,
    50176, 50176, 50176, 50176, 50176, 50176, 50176, 50176, 50176, 17408,
    33792,  1024,  2048, 34816, 18432, 51200, 51200, 51200, 51200, 51200,
    51200, 51200, 51200, 51200, 51200, 18432, 34816,  2048,     0, 32768,
    16384, 49152, 49152, 49152, 49152, 49152, 49152, 49152, 49152, 49152,
    49152, 16384, 32768,     0,     0, 32768, 16384, 49152, 49152, 49152,
    49152, 49152, 49152, 49152, 49152, 49152, 49152, 16384, 32768,     0,
        0, 32768, 16384, 49152, 49152, 49152, 49152, 49152, 49152, 49152,
    49152, 49152, 49152, 16384, 32768,     0,     0, 32768, 16384, 49152,
    49152, 49152, 49152, 49152, 49152, 49152, 49152, 49152, 49152, 16384,
    32768,     0,     0, 32768, 16384, 49152, 49152, 49152, 49152, 49152,
    49152, 49152, 49152, 49152, 49152, 16384, 32768,     0, 34816, 34816,
    51200, 51200, 51200, 18432, 51200, 18432, 51200, 18432, 51200, 18432,
    18432, 18432,  2048,  2048, 32768, 32768, 49152, 49152, 49152, 16384,
    49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    35840, 35840, 52224, 52224, 52224, 19456, 52224, 19456, 52224, 19456,
    52224, 19456, 19456, 19456,  3072,  3072, 33792, 33792, 50176, 50176,
    50176, 17408, 50176, 17408, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024, 33792, 33792, 50176, 50176, 50176, 17408, 50176, 17408,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024, 33792, 33792,
    50176, 50176, 50176, 17408, 50176, 17408, 50176, 17408, 50176, 17408,
    17408, 17408,  1024,  1024, 32768, 32768, 49152, 49152, 49152, 16384,
    49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    32768, 32768, 49152, 49152, 49152, 16384, 49152, 16384, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 33792, 33792, 50176, 50176,
    50176, 17408, 50176, 17408, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024, 33792, 33792, 50176, 50176, 50176, 17408, 50176, 17408,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024, 32768, 32768,
    49152, 49152, 49152, 16384, 49152, 16384, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 32768, 32768, 49152, 49152, 49152, 16384,
    49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    32768, 32768, 49152, 49152, 49152, 16384, 49152, 16384, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 32768, 32768, 49152, 49152,
    49152, 16384, 49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 32768, 32768, 49152, 49152, 49152, 16384, 49152, 16384,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 32768, 32768,
    49152, 49152, 49152, 16384, 49152, 16384, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 17408, 50176, 17408, 50176, 50176, 50176,
    33792, 33792, 50176, 50176, 33792, 33792, 33792,  1024, 33792,  1024,
    19456, 52224, 19456, 52224, 52224, 52224, 35840, 35840, 52224, 52224,
    35840, 35840, 35840,  3072, 35840,  3072, 16384, 49152, 16384, 49152,
    49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 18432, 51200, 18432, 51200, 51200, 51200, 34816, 34816,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048, 18432, 51200,
    18432, 51200, 51200, 51200, 34816, 34816, 51200, 51200, 34816, 34816,
    34816,  2048, 34816,  2048, 16384, 49152, 16384, 49152, 49152, 49152,
    32768, 32768, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    18432, 51200, 18432, 51200, 51200, 51200, 34816, 34816, 51200, 51200,
    34816, 34816, 34816,  2048, 34816,  2048, 16384, 49152, 16384, 49152,
    49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 18432, 51200, 18432, 51200, 51200, 51200, 34816, 34816,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048, 16384, 49152,
    16384, 49152, 49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 18432, 51200, 18432, 51200, 51200, 51200,
    34816, 34816, 51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,
    16384, 49152, 16384, 49152, 49152, 49152, 32768, 32768, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 16384, 49152, 16384, 49152,
    49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 16384, 49152, 16384, 49152, 49152, 49152, 32768, 32768,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 16384, 49152,
    16384, 49152, 49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 16384, 49152, 16384, 49152, 49152, 49152,
    32768, 32768, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    52224, 52224, 52224, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072, 50176, 50176, 50176, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024, 51200, 51200, 51200, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 49152, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 49152, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 52224, 52224, 52224, 52224,
    52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072, 50176, 50176, 50176, 50176, 50176, 17408, 33792,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024, 52224, 52224,
    52224, 52224, 52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,
     3072,  3072,  3072,  3072, 50176, 50176, 50176, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
    50176, 50176, 50176, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024, 50176, 50176, 50176, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024, 49152, 49152, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 50176, 50176, 50176, 50176, 50176, 17408,
    33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,
    50176, 50176, 50176, 50176, 50176, 17408, 33792,  1024, 50176, 17408,
    33792,  1024,  1024,  1024,  1024,  1024, 49152, 49152, 49152, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 49152, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 50176, 17408,
    50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 50176, 17408, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 50176, 17408, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 52224, 52224,
    35840, 35840, 35840,  3072, 35840,  3072, 35840,  3072, 35840,  3072,
     3072,  3072,  3072,  3072, 50176, 50176, 33792, 33792, 33792,  1024,
    33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,  1024,  1024,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    52224, 52224, 52224, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072, 52224, 52224, 52224, 52224,
    52224, 19456, 35840,  3072, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072, 51200, 51200, 51200, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 51200, 51200,
    51200, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048, 51200, 51200, 51200, 51200, 51200, 18432,
    34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,
    49152, 49152, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 51200, 51200, 51200, 51200,
    51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,  2048,  2048,
     2048,  2048, 49152, 49152, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 51200, 51200,
    51200, 51200, 51200, 18432, 34816,  2048, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048, 49152, 49152, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    51200, 51200, 51200, 51200, 51200, 18432, 34816,  2048, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152, 49152, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 52224, 19456, 52224, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 51200, 18432,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 51200, 51200,
    34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 51200, 51200, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 51200, 51200, 34816, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 51200, 51200,
    34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 52224, 19456, 35840,  3072,  3072,  3072,
     3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,  3072,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 51200, 18432, 34816,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 34816, 34816,
    51200, 51200, 51200, 18432, 51200, 18432, 51200, 18432, 51200, 18432,
    18432, 18432,  2048,  2048, 32768, 32768, 49152, 49152, 49152, 16384,
    49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    35840, 35840, 52224, 52224, 52224, 19456, 52224, 19456, 52224, 19456,
    52224, 19456, 19456, 19456,  3072,  3072, 33792, 33792, 50176, 50176,
    50176, 17408, 50176, 17408, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024, 33792, 33792, 50176, 50176, 50176, 17408, 50176, 17408,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024, 33792, 33792,
    50176, 50176, 50176, 17408, 50176, 17408, 50176, 17408, 50176, 17408,
    17408, 17408,  1024,  1024, 32768, 32768, 49152, 49152, 49152, 16384,
    49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    32768, 32768, 49152, 49152, 49152, 16384, 49152, 16384, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 33792, 33792, 50176, 50176,
    50176, 17408, 50176, 17408, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024, 33792, 33792, 50176, 50176, 50176, 17408, 50176, 17408,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024, 32768, 32768,
    49152, 49152, 49152, 16384, 49152, 16384, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 32768, 32768, 49152, 49152, 49152, 16384,
    49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    32768, 32768, 49152, 49152, 49152, 16384, 49152, 16384, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 32768, 32768, 49152, 49152,
    49152, 16384, 49152, 16384, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 32768, 32768, 49152, 49152, 49152, 16384, 49152, 16384,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 32768, 32768,
    49152, 49152, 49152, 16384, 49152, 16384, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 32768,     0, 49152, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    32768,     0, 49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 33792,  1024, 50176, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
     1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 33792,  1024,
    50176, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 33792,  1024, 50176, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
    32768,     0, 49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 32768,     0, 49152, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 33792,  1024, 50176, 17408, 17408, 17408, 17408, 17408,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 33792,  1024,
    50176, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 32768,     0, 49152, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    32768,     0, 49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 32768,     0, 49152, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 32768,     0, 49152, 16384, 16384, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 32768,     0,
    49152, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 32768,     0, 49152, 16384, 16384, 16384,
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    52224, 52224, 52224, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072, 50176, 50176, 50176, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024, 51200, 51200, 51200, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 49152, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 49152, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 50176, 17408, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 50176, 17408,
    50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 50176, 17408, 50176, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 50176, 17408, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 50176, 17408, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 17408, 17408,
    17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
    17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,
    17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 17408, 17408, 17408, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 52224, 19456, 52224, 19456,
    19456, 19456,  3072,  3072, 19456, 19456,  3072,  3072,  3072,  3072,
     3072,  3072, 50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 51200, 18432,
    51200, 18432, 18432, 18432,  2048,  2048, 18432, 18432,  2048,  2048,
     2048,  2048,  2048,  2048, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 17408, 17408, 17408, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,
    17408, 17408, 17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 16384, 16384,
    16384, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 16384, 16384, 16384, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    16384, 16384, 16384, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 16384, 16384, 16384, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 16384, 16384, 16384, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 17408, 50176, 17408, 50176, 50176, 50176,
    33792, 33792, 50176, 50176, 33792, 33792, 33792,  1024, 33792,  1024,
    19456, 52224, 19456, 52224, 52224, 52224, 35840, 35840, 52224, 52224,
    35840, 35840, 35840,  3072, 35840,  3072, 16384, 49152, 16384, 49152,
    49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 18432, 51200, 18432, 51200, 51200, 51200, 34816, 34816,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048, 18432, 51200,
    18432, 51200, 51200, 51200, 34816, 34816, 51200, 51200, 34816, 34816,
    34816,  2048, 34816,  2048, 16384, 49152, 16384, 49152, 49152, 49152,
    32768, 32768, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    18432, 51200, 18432, 51200, 51200, 51200, 34816, 34816, 51200, 51200,
    34816, 34816, 34816,  2048, 34816,  2048, 16384, 49152, 16384, 49152,
    49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 18432, 51200, 18432, 51200, 51200, 51200, 34816, 34816,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048, 16384, 49152,
    16384, 49152, 49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 18432, 51200, 18432, 51200, 51200, 51200,
    34816, 34816, 51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,
    16384, 49152, 16384, 49152, 49152, 49152, 32768, 32768, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 16384, 49152, 16384, 49152,
    49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 16384, 49152, 16384, 49152, 49152, 49152, 32768, 32768,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 16384, 49152,
    16384, 49152, 49152, 49152, 32768, 32768, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 16384, 49152, 16384, 49152, 49152, 49152,
    32768, 32768, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    52224, 52224, 52224, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072, 50176, 50176, 50176, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024, 51200, 51200, 51200, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 49152, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 49152, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 16384, 49152,     0, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 16384, 49152,
        0, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 18432, 51200,  2048, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816,  2048, 34816,  2048, 16384, 49152,     0, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 18432, 51200,  2048, 34816, 34816, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 16384, 49152,
        0, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 18432, 51200,  2048, 34816, 34816, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    16384, 49152,     0, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 18432, 51200,  2048, 34816,
    34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 16384, 49152,     0, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 16384, 49152,
        0, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 16384, 49152,     0, 32768, 32768, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    16384, 49152,     0, 32768, 32768, 32768, 32768, 32768, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 16384, 49152,     0, 32768,
    32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 51200, 51200, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 52224, 52224,
    35840, 35840, 35840,  3072, 35840,  3072, 35840,  3072, 35840,  3072,
     3072,  3072,  3072,  3072, 50176, 50176, 33792, 33792, 33792,  1024,
    33792,  1024, 33792,  1024, 33792,  1024,  1024,  1024,  1024,  1024,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 51200, 51200,
    34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 51200, 51200, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 51200, 51200, 34816, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 51200, 51200,
    34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 34816, 34816, 34816, 34816,
    34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,
     2048,  2048, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 34816, 34816,
    34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 34816, 34816, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 34816, 34816, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    32768, 32768, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 32768, 32768, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 32768, 32768, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 32768, 32768,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 32768, 32768, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 34816,  2048, 34816,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 34816,  2048,
    34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    52224, 52224, 52224, 52224, 52224, 19456, 35840,  3072, 52224, 19456,
    35840,  3072,  3072,  3072,  3072,  3072, 50176, 50176, 50176, 50176,
    50176, 17408, 33792,  1024, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024, 51200, 51200, 51200, 51200, 51200, 18432, 34816,  2048,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 49152, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 49152, 49152,
    49152, 16384, 32768,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 49152, 49152, 49152, 16384, 32768,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    49152, 49152, 49152, 16384, 32768,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 49152, 49152, 49152, 16384,
    32768,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 49152, 49152, 49152, 16384, 32768,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0, 50176, 17408, 50176, 17408,
    17408, 17408,  1024,  1024, 17408, 17408,  1024,  1024,  1024,  1024,
     1024,  1024, 50176, 17408, 50176, 17408, 17408, 17408,  1024,  1024,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 49152, 16384, 49152, 16384, 16384, 16384,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0, 49152, 16384,
    49152, 16384, 16384, 16384,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0, 49152, 16384, 49152, 16384, 16384, 16384,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
    49152, 16384, 49152, 16384, 16384, 16384,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0, 49152, 16384, 49152, 16384,
    16384, 16384,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0, 51200, 51200, 34816, 34816, 34816,  2048, 34816,  2048,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 51200, 51200, 34816, 34816, 34816,  2048,
    34816,  2048, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 49152,
    32768, 32768, 32768,     0, 32768,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0, 49152, 49152, 32768, 32768, 32768,     0,
    32768,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
    49152, 49152, 32768, 32768, 32768,     0, 32768,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0, 49152, 49152, 32768, 32768,
    32768,     0, 32768,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0, 49152, 49152, 32768, 32768, 32768,     0, 32768,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 50176, 17408, 33792,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
    50176, 17408, 33792,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    17408, 17408,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024, 17408, 17408,  1024,  1024,
     1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,  1024,
     1024,  1024, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 51200, 18432,
    34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    51200, 18432, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 49152, 16384, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49152, 16384, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 49152, 16384, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 49152, 16384, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 49152, 16384,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    16384, 16384,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 16384, 16384,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 16384, 16384,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 16384, 16384,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 16384, 16384,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 34816,  2048, 34816,  2048,  2048,  2048,  2048,  2048,
     2048,  2048,  2048,  2048,  2048,  2048,  2048,  2048, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0, 32768,     0, 32768,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 32768,     0, 32768,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 32768,     0,
    32768,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 32768,     0, 32768,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    32768,     0, 32768,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0
};
