/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plugin;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.common.stats.Counters;

public class EqlStatsResponse
extends BaseNodesResponse<NodeStatsResponse>
implements ToXContentObject {
    public EqlStatsResponse(StreamInput in) throws IOException {
        super(in);
    }

    public EqlStatsResponse(ClusterName clusterName, List<NodeStatsResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    protected List<NodeStatsResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(NodeStatsResponse::readNodeResponse);
    }

    protected void writeNodesTo(StreamOutput out, List<NodeStatsResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("stats");
        for (NodeStatsResponse node : this.getNodes()) {
            node.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static class NodeStatsResponse
    extends BaseNodeResponse
    implements ToXContentObject {
        private Counters stats;

        public NodeStatsResponse(StreamInput in) throws IOException {
            super(in);
            if (in.readBoolean()) {
                this.stats = new Counters(in);
            }
        }

        public NodeStatsResponse(DiscoveryNode node) {
            super(node);
        }

        public Counters getStats() {
            return this.stats;
        }

        public void setStats(Counters stats) {
            this.stats = stats;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.stats != null);
            if (this.stats != null) {
                this.stats.writeTo(out);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.stats != null && this.stats.hasCounters()) {
                builder.field("stats", this.stats.toNestedMap());
            }
            builder.endObject();
            return builder;
        }

        static NodeStatsResponse readNodeResponse(StreamInput in) throws IOException {
            return new NodeStatsResponse(in);
        }
    }
}

