/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.Semaphore;

public class AdjustableSemaphore
extends Semaphore {
    private final Object maxPermitsMutex = new Object();
    private int maxPermits;

    public AdjustableSemaphore(int maxPermits, boolean fair) {
        super(maxPermits, fair);
        this.maxPermits = maxPermits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxPermits(int permits) {
        Object object = this.maxPermitsMutex;
        synchronized (object) {
            int diff = Math.subtractExact(permits, this.maxPermits);
            if (diff > 0) {
                this.release(diff);
            } else if (diff < 0) {
                this.reducePermits(Math.negateExact(diff));
            }
            this.maxPermits = permits;
        }
    }
}

