/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.ClosePointInTimeResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ClearScrollResponse
extends ActionResponse
implements StatusToXContentObject {
    private static final ParseField SUCCEEDED = new ParseField("succeeded", new String[0]);
    private static final ParseField NUMFREED = new ParseField("num_freed", new String[0]);
    private static final ConstructingObjectParser<ClosePointInTimeResponse, Void> PARSER = new ConstructingObjectParser("clear_scroll", true, a -> new ClosePointInTimeResponse((Boolean)a[0], (Integer)a[1]));
    private final boolean succeeded;
    private final int numFreed;

    public ClearScrollResponse(boolean succeeded, int numFreed) {
        this.succeeded = succeeded;
        this.numFreed = numFreed;
    }

    public ClearScrollResponse(StreamInput in) throws IOException {
        super(in);
        this.succeeded = in.readBoolean();
        this.numFreed = in.readVInt();
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    public int getNumFreed() {
        return this.numFreed;
    }

    @Override
    public RestStatus status() {
        return this.numFreed == 0 ? RestStatus.NOT_FOUND : RestStatus.OK;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SUCCEEDED.getPreferredName(), this.succeeded);
        builder.field(NUMFREED.getPreferredName(), this.numFreed);
        builder.endObject();
        return builder;
    }

    public static ClosePointInTimeResponse fromXContent(XContentParser parser) throws IOException {
        return (ClosePointInTimeResponse)PARSER.apply(parser, null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.succeeded);
        out.writeVInt(this.numFreed);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.booleanValue(), SUCCEEDED, ObjectParser.ValueType.BOOLEAN);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.intValue(), NUMFREED, ObjectParser.ValueType.INT);
    }
}

