/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.upgrade.post;

import java.io.IOException;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class UpgradeRequest
extends BroadcastRequest<UpgradeRequest> {
    private boolean upgradeOnlyAncientSegments = false;

    public UpgradeRequest(String ... indices) {
        super(indices);
    }

    public UpgradeRequest(StreamInput in) throws IOException {
        super(in);
        this.upgradeOnlyAncientSegments = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.upgradeOnlyAncientSegments);
    }

    public boolean upgradeOnlyAncientSegments() {
        return this.upgradeOnlyAncientSegments;
    }

    public UpgradeRequest upgradeOnlyAncientSegments(boolean upgradeOnlyAncientSegments) {
        this.upgradeOnlyAncientSegments = upgradeOnlyAncientSegments;
        return this;
    }

    @Override
    public String toString() {
        return "UpgradeRequest{upgradeOnlyAncientSegments=" + this.upgradeOnlyAncientSegments + '}';
    }

    public static final class Defaults {
        public static final boolean UPGRADE_ONLY_ANCIENT_SEGMENTS = false;
    }
}

