/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.ShutdownPersistentTasksStatus;
import org.elasticsearch.cluster.metadata.ShutdownPluginsStatus;
import org.elasticsearch.cluster.metadata.ShutdownShardMigrationStatus;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.ShardAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.shutdown.PluginShutdownService;
import org.elasticsearch.snapshots.SnapshotsInfoService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.shutdown.GetShutdownStatusAction;
import org.elasticsearch.xpack.shutdown.SingleNodeShutdownStatus;

public class TransportGetShutdownStatusAction
extends TransportMasterNodeAction<GetShutdownStatusAction.Request, GetShutdownStatusAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetShutdownStatusAction.class);
    private final AllocationDeciders allocationDeciders;
    private final AllocationService allocationService;
    private final ClusterInfoService clusterInfoService;
    private final SnapshotsInfoService snapshotsInfoService;
    private final PluginShutdownService pluginShutdownService;

    @Inject
    public TransportGetShutdownStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AllocationService allocationService, AllocationDeciders allocationDeciders, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService, PluginShutdownService pluginShutdownService) {
        super("cluster:admin/shutdown/get", transportService, clusterService, threadPool, actionFilters, GetShutdownStatusAction.Request::readFrom, indexNameExpressionResolver, GetShutdownStatusAction.Response::new, "same");
        this.allocationService = allocationService;
        this.allocationDeciders = allocationDeciders;
        this.clusterInfoService = clusterInfoService;
        this.snapshotsInfoService = snapshotsInfoService;
        this.pluginShutdownService = pluginShutdownService;
    }

    protected void masterOperation(GetShutdownStatusAction.Request request, ClusterState state, ActionListener<GetShutdownStatusAction.Response> listener) throws Exception {
        GetShutdownStatusAction.Response response;
        NodesShutdownMetadata nodesShutdownMetadata = (NodesShutdownMetadata)state.metadata().custom("node_shutdown");
        if (nodesShutdownMetadata == null) {
            response = new GetShutdownStatusAction.Response(new ArrayList<SingleNodeShutdownStatus>());
        } else if (request.getNodeIds().length == 0) {
            List<SingleNodeShutdownStatus> shutdownStatuses = nodesShutdownMetadata.getAllNodeMetadataMap().values().stream().map(ns -> new SingleNodeShutdownStatus((SingleNodeShutdownMetadata)ns, TransportGetShutdownStatusAction.shardMigrationStatus(state, ns.getNodeId(), ns.getType(), ns.getNodeSeen(), this.clusterInfoService, this.snapshotsInfoService, this.allocationService, this.allocationDeciders), new ShutdownPersistentTasksStatus(), new ShutdownPluginsStatus(this.pluginShutdownService.readyToShutdown(ns.getNodeId(), ns.getType())))).collect(Collectors.toList());
            response = new GetShutdownStatusAction.Response(shutdownStatuses);
        } else {
            new ArrayList();
            Map nodeShutdownMetadataMap = nodesShutdownMetadata.getAllNodeMetadataMap();
            List<SingleNodeShutdownStatus> shutdownStatuses = Arrays.stream(request.getNodeIds()).map(nodeShutdownMetadataMap::get).filter(Objects::nonNull).map(ns -> new SingleNodeShutdownStatus((SingleNodeShutdownMetadata)ns, TransportGetShutdownStatusAction.shardMigrationStatus(state, ns.getNodeId(), ns.getType(), ns.getNodeSeen(), this.clusterInfoService, this.snapshotsInfoService, this.allocationService, this.allocationDeciders), new ShutdownPersistentTasksStatus(), new ShutdownPluginsStatus(this.pluginShutdownService.readyToShutdown(ns.getNodeId(), ns.getType())))).collect(Collectors.toList());
            response = new GetShutdownStatusAction.Response(shutdownStatuses);
        }
        listener.onResponse((Object)response);
    }

    static ShutdownShardMigrationStatus shardMigrationStatus(ClusterState currentState, String nodeId, SingleNodeShutdownMetadata.Type shutdownType, boolean nodeSeen, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService, AllocationService allocationService, AllocationDeciders allocationDeciders) {
        if (SingleNodeShutdownMetadata.Type.RESTART.equals((Object)shutdownType)) {
            return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.COMPLETE, 0L, "no shard relocation is necessary for a node restart");
        }
        if (currentState.nodes().get(nodeId) == null && !nodeSeen) {
            return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.NOT_STARTED, 0L, "node is not currently part of the cluster");
        }
        RoutingAllocation allocation = new RoutingAllocation(allocationDeciders, currentState.getRoutingNodes(), currentState, clusterInfoService.getClusterInfo(), snapshotsInfoService.snapshotShardSizes(), System.nanoTime());
        allocation.setDebugMode(RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS);
        Set<String> shuttingDownNodes = currentState.metadata().nodeShutdowns().keySet();
        ArrayList<ShardRouting> unassignedShards = new ArrayList<ShardRouting>();
        for (ShardRouting s : currentState.getRoutingNodes().unassigned()) {
            if (!Objects.equals(s.unassignedInfo().getLastAllocatedNodeId(), nodeId) || !s.primary() && TransportGetShutdownStatusAction.hasShardCopyOnAnotherNode(currentState, s, shuttingDownNodes)) continue;
            unassignedShards.add(s);
        }
        if (!unassignedShards.isEmpty()) {
            ShardRouting shardRouting2 = (ShardRouting)unassignedShards.get(0);
            ShardAllocationDecision decision = allocationService.explainShardAllocation(shardRouting2, allocation);
            return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.STALLED, (long)unassignedShards.size(), new ParameterizedMessage("shard [{}] [{}] of index [{}] is unassigned, see [{}] for details or use the cluster allocation explain API", new Object[]{shardRouting2.shardId().getId(), shardRouting2.primary() ? "primary" : "replica", shardRouting2.index().getName(), "node_allocation_decision"}).getFormattedMessage(), decision);
        }
        if (currentState.getRoutingNodes().node(nodeId) == null) {
            return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.COMPLETE, 0L);
        }
        int startedShards = currentState.getRoutingNodes().node(nodeId).numberOfShardsWithState(new ShardRoutingState[]{ShardRoutingState.STARTED});
        int relocatingShards = currentState.getRoutingNodes().node(nodeId).numberOfShardsWithState(new ShardRoutingState[]{ShardRoutingState.RELOCATING});
        int initializingShards = currentState.getRoutingNodes().node(nodeId).numberOfShardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING});
        int totalRemainingShards = relocatingShards + startedShards + initializingShards;
        if (relocatingShards > 0 || totalRemainingShards == 0) {
            SingleNodeShutdownMetadata.Status shardStatus = totalRemainingShards == 0 ? SingleNodeShutdownMetadata.Status.COMPLETE : SingleNodeShutdownMetadata.Status.IN_PROGRESS;
            return new ShutdownShardMigrationStatus(shardStatus, (long)totalRemainingShards);
        }
        if (initializingShards > 0 && relocatingShards == 0 && startedShards == 0) {
            return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.IN_PROGRESS, (long)totalRemainingShards, "all remaining shards are currently INITIALIZING and must finish before they can be moved off this node");
        }
        AtomicInteger shardsToIgnoreForFinalStatus = new AtomicInteger(0);
        Optional<Tuple> unmovableShard = currentState.getRoutingNodes().node(nodeId).shardsWithState(new ShardRoutingState[]{ShardRoutingState.STARTED}).stream().map(shardRouting -> new Tuple(shardRouting, (Object)allocationService.explainShardAllocation(shardRouting, allocation))).filter(pair -> {
            assert (!((ShardAllocationDecision)pair.v2()).getMoveDecision().canRemain()) : "shard [" + pair + "] can remain on node [" + nodeId + "], but that node is shutting down";
            return !((ShardAllocationDecision)pair.v2()).getMoveDecision().canRemain();
        }).filter(pair -> !((ShardAllocationDecision)pair.v2()).getMoveDecision().getAllocationDecision().equals((Object)AllocationDecision.THROTTLED)).filter(pair -> !((ShardAllocationDecision)pair.v2()).getMoveDecision().getAllocationDecision().equals((Object)AllocationDecision.YES)).filter(pair -> {
            boolean hasShardCopyOnOtherNode = TransportGetShutdownStatusAction.hasShardCopyOnAnotherNode(currentState, (ShardRouting)pair.v1(), shuttingDownNodes);
            if (hasShardCopyOnOtherNode) {
                shardsToIgnoreForFinalStatus.incrementAndGet();
            }
            return !hasShardCopyOnOtherNode;
        }).filter(pair -> !TransportGetShutdownStatusAction.isIlmRestrictingShardMovement(currentState, (ShardRouting)pair.v1())).peek(pair -> logger.debug("node [{}] shutdown of type [{}] stalled: found shard [{}][{}] from index [{}] with negative decision: [{}]", (Object)nodeId, (Object)shutdownType, (Object)((ShardRouting)pair.v1()).getId(), (Object)(((ShardRouting)pair.v1()).primary() ? "primary" : "replica"), (Object)((ShardRouting)pair.v1()).shardId().getIndexName(), (Object)Strings.toString((ToXContent)((ToXContent)pair.v2())))).findFirst();
        if (totalRemainingShards == shardsToIgnoreForFinalStatus.get() && !unmovableShard.isPresent()) {
            return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.COMPLETE, 0L, "[" + shardsToIgnoreForFinalStatus.get() + "] shards cannot be moved away from this node but have at least one copy on another node in the cluster");
        }
        if (unmovableShard.isPresent()) {
            ShardRouting shardRouting3 = (ShardRouting)unmovableShard.get().v1();
            ShardAllocationDecision decision = (ShardAllocationDecision)unmovableShard.get().v2();
            return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.STALLED, (long)totalRemainingShards, new ParameterizedMessage("shard [{}] [{}] of index [{}] cannot move, see [{}] for details or use the cluster allocation explain API", new Object[]{shardRouting3.shardId().getId(), shardRouting3.primary() ? "primary" : "replica", shardRouting3.index().getName(), "node_allocation_decision"}).getFormattedMessage(), decision);
        }
        return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.IN_PROGRESS, (long)totalRemainingShards);
    }

    private static boolean isIlmRestrictingShardMovement(ClusterState currentState, ShardRouting pair) {
        if (TransportGetShutdownStatusAction.isIlmRunning(currentState)) {
            boolean ilmWillMoveShardEventually;
            LifecycleExecutionState ilmState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)currentState.metadata().index(pair.index()));
            boolean bl = ilmWillMoveShardEventually = ilmState != null && "shrink".equals(ilmState.getAction()) && !"ERROR".equals(ilmState.getStep());
            if (ilmWillMoveShardEventually) {
                logger.debug("shard [{}] [{}] of index [{}] cannot move, but ILM is shrinking that index so assuming it will move", (Object)pair.shardId().getId(), (Object)(pair.primary() ? "primary" : "replica"), (Object)pair.index().getName());
            }
            return ilmWillMoveShardEventually;
        }
        return false;
    }

    private static boolean isIlmRunning(ClusterState currentState) {
        IndexLifecycleMetadata ilmState = (IndexLifecycleMetadata)currentState.metadata().custom("index_lifecycle");
        return !(ilmState != null && OperationMode.STOPPED.equals((Object)ilmState.getOperationMode()));
    }

    private static boolean hasShardCopyOnAnotherNode(ClusterState clusterState, ShardRouting shardRouting, Set<String> shuttingDownNodes) {
        return clusterState.routingTable().allShards(shardRouting.index().getName()).stream().filter(sr -> sr.id() == shardRouting.id()).filter(ShardRouting::started).anyMatch(routing -> !shuttingDownNodes.contains(routing.currentNodeId()));
    }

    protected ClusterBlockException checkBlock(GetShutdownStatusAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

