/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.common.time.TimeUtils;

public class ExponentialAverageCalculationContext
implements Writeable,
ToXContentObject {
    public static final ParseField INCREMENTAL_METRIC_VALUE_MS = new ParseField("incremental_metric_value_ms", new String[0]);
    public static final ParseField LATEST_TIMESTAMP = new ParseField("latest_timestamp", new String[0]);
    public static final ParseField PREVIOUS_EXPONENTIAL_AVERAGE_MS = new ParseField("previous_exponential_average_ms", new String[0]);
    public static final ConstructingObjectParser<ExponentialAverageCalculationContext, Void> PARSER = new ConstructingObjectParser("exponential_average_calculation_context", true, args -> {
        Double incrementalMetricValueMs = (Double)args[0];
        Instant latestTimestamp = (Instant)args[1];
        Double previousExponentialAverageMs = (Double)args[2];
        return new ExponentialAverageCalculationContext(ExponentialAverageCalculationContext.getOrDefault(incrementalMetricValueMs, 0.0), latestTimestamp, previousExponentialAverageMs);
    });
    private static final TemporalUnit WINDOW_UNIT;
    private static final Duration WINDOW_SIZE;
    private double incrementalMetricValueMs;
    private Instant latestTimestamp;
    private Double previousExponentialAverageMs;

    public ExponentialAverageCalculationContext() {
        this(0.0, null, null);
    }

    public ExponentialAverageCalculationContext(double incrementalMetricValueMs, @Nullable Instant latestTimestamp, @Nullable Double previousExponentialAverageMs) {
        this.incrementalMetricValueMs = incrementalMetricValueMs;
        this.latestTimestamp = latestTimestamp != null ? Instant.ofEpochMilli(latestTimestamp.toEpochMilli()) : null;
        this.previousExponentialAverageMs = previousExponentialAverageMs;
    }

    public ExponentialAverageCalculationContext(ExponentialAverageCalculationContext lhs) {
        this(lhs.incrementalMetricValueMs, lhs.latestTimestamp, lhs.previousExponentialAverageMs);
    }

    public ExponentialAverageCalculationContext(StreamInput in) throws IOException {
        this.incrementalMetricValueMs = in.readDouble();
        this.latestTimestamp = in.readOptionalInstant();
        this.previousExponentialAverageMs = in.readOptionalDouble();
    }

    public double getIncrementalMetricValueMs() {
        return this.incrementalMetricValueMs;
    }

    public Instant getLatestTimestamp() {
        return this.latestTimestamp;
    }

    public Double getPreviousExponentialAverageMs() {
        return this.previousExponentialAverageMs;
    }

    public Double getCurrentExponentialAverageMs() {
        if (this.previousExponentialAverageMs == null || this.latestTimestamp == null) {
            return this.incrementalMetricValueMs;
        }
        Instant currentWindowStartTimestamp = this.latestTimestamp.truncatedTo(WINDOW_UNIT);
        double alpha = Math.exp(-((double)Duration.between(currentWindowStartTimestamp, this.latestTimestamp).toMillis()) / (double)WINDOW_SIZE.toMillis());
        return alpha * this.previousExponentialAverageMs + (1.0 - alpha) * this.incrementalMetricValueMs;
    }

    public void increment(double metricValueDeltaMs) {
        this.incrementalMetricValueMs += metricValueDeltaMs;
    }

    public void setLatestTimestamp(Instant newLatestTimestamp) {
        Instant nextWindowStartTimestamp;
        Objects.requireNonNull(newLatestTimestamp);
        if (this.latestTimestamp != null && newLatestTimestamp.compareTo(nextWindowStartTimestamp = this.latestTimestamp.truncatedTo(WINDOW_UNIT).plus(WINDOW_SIZE)) >= 0) {
            this.previousExponentialAverageMs = this.getCurrentExponentialAverageMs();
            this.incrementalMetricValueMs = 0.0;
        }
        if (this.latestTimestamp == null || newLatestTimestamp.isAfter(this.latestTimestamp)) {
            this.latestTimestamp = newLatestTimestamp;
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.incrementalMetricValueMs);
        out.writeOptionalInstant(this.latestTimestamp);
        out.writeOptionalDouble(this.previousExponentialAverageMs);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INCREMENTAL_METRIC_VALUE_MS.getPreferredName(), this.incrementalMetricValueMs);
        if (this.latestTimestamp != null) {
            builder.timeField(LATEST_TIMESTAMP.getPreferredName(), LATEST_TIMESTAMP.getPreferredName() + "_string", this.latestTimestamp.toEpochMilli());
        }
        if (this.previousExponentialAverageMs != null) {
            builder.field(PREVIOUS_EXPONENTIAL_AVERAGE_MS.getPreferredName(), this.previousExponentialAverageMs);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExponentialAverageCalculationContext that = (ExponentialAverageCalculationContext)o;
        return this.incrementalMetricValueMs == that.incrementalMetricValueMs && Objects.equals(this.latestTimestamp, that.latestTimestamp) && Objects.equals(this.previousExponentialAverageMs, that.previousExponentialAverageMs);
    }

    public int hashCode() {
        return Objects.hash(this.incrementalMetricValueMs, this.latestTimestamp, this.previousExponentialAverageMs);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    private static <T> T getOrDefault(@Nullable T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    static {
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), INCREMENTAL_METRIC_VALUE_MS);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtils.parseTimeFieldToInstant(p, LATEST_TIMESTAMP.getPreferredName()), LATEST_TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), PREVIOUS_EXPONENTIAL_AVERAGE_MS);
        WINDOW_UNIT = ChronoUnit.HOURS;
        WINDOW_SIZE = WINDOW_UNIT.getDuration();
    }
}

