/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.results;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.Result;

public class ForecastRequestStats
implements ToXContentObject,
Writeable {
    public static final String RESULT_TYPE_VALUE = "model_forecast_request_stats";
    public static final ParseField RESULTS_FIELD = new ParseField("model_forecast_request_stats", new String[0]);
    public static final ParseField FORECAST_ID = new ParseField("forecast_id", new String[0]);
    public static final ParseField START_TIME = new ParseField("forecast_start_timestamp", new String[0]);
    public static final ParseField END_TIME = new ParseField("forecast_end_timestamp", new String[0]);
    public static final ParseField CREATE_TIME = new ParseField("forecast_create_timestamp", new String[0]);
    public static final ParseField EXPIRY_TIME = new ParseField("forecast_expiry_timestamp", new String[0]);
    public static final ParseField MESSAGES = new ParseField("forecast_messages", new String[0]);
    public static final ParseField PROCESSING_TIME_MS = new ParseField("processing_time_ms", new String[0]);
    public static final ParseField PROGRESS = new ParseField("forecast_progress", new String[0]);
    public static final ParseField PROCESSED_RECORD_COUNT = new ParseField("processed_record_count", new String[0]);
    public static final ParseField STATUS = new ParseField("forecast_status", new String[0]);
    public static final ParseField MEMORY_USAGE = new ParseField("forecast_memory_bytes", new String[0]);
    public static final ConstructingObjectParser<ForecastRequestStats, Void> STRICT_PARSER = ForecastRequestStats.createParser(false);
    public static final ConstructingObjectParser<ForecastRequestStats, Void> LENIENT_PARSER = ForecastRequestStats.createParser(true);
    private final String jobId;
    private final String forecastId;
    private long recordCount;
    private List<String> messages;
    private Instant timestamp = Instant.EPOCH;
    private Instant startTime = Instant.EPOCH;
    private Instant endTime = Instant.EPOCH;
    private Instant createTime = Instant.EPOCH;
    private Instant expiryTime = Instant.EPOCH;
    private double progress;
    private long processingTime;
    private long memoryUsage;
    private ForecastRequestStatus status = ForecastRequestStatus.OK;

    private static ConstructingObjectParser<ForecastRequestStats, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(RESULT_TYPE_VALUE, ignoreUnknownFields, a -> new ForecastRequestStats((String)a[0], (String)a[1]));
        parser.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        parser.declareString(ConstructingObjectParser.constructorArg(), FORECAST_ID);
        parser.declareString((modelForecastRequestStats, s) -> {}, Result.RESULT_TYPE);
        parser.declareLong(ForecastRequestStats::setRecordCount, PROCESSED_RECORD_COUNT);
        parser.declareStringArray(ForecastRequestStats::setMessages, MESSAGES);
        parser.declareField(ForecastRequestStats::setTimeStamp, p -> Instant.ofEpochMilli(p.longValue()), Result.TIMESTAMP, ObjectParser.ValueType.LONG);
        parser.declareField(ForecastRequestStats::setStartTime, p -> Instant.ofEpochMilli(p.longValue()), START_TIME, ObjectParser.ValueType.LONG);
        parser.declareField(ForecastRequestStats::setEndTime, p -> Instant.ofEpochMilli(p.longValue()), END_TIME, ObjectParser.ValueType.LONG);
        parser.declareField(ForecastRequestStats::setCreateTime, p -> Instant.ofEpochMilli(p.longValue()), CREATE_TIME, ObjectParser.ValueType.LONG);
        parser.declareField(ForecastRequestStats::setExpiryTime, p -> Instant.ofEpochMilli(p.longValue()), EXPIRY_TIME, ObjectParser.ValueType.LONG);
        parser.declareDouble(ForecastRequestStats::setProgress, PROGRESS);
        parser.declareLong(ForecastRequestStats::setProcessingTime, PROCESSING_TIME_MS);
        parser.declareField(ForecastRequestStats::setStatus, p -> ForecastRequestStatus.fromString(p.text()), STATUS, ObjectParser.ValueType.STRING);
        parser.declareLong(ForecastRequestStats::setMemoryUsage, MEMORY_USAGE);
        return parser;
    }

    public ForecastRequestStats(String jobId, String forecastId) {
        this.jobId = Objects.requireNonNull(jobId);
        this.forecastId = Objects.requireNonNull(forecastId);
    }

    public ForecastRequestStats(ForecastRequestStats forecastRequestStats) {
        this.jobId = forecastRequestStats.jobId;
        this.forecastId = forecastRequestStats.forecastId;
        this.recordCount = forecastRequestStats.recordCount;
        this.messages = forecastRequestStats.messages;
        this.timestamp = forecastRequestStats.timestamp;
        this.startTime = forecastRequestStats.startTime;
        this.endTime = forecastRequestStats.endTime;
        this.createTime = forecastRequestStats.createTime;
        this.expiryTime = forecastRequestStats.expiryTime;
        this.progress = forecastRequestStats.progress;
        this.processingTime = forecastRequestStats.processingTime;
        this.memoryUsage = forecastRequestStats.memoryUsage;
        this.status = forecastRequestStats.status;
    }

    public ForecastRequestStats(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.forecastId = in.readString();
        this.recordCount = in.readLong();
        this.messages = in.readBoolean() ? in.readStringList() : null;
        if (in.getVersion().onOrAfter(Version.V_7_4_0)) {
            this.timestamp = in.readInstant();
            this.startTime = in.readInstant();
            this.endTime = in.readInstant();
            this.createTime = in.readInstant();
            this.expiryTime = in.readInstant();
        } else {
            this.timestamp = Instant.ofEpochMilli(in.readVLong());
            this.startTime = Instant.ofEpochMilli(in.readVLong());
            this.endTime = Instant.ofEpochMilli(in.readVLong());
            this.createTime = Instant.ofEpochMilli(in.readVLong());
            this.expiryTime = Instant.ofEpochMilli(in.readVLong());
        }
        this.progress = in.readDouble();
        this.processingTime = in.readLong();
        this.setMemoryUsage(in.readLong());
        this.status = ForecastRequestStatus.readFromStream(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeString(this.forecastId);
        out.writeLong(this.recordCount);
        if (this.messages != null) {
            out.writeBoolean(true);
            out.writeStringCollection(this.messages);
        } else {
            out.writeBoolean(false);
        }
        if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
            out.writeInstant(this.timestamp);
            out.writeInstant(this.startTime);
            out.writeInstant(this.endTime);
            out.writeInstant(this.createTime);
            out.writeInstant(this.expiryTime);
        } else {
            out.writeVLong(this.timestamp.toEpochMilli());
            out.writeVLong(this.startTime.toEpochMilli());
            out.writeVLong(this.endTime.toEpochMilli());
            out.writeVLong(this.createTime.toEpochMilli());
            out.writeVLong(this.expiryTime.toEpochMilli());
        }
        out.writeDouble(this.progress);
        out.writeLong(this.processingTime);
        out.writeLong(this.getMemoryUsage());
        this.status.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        builder.field(FORECAST_ID.getPreferredName(), this.forecastId);
        builder.field(PROCESSED_RECORD_COUNT.getPreferredName(), this.recordCount);
        if (this.messages != null) {
            builder.field(MESSAGES.getPreferredName(), this.messages);
        }
        if (!this.timestamp.equals(Instant.EPOCH)) {
            builder.field(Result.TIMESTAMP.getPreferredName(), this.timestamp.toEpochMilli());
        }
        if (!this.startTime.equals(Instant.EPOCH)) {
            builder.field(START_TIME.getPreferredName(), this.startTime.toEpochMilli());
        }
        if (!this.endTime.equals(Instant.EPOCH)) {
            builder.field(END_TIME.getPreferredName(), this.endTime.toEpochMilli());
        }
        if (!this.createTime.equals(Instant.EPOCH)) {
            builder.field(CREATE_TIME.getPreferredName(), this.createTime.toEpochMilli());
        }
        if (!this.expiryTime.equals(Instant.EPOCH)) {
            builder.field(EXPIRY_TIME.getPreferredName(), this.expiryTime.toEpochMilli());
        }
        builder.field(PROGRESS.getPreferredName(), this.progress);
        builder.field(PROCESSING_TIME_MS.getPreferredName(), this.processingTime);
        builder.field(MEMORY_USAGE.getPreferredName(), this.getMemoryUsage());
        builder.field(STATUS.getPreferredName(), (Enum)this.status);
        builder.endObject();
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getForecastId() {
        return this.forecastId;
    }

    public static String documentId(String jobId, String forecastId) {
        return jobId + "_model_forecast_request_stats_" + forecastId;
    }

    public String getId() {
        return ForecastRequestStats.documentId(this.jobId, this.forecastId);
    }

    public void setRecordCount(long recordCount) {
        this.recordCount = recordCount;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    public void setTimeStamp(Instant timeStamp) {
        this.timestamp = Instant.ofEpochMilli(timeStamp.toEpochMilli());
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public void setStartTime(Instant startTime) {
        this.startTime = Instant.ofEpochMilli(startTime.toEpochMilli());
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Instant endTime) {
        this.endTime = Instant.ofEpochMilli(endTime.toEpochMilli());
    }

    public void setCreateTime(Instant createTime) {
        this.createTime = Instant.ofEpochMilli(createTime.toEpochMilli());
    }

    public Instant getCreateTime() {
        return this.createTime;
    }

    public void setExpiryTime(Instant expiryTime) {
        this.expiryTime = Instant.ofEpochMilli(expiryTime.toEpochMilli());
    }

    public Instant getExpiryTime() {
        return this.expiryTime;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(long processingTime) {
        this.processingTime = processingTime;
    }

    public long getMemoryUsage() {
        return this.memoryUsage;
    }

    public void setMemoryUsage(long memoryUsage) {
        this.memoryUsage = memoryUsage;
    }

    public ForecastRequestStatus getStatus() {
        return this.status;
    }

    public void setStatus(ForecastRequestStatus jobStatus) {
        Objects.requireNonNull(jobStatus, "[" + STATUS.getPreferredName() + "] must not be null");
        this.status = jobStatus;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ForecastRequestStats)) {
            return false;
        }
        ForecastRequestStats that = (ForecastRequestStats)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.forecastId, that.forecastId) && this.recordCount == that.recordCount && Objects.equals(this.messages, that.messages) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.endTime, that.endTime) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.expiryTime, that.expiryTime) && this.progress == that.progress && this.processingTime == that.processingTime && this.memoryUsage == that.memoryUsage && Objects.equals((Object)this.status, (Object)that.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.forecastId, this.recordCount, this.messages, this.timestamp, this.startTime, this.endTime, this.createTime, this.expiryTime, this.progress, this.processingTime, this.memoryUsage, this.status});
    }

    public static enum ForecastRequestStatus implements Writeable
    {
        OK,
        FAILED,
        STOPPED,
        STARTED,
        FINISHED,
        SCHEDULED;


        public static ForecastRequestStatus fromString(String statusName) {
            return ForecastRequestStatus.valueOf(statusName.trim().toUpperCase(Locale.ROOT));
        }

        public static ForecastRequestStatus readFromStream(StreamInput in) throws IOException {
            return (ForecastRequestStatus)in.readEnum(ForecastRequestStatus.class);
        }

        public boolean isAnyOf(ForecastRequestStatus ... candidates) {
            return Arrays.stream(candidates).anyMatch(candidate -> this == candidate);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

