/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.action.XPackUsageResponse;

public class TransportXPackUsageAction
extends TransportMasterNodeAction<XPackUsageRequest, XPackUsageResponse> {
    private final List<XPackFeatureSet> featureSets;

    @Inject
    public TransportXPackUsageAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Set<XPackFeatureSet> featureSets) {
        super("cluster:monitor/xpack/usage", transportService, clusterService, threadPool, actionFilters, XPackUsageRequest::new, indexNameExpressionResolver, XPackUsageResponse::new, "management");
        this.featureSets = Collections.unmodifiableList(new ArrayList<XPackFeatureSet>(featureSets));
    }

    protected void masterOperation(XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageResponse> listener) {
        throw new UnsupportedOperationException("The task parameter is required");
    }

    protected void masterOperation(final Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageResponse> listener) {
        new ActionRunnable<XPackUsageResponse>(listener){
            final List<XPackFeatureSet.Usage> responses;
            {
                super(arg0);
                this.responses = new ArrayList<XPackFeatureSet.Usage>(TransportXPackUsageAction.this.featureSets.size());
            }

            protected void doRun() throws Exception {
                if (this.responses.size() < TransportXPackUsageAction.this.featureSets.size()) {
                    assert (Transports.assertNotTransportThread((String)"calculating usage can be more expensive than we allow on transport threads"));
                    if (task instanceof CancellableTask && ((CancellableTask)task).isCancelled()) {
                        throw new CancellationException("Task cancelled");
                    }
                    ((XPackFeatureSet)TransportXPackUsageAction.this.featureSets.get(this.responses.size())).usage((ActionListener<XPackFeatureSet.Usage>)this.listener.delegateFailure((l, usage) -> {
                        this.responses.add((XPackFeatureSet.Usage)usage);
                        TransportXPackUsageAction.this.threadPool.executor("management").execute((Runnable)((Object)this));
                    }));
                } else {
                    assert (this.responses.size() == TransportXPackUsageAction.this.featureSets.size()) : this.responses.size() + " vs " + TransportXPackUsageAction.access$000(TransportXPackUsageAction.this).size();
                    this.listener.onResponse((Object)new XPackUsageResponse(this.responses));
                }
            }
        }.run();
    }

    protected ClusterBlockException checkBlock(XPackUsageRequest request, ClusterState state) {
        return null;
    }
}

