/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.InvalidAggregationPathException;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.support.AggregationPath;

public final class MlAggsHelper {
    private MlAggsHelper() {
    }

    public static InvalidAggregationPathException invalidPathException(List<String> path, String aggType, String aggName) {
        return new InvalidAggregationPathException("unknown property " + path + " for " + aggType + " aggregation [" + aggName + "]");
    }

    public static Optional<DoubleBucketValues> extractDoubleBucketedValues(String bucketPath, Aggregations aggregations) {
        List parsedPath = AggregationPath.parse((String)bucketPath).getPathElementsAsStringList();
        for (Aggregation aggregation : aggregations) {
            if (!aggregation.getName().equals(parsedPath.get(0))) continue;
            List sublistedPath = parsedPath.subList(1, parsedPath.size());
            InternalMultiBucketAggregation multiBucketsAgg = (InternalMultiBucketAggregation)aggregation;
            List buckets = multiBucketsAgg.getBuckets();
            ArrayList<Double> values = new ArrayList<Double>(buckets.size());
            ArrayList<Long> docCounts = new ArrayList<Long>(buckets.size());
            for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
                Double bucketValue = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)multiBucketsAgg, (InternalMultiBucketAggregation.InternalBucket)bucket, sublistedPath, (BucketHelpers.GapPolicy)BucketHelpers.GapPolicy.INSERT_ZEROS);
                if (bucketValue == null || Double.isNaN(bucketValue)) {
                    throw new AggregationExecutionException("missing or invalid bucket value found for path [" + bucketPath + "] in bucket [" + bucket.getKeyAsString() + "]");
                }
                values.add(bucketValue);
                docCounts.add(bucket.getDocCount());
            }
            return Optional.of(new DoubleBucketValues(docCounts.stream().mapToLong(Long::longValue).toArray(), values.stream().mapToDouble(Double::doubleValue).toArray()));
        }
        return Optional.empty();
    }

    public static class DoubleBucketValues {
        private final long[] docCounts;
        private final double[] values;

        public DoubleBucketValues(long[] docCounts, double[] values) {
            this.docCounts = docCounts;
            this.values = values;
        }

        public long[] getDocCounts() {
            return this.docCounts;
        }

        public double[] getValues() {
            return this.values;
        }
    }
}

