/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class MlConfigMigrationEligibilityCheck {
    private static final Version MIN_NODE_VERSION = Version.V_6_6_0;
    public static final Setting<Boolean> ENABLE_CONFIG_MIGRATION = Setting.boolSetting((String)"xpack.ml.enable_config_migration", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    private volatile boolean isConfigMigrationEnabled;

    public MlConfigMigrationEligibilityCheck(Settings settings, ClusterService clusterService) {
        this.isConfigMigrationEnabled = (Boolean)ENABLE_CONFIG_MIGRATION.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ENABLE_CONFIG_MIGRATION, this::setConfigMigrationEnabled);
    }

    private void setConfigMigrationEnabled(boolean configMigrationEnabled) {
        this.isConfigMigrationEnabled = configMigrationEnabled;
    }

    public boolean canStartMigration(ClusterState clusterState) {
        if (!this.isConfigMigrationEnabled) {
            return false;
        }
        Version minNodeVersion = clusterState.nodes().getMinNodeVersion();
        if (minNodeVersion.before(MIN_NODE_VERSION)) {
            return false;
        }
        return MlConfigMigrationEligibilityCheck.mlConfigIndexIsAllocated(clusterState);
    }

    static boolean mlConfigIndexIsAllocated(ClusterState clusterState) {
        IndexAbstraction configIndexOrAlias = (IndexAbstraction)clusterState.metadata().getIndicesLookup().get(MlConfigIndex.indexName());
        if (configIndexOrAlias == null) {
            return false;
        }
        IndexRoutingTable routingTable = clusterState.getRoutingTable().index(configIndexOrAlias.getWriteIndex());
        return routingTable != null && routingTable.allPrimaryShardsActive();
    }

    public boolean jobIsEligibleForMigration(String jobId, ClusterState clusterState) {
        if (!this.canStartMigration(clusterState)) {
            return false;
        }
        MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)clusterState);
        Job job = (Job)mlMetadata.getJobs().get(jobId);
        if (job == null || job.isDeleting()) {
            return false;
        }
        PersistentTasksCustomMetadata persistentTasks = (PersistentTasksCustomMetadata)clusterState.metadata().custom("persistent_tasks");
        return !MlTasks.openJobIds((PersistentTasksCustomMetadata)persistentTasks).contains(jobId) || MlTasks.unassignedJobIds((PersistentTasksCustomMetadata)persistentTasks, (DiscoveryNodes)clusterState.nodes()).contains(jobId);
    }

    public boolean datafeedIsEligibleForMigration(String datafeedId, ClusterState clusterState) {
        if (!this.canStartMigration(clusterState)) {
            return false;
        }
        MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)clusterState);
        if (!mlMetadata.getDatafeeds().containsKey(datafeedId)) {
            return false;
        }
        PersistentTasksCustomMetadata persistentTasks = (PersistentTasksCustomMetadata)clusterState.metadata().custom("persistent_tasks");
        return !MlTasks.startedDatafeedIds((PersistentTasksCustomMetadata)persistentTasks).contains(datafeedId) || MlTasks.unassignedDatafeedIds((PersistentTasksCustomMetadata)persistentTasks, (DiscoveryNodes)clusterState.nodes()).contains(datafeedId);
    }
}

