/*
 * Decompiled with CFR 0.152.
 */
package org.testng.log4testng;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Logger {
    private static int i = 0;
    private static final int TRACE = i++;
    private static final int DEBUG = i++;
    private static final int INFO = i++;
    private static final int WARN = i++;
    private static final int ERROR = i++;
    private static final int FATAL = i++;
    private static final int LEVEL_COUNT = i;
    private static final String[] levelNames = new String[LEVEL_COUNT];
    private static final Map<String, Integer> levelMap;
    private static boolean initialized;
    private static final Properties properties;
    private static final Map<Class, Logger> loggers;
    private final int level;
    private final Class klass;

    public static synchronized Logger getLogger(Class pClass) {
        Logger.initialize();
        Logger logger = loggers.get(pClass);
        if (logger != null) {
            return logger;
        }
        int level = Logger.getLevel(pClass);
        logger = new Logger(pClass, level);
        loggers.put(pClass, logger);
        return logger;
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(TRACE);
    }

    public void trace(Object message) {
        this.log(TRACE, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.log(TRACE, message, t);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(DEBUG);
    }

    public void debug(Object message) {
        this.log(DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.log(DEBUG, message, t);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(INFO);
    }

    public void info(Object message) {
        this.log(INFO, message, null);
    }

    public void info(Object message, Throwable t) {
        this.log(INFO, message, t);
    }

    public void warn(Object message) {
        this.log(WARN, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.log(WARN, message, t);
    }

    public void error(Object message) {
        this.log(ERROR, message, null);
    }

    public void error(Object message, Throwable t) {
        this.log(ERROR, message, t);
    }

    public void fatal(Object message) {
        this.log(FATAL, message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.log(FATAL, message, t);
    }

    private Logger(Class pClass, int pLevel) {
        this.level = pLevel;
        this.klass = pClass;
    }

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("log4testng.properties");
        if (is == null) {
            return;
        }
        try {
            properties.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getLevel(Class pClass) {
        String name = pClass.getName();
        while (true) {
            String level;
            if ((level = properties.getProperty("log4testng.logger." + name)) != null) {
                Integer ilevel = levelMap.get(level.toUpperCase());
                if (ilevel == null) {
                    throw new IllegalArgumentException("Unknown level in log4testng.properties");
                }
                return ilevel;
            }
            int dot = name.lastIndexOf(46);
            if (dot != -1) {
                return WARN;
            }
            name = name.substring(0, dot);
        }
    }

    private boolean isLevelEnabled(int pLevel) {
        return this.level <= pLevel;
    }

    private void log(int pLevel, Object pMessage, Throwable pT) {
        if (this.isLevelEnabled(pLevel)) {
            PrintStream ps = pLevel >= ERROR ? System.err : System.out;
            ps.println("[" + this.klass.getName() + "] [" + levelNames[this.level] + "] " + pMessage);
            if (pT != null) {
                pT.printStackTrace(ps);
            }
        }
    }

    static {
        Logger.levelNames[Logger.TRACE] = "TRACE";
        Logger.levelNames[Logger.DEBUG] = "DEBUG";
        Logger.levelNames[Logger.INFO] = "INFO";
        Logger.levelNames[Logger.WARN] = "WARN";
        Logger.levelNames[Logger.ERROR] = "ERROR";
        Logger.levelNames[Logger.FATAL] = "FATAL";
        levelMap = new HashMap<String, Integer>();
        for (i = 0; i < LEVEL_COUNT; ++i) {
            levelMap.put(levelNames[i], new Integer(i));
        }
        properties = new Properties();
        loggers = new HashMap<Class, Logger>();
    }
}

