/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.ITestNGMethod;
import org.testng.internal.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationGroupMethods
implements Serializable {
    private Map<String, List<ITestNGMethod>> m_beforeGroupsMethods = new HashMap<String, List<ITestNGMethod>>();
    private Map<String, List<ITestNGMethod>> m_afterGroupsMethods = new HashMap<String, List<ITestNGMethod>>();
    private ITestNGMethod[] m_allMethods;
    private Map<String, ITestNGMethod> m_afterGroupsMap = null;

    public ConfigurationGroupMethods(ITestNGMethod[] allMethods) {
        this.m_allMethods = allMethods;
    }

    public boolean isLastMethodForGroup(String group, ITestNGMethod method) {
        if (this.m_afterGroupsMap == null) {
            this.m_afterGroupsMap = new HashMap<String, ITestNGMethod>();
            for (ITestNGMethod m : this.m_allMethods) {
                String[] groups;
                for (String g : groups = m.getGroups()) {
                    this.m_afterGroupsMap.put(g, m);
                }
            }
        }
        return this.m_afterGroupsMap.get(group) == method;
    }

    public synchronized void removeBeforeMethod(String group, ITestNGMethod method) {
        List<ITestNGMethod> methods = this.m_beforeGroupsMethods.get(group);
        if (methods != null) {
            Boolean success = methods.remove(method);
            if (success == null) {
                this.log("Couldn't remove beforeGroups method " + method + " for group " + group);
            }
        } else {
            this.log("Couldn't find any beforeGroups method for group " + group);
        }
    }

    private synchronized void log(String string) {
        Utils.log("ConfigurationGroupMethods", 2, string);
    }

    public synchronized Map<String, List<ITestNGMethod>> getBeforeGroupsMap() {
        return this.m_beforeGroupsMethods;
    }

    public synchronized Map<String, List<ITestNGMethod>> getAfterGroupsMap() {
        return this.m_afterGroupsMethods;
    }

    public synchronized List<ITestNGMethod> getBeforeGroupsMethods() {
        return this.unique(this.m_beforeGroupsMethods.values());
    }

    public synchronized List<ITestNGMethod> getAfterGroupsMethods() {
        return this.unique(this.m_afterGroupsMethods.values());
    }

    private synchronized List<ITestNGMethod> unique(Collection<List<ITestNGMethod>> name) {
        HashMap<ITestNGMethod, ITestNGMethod> vResult = new HashMap<ITestNGMethod, ITestNGMethod>();
        for (List<ITestNGMethod> l : name) {
            for (ITestNGMethod m : l) {
                vResult.put(m, m);
            }
        }
        ArrayList<ITestNGMethod> result = new ArrayList<ITestNGMethod>();
        result.addAll(vResult.values());
        return result;
    }

    public synchronized void removeBeforeGroups(String[] groups) {
        for (String group : groups) {
            this.m_beforeGroupsMethods.remove(group);
        }
    }

    public synchronized void removeAfterGroups(Collection<String> groups) {
        for (String group : groups) {
            this.m_afterGroupsMethods.remove(group);
        }
    }
}

