/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.javadraw;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jhotdraw.applet.DrawApplet;
import org.jhotdraw.contrib.DiamondFigure;
import org.jhotdraw.contrib.PolygonTool;
import org.jhotdraw.contrib.TriangleFigure;
import org.jhotdraw.figures.BorderTool;
import org.jhotdraw.figures.ConnectedTextTool;
import org.jhotdraw.figures.ElbowConnection;
import org.jhotdraw.figures.EllipseFigure;
import org.jhotdraw.figures.LineConnection;
import org.jhotdraw.figures.LineFigure;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.figures.RoundRectangleFigure;
import org.jhotdraw.figures.ScribbleTool;
import org.jhotdraw.figures.TextFigure;
import org.jhotdraw.figures.TextTool;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.samples.javadraw.Animator;
import org.jhotdraw.samples.javadraw.BouncingDrawing;
import org.jhotdraw.samples.javadraw.URLTool;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.standard.ConnectionTool;
import org.jhotdraw.standard.CreationTool;
import org.jhotdraw.util.Animatable;

public class JavaDrawApplet
extends DrawApplet {
    private transient JButton fAnimationButton;
    private transient Animator fAnimator;

    public void destroy() {
        super.destroy();
        this.endAnimation();
    }

    protected void createTools(JPanel jPanel) {
        super.createTools(jPanel);
        AbstractTool abstractTool = new TextTool(this, new TextFigure());
        jPanel.add(this.createToolButton("/org/jhotdraw/images/TEXT", "Text Tool", abstractTool));
        abstractTool = new ConnectedTextTool(this, new TextFigure());
        jPanel.add(this.createToolButton("/org/jhotdraw/images/ATEXT", "Connected Text Tool", abstractTool));
        abstractTool = new URLTool(this);
        jPanel.add(this.createToolButton("/org/jhotdraw/images/URL", "URL Tool", abstractTool));
        abstractTool = new CreationTool(this, new RectangleFigure());
        jPanel.add(this.createToolButton("/org/jhotdraw/images/RECT", "Rectangle Tool", abstractTool));
        abstractTool = new CreationTool(this, new RoundRectangleFigure());
        jPanel.add(this.createToolButton("/org/jhotdraw/images/RRECT", "Round Rectangle Tool", abstractTool));
        abstractTool = new CreationTool(this, new EllipseFigure());
        jPanel.add(this.createToolButton("/org/jhotdraw/images/ELLIPSE", "Ellipse Tool", abstractTool));
        abstractTool = new PolygonTool(this);
        jPanel.add(this.createToolButton("/org/jhotdraw/images/POLYGON", "Polygon Tool", abstractTool));
        abstractTool = new CreationTool(this, new TriangleFigure());
        jPanel.add(this.createToolButton("/org/jhotdraw/images/TRIANGLE", "Triangle Tool", abstractTool));
        abstractTool = new CreationTool(this, new DiamondFigure());
        jPanel.add(this.createToolButton("/org/jhotdraw/images/DIAMOND", "Diamond Tool", abstractTool));
        abstractTool = new CreationTool(this, new LineFigure());
        jPanel.add(this.createToolButton("/org/jhotdraw/images/LINE", "Line Tool", abstractTool));
        abstractTool = new ConnectionTool(this, new LineConnection());
        jPanel.add(this.createToolButton("/org/jhotdraw/images/CONN", "Connection Tool", abstractTool));
        abstractTool = new ConnectionTool(this, new ElbowConnection());
        jPanel.add(this.createToolButton("/org/jhotdraw/images/OCONN", "Elbow Connection Tool", abstractTool));
        abstractTool = new ScribbleTool(this);
        jPanel.add(this.createToolButton("/org/jhotdraw/images/SCRIBBL", "Scribble Tool", abstractTool));
        abstractTool = new PolygonTool(this);
        jPanel.add(this.createToolButton("/org/jhotdraw/images/POLYGON", "Polygon Tool", abstractTool));
        abstractTool = new BorderTool(this);
        jPanel.add(this.createToolButton("/org/jhotdraw/images/BORDDEC", "Border Tool", abstractTool));
    }

    protected void createButtons(JPanel jPanel) {
        super.createButtons(jPanel);
        this.fAnimationButton = new JButton("Start Animation");
        this.fAnimationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaDrawApplet.this.toggleAnimation();
            }
        });
        jPanel.add(this.fAnimationButton);
    }

    protected Drawing createDrawing() {
        return new BouncingDrawing();
    }

    public void startAnimation() {
        if (this.drawing() instanceof Animatable && this.fAnimator == null) {
            this.fAnimator = new Animator((Animatable)((Object)this.drawing()), this.view());
            this.fAnimator.start();
            this.fAnimationButton.setText("End Animation");
        }
    }

    public void endAnimation() {
        if (this.fAnimator != null) {
            this.fAnimator.end();
            this.fAnimator = null;
            this.fAnimationButton.setText("Start Animation");
        }
    }

    public void toggleAnimation() {
        if (this.fAnimator != null) {
            this.endAnimation();
        } else {
            this.startAnimation();
        }
    }
}

