/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.javadraw;

import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.util.Animatable;

public class Animator
extends Thread {
    private DrawingView fView;
    private Animatable fAnimatable;
    private volatile boolean fIsRunning;
    private static final int DELAY = 62;

    public Animator(Animatable animatable, DrawingView drawingView) {
        super("Animator");
        this.fView = drawingView;
        this.fAnimatable = animatable;
    }

    public void start() {
        super.start();
        this.fIsRunning = true;
    }

    public void end() {
        this.fIsRunning = false;
    }

    public void run() {
        while (this.fIsRunning) {
            long l = System.currentTimeMillis();
            this.fView.freezeView();
            this.fAnimatable.animationStep();
            this.fView.checkDamage();
            this.fView.unfreezeView();
            try {
                Thread.sleep(Math.max(0L, (l += 62L) - System.currentTimeMillis()));
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }
}

