/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.jhotdraw.figures.FigureAttributes;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.standard.AbstractFigure;
import org.jhotdraw.util.ColorMap;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public abstract class AttributeFigure
extends AbstractFigure {
    private FigureAttributes fAttributes;
    private static FigureAttributes fgDefaultAttributes = null;
    private static final long serialVersionUID = -10857585979273442L;
    private int attributeFigureSerializedDataVersion = 1;

    protected AttributeFigure() {
    }

    public void draw(Graphics graphics) {
        Color color;
        Color color2 = this.getFillColor();
        if (!ColorMap.isTransparent(color2)) {
            graphics.setColor(color2);
            this.drawBackground(graphics);
        }
        if (!ColorMap.isTransparent(color = this.getFrameColor())) {
            graphics.setColor(color);
            this.drawFrame(graphics);
        }
    }

    protected void drawBackground(Graphics graphics) {
    }

    protected void drawFrame(Graphics graphics) {
    }

    public Color getFillColor() {
        return (Color)this.getAttribute(FigureAttributeConstant.FILL_COLOR);
    }

    public Color getFrameColor() {
        return (Color)this.getAttribute(FigureAttributeConstant.FRAME_COLOR);
    }

    private static void initializeAttributes() {
        fgDefaultAttributes = new FigureAttributes();
        fgDefaultAttributes.set(FigureAttributeConstant.FRAME_COLOR, Color.black);
        fgDefaultAttributes.set(FigureAttributeConstant.FILL_COLOR, new Color(7396243));
        fgDefaultAttributes.set(FigureAttributeConstant.TEXT_COLOR, Color.black);
        fgDefaultAttributes.set(FigureAttributeConstant.ARROW_MODE, new Integer(0));
        fgDefaultAttributes.set(FigureAttributeConstant.FONT_NAME, "Helvetica");
        fgDefaultAttributes.set(FigureAttributeConstant.FONT_SIZE, new Integer(12));
        fgDefaultAttributes.set(FigureAttributeConstant.FONT_STYLE, new Integer(0));
    }

    public static Object setDefaultAttribute(String string, Object object) {
        Object object2 = AttributeFigure.getDefaultAttribute(string);
        fgDefaultAttributes.set(FigureAttributeConstant.getConstant(string), object);
        return object2;
    }

    public static Object initDefaultAttribute(String string, Object object) {
        Object object2 = AttributeFigure.getDefaultAttribute(string);
        if (object2 != null) {
            return object2;
        }
        fgDefaultAttributes.set(FigureAttributeConstant.getConstant(string), object);
        return null;
    }

    public static Object getDefaultAttribute(String string) {
        if (fgDefaultAttributes == null) {
            AttributeFigure.initializeAttributes();
        }
        return fgDefaultAttributes.get(FigureAttributeConstant.getConstant(string));
    }

    public static Object getDefaultAttribute(FigureAttributeConstant figureAttributeConstant) {
        if (fgDefaultAttributes == null) {
            AttributeFigure.initializeAttributes();
        }
        return fgDefaultAttributes.get(figureAttributeConstant);
    }

    public Object getAttribute(String string) {
        return this.getAttribute(FigureAttributeConstant.getConstant(string));
    }

    public Object getAttribute(FigureAttributeConstant figureAttributeConstant) {
        if (this.fAttributes != null && this.fAttributes.hasDefined(figureAttributeConstant)) {
            return this.fAttributes.get(figureAttributeConstant);
        }
        return AttributeFigure.getDefaultAttribute(figureAttributeConstant);
    }

    public void setAttribute(String string, Object object) {
        this.setAttribute(FigureAttributeConstant.getConstant(string), object);
    }

    public void setAttribute(FigureAttributeConstant figureAttributeConstant, Object object) {
        if (this.fAttributes == null) {
            this.fAttributes = new FigureAttributes();
        }
        this.fAttributes.set(figureAttributeConstant, object);
        this.changed();
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        if (this.fAttributes == null) {
            storableOutput.writeString("no_attributes");
        } else {
            storableOutput.writeString("attributes");
            this.fAttributes.write(storableOutput);
        }
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        String string = storableInput.readString();
        if (string.toLowerCase().equals("attributes")) {
            this.fAttributes = new FigureAttributes();
            this.fAttributes.read(storableInput);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object = this.getAttribute("POPUP_MENU");
        if (object != null) {
            this.setAttribute("POPUP_MENU", null);
        }
        objectOutputStream.defaultWriteObject();
        if (object != null) {
            this.setAttribute("POPUP_MENU", object);
        }
    }
}

