/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.RelativeAuthorityRanker;
import edu.uci.ics.jung.graph.DirectedGraph;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KStepMarkov<V, E>
extends RelativeAuthorityRanker<V, E> {
    public static final String RANK_SCORE = "jung.algorithms.importance.KStepMarkovExperimental.RankScore";
    private static final String CURRENT_RANK = "jung.algorithms.importance.KStepMarkovExperimental.CurrentRank";
    private int mNumSteps;
    HashMap<V, Number> mPreviousRankingsMap;

    public KStepMarkov(DirectedGraph<V, E> graph, Set<V> priors, int k, Map<E, Number> edgeWeights) {
        super.initialize(graph, true, false);
        this.mNumSteps = k;
        this.setPriors(priors);
        this.initializeRankings();
        if (edgeWeights == null) {
            this.assignDefaultEdgeTransitionWeights();
        } else {
            this.setEdgeWeights(edgeWeights);
        }
        this.normalizeEdgeTransitionWeights();
    }

    @Override
    public String getRankScoreKey() {
        return RANK_SCORE;
    }

    protected void incrementRankScore(V v, double rankValue) {
        double value = this.getVertexRankScore(v, RANK_SCORE);
        this.setVertexRankScore(v, value += rankValue, RANK_SCORE);
    }

    protected double getCurrentRankScore(V v) {
        return this.getVertexRankScore(v, CURRENT_RANK);
    }

    protected void setCurrentRankScore(V v, double rankValue) {
        this.setVertexRankScore(v, rankValue, CURRENT_RANK);
    }

    protected void initializeRankings() {
        this.mPreviousRankingsMap = new HashMap();
        for (Object v : this.getVertices()) {
            Set priors = this.getPriors();
            double numPriors = priors.size();
            if (this.getPriors().contains(v)) {
                this.setVertexRankScore(v, 1.0 / numPriors);
                this.setCurrentRankScore(v, 1.0 / numPriors);
                this.mPreviousRankingsMap.put((Number)v, 1.0 / numPriors);
                continue;
            }
            this.setVertexRankScore(v, 0.0);
            this.setCurrentRankScore(v, 0.0);
            this.mPreviousRankingsMap.put((Number)v, 0);
        }
    }

    @Override
    public void step() {
        for (int i = 0; i < this.mNumSteps; ++i) {
            this.updateRankings();
            for (Object v : this.getVertices()) {
                double currentRankScore = this.getCurrentRankScore(v);
                this.incrementRankScore(v, currentRankScore);
                this.mPreviousRankingsMap.put((Number)v, currentRankScore);
            }
        }
        this.normalizeRankings();
    }

    protected void updateRankings() {
        for (Object v : this.getVertices()) {
            Collection incomingEdges = this.getGraph().getInEdges(v);
            double currentPageRankSum = 0.0;
            for (Object e : incomingEdges) {
                double currentWeight = this.getEdgeWeight(e);
                currentPageRankSum += this.mPreviousRankingsMap.get(this.getGraph().getOpposite(v, e)).doubleValue() * currentWeight;
            }
            this.setCurrentRankScore(v, currentPageRankSum);
        }
    }
}

