/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.statistics.distribution;

import Jama.Matrix;
import org.openimaj.math.statistics.distribution.AbstractMultivariateGaussian;

public class SphericalMultivariateGaussian
extends AbstractMultivariateGaussian {
    public double variance = 1.0;

    public SphericalMultivariateGaussian(Matrix mean, double variance) {
        this.mean = mean;
        this.variance = variance;
    }

    public SphericalMultivariateGaussian(int ndims) {
        this.mean = new Matrix(1, ndims);
    }

    @Override
    public Matrix getCovariance() {
        int d = this.mean.getColumnDimension();
        return Matrix.identity((int)d, (int)d).timesEquals(this.variance);
    }

    @Override
    public double getCovariance(int row, int col) {
        if (row < 0 || row >= this.mean.getColumnDimension() || col < 0 || col > this.mean.getColumnDimension()) {
            throw new IndexOutOfBoundsException();
        }
        if (row == col) {
            return this.variance;
        }
        return 0.0;
    }
}

